/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.ConstructorHeaderCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ConstructorHeaderCallChecker
implements CallChecker {
    public static final ConstructorHeaderCallChecker INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        ClassDescriptor labelReferenceClass;
        ClassDescriptor classDescriptor2;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ClassDescriptor dispatchReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall2.getDispatchReceiver());
        ClassDescriptor extensionReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall2.getExtensionReceiver());
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callElement");
        KtElement callElement = ktElement;
        if (callElement instanceof KtInstanceExpressionWithLabel) {
            Object v = context2.getTrace().get(BindingContext.REFERENCE_TARGET, ((KtInstanceExpressionWithLabel)callElement).getInstanceReference());
            if (!(v instanceof ClassDescriptor)) {
                v = null;
            }
            classDescriptor2 = (ClassDescriptor)v;
        } else {
            classDescriptor2 = labelReferenceClass = null;
        }
        if (dispatchReceiverClass == null && extensionReceiverClass == null && labelReferenceClass == null) {
            return;
        }
        Set<ClassDescriptor> classes2 = SetsKt.setOf(dispatchReceiverClass, extensionReceiverClass, labelReferenceClass);
        Sequence<HierarchicalScope> $this$any$iv = ScopeUtilsKt.getParentsWithSelf(context2.getScope());
        boolean $i$f$any = false;
        Iterator<HierarchicalScope> iterator2 = $this$any$iv.iterator();
        do {
            HierarchicalScope element$iv;
            if (!iterator2.hasNext()) return;
            HierarchicalScope scope2 = element$iv = iterator2.next();
            boolean bl2 = false;
            if (scope2 instanceof LexicalScope && ((LexicalScope)scope2).getKind() == LexicalScopeKind.CONSTRUCTOR_HEADER) {
                DeclarationDescriptor declarationDescriptor = ((LexicalScope)scope2).getOwnerDescriptor();
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
                }
                if (classes2.contains(((ClassConstructorDescriptor)declarationDescriptor).getContainingDeclaration())) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        boolean bl3 = true;
        if (!bl3) return;
        context2.getTrace().report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(reportOn, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
    }

    private ConstructorHeaderCallChecker() {
    }

    static {
        ConstructorHeaderCallChecker constructorHeaderCallChecker;
        INSTANCE = constructorHeaderCallChecker = new ConstructorHeaderCallChecker();
    }
}

