/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.inline.FunctionInliningKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "SharedVariablesTransformer", "ir.backend.common"})
public final class SharedVariablesLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        if (container instanceof IrFunction || container instanceof IrField || container instanceof IrAnonymousInitializer) {
            new SharedVariablesTransformer(irBody, container).lowerSharedVariables();
        }
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public SharedVariablesLowering(@NotNull BackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering$SharedVariablesTransformer;", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;Lorg/jetbrains/kotlin/ir/expressions/IrBody;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getIrBody", "()Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "getIrDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "sharedVariables", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "collectSharedVariables", "", "lowerSharedVariables", "rewriteSharedVariables", "ir.backend.common"})
    private final class SharedVariablesTransformer {
        private final HashSet<IrVariable> sharedVariables;
        @NotNull
        private final IrBody irBody;
        @NotNull
        private final IrDeclaration irDeclaration;

        public final void lowerSharedVariables() {
            this.collectSharedVariables();
            if (this.sharedVariables.isEmpty()) {
                return;
            }
            this.rewriteSharedVariables();
        }

        private final void collectSharedVariables() {
            IrDeclarationParent irDeclarationParent;
            boolean bl = false;
            Map skippedFunctionsParents = new LinkedHashMap();
            IrElementVisitor irElementVisitor = new IrElementVisitor<Unit, IrDeclarationParent>(this, skippedFunctionsParents){
                @NotNull
                private final HashSet<IrVariable> relevantVars;
                @NotNull
                private final HashSet<IrVariable> relevantVals;
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ Map $skippedFunctionsParents;

                @NotNull
                public final HashSet<IrVariable> getRelevantVars() {
                    return this.relevantVars;
                }

                @NotNull
                public final HashSet<IrVariable> getRelevantVals() {
                    return this.relevantVals;
                }

                public void visitElement(@NotNull IrElement element, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    element.acceptChildren(this, data);
                }

                public void visitCall(@NotNull IrCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrFunction callee = expression2.getSymbol().getOwner();
                    if (!callee.isInline()) {
                        IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
                        return;
                    }
                    IrExpression irExpression = expression2.getDispatchReceiver();
                    if (irExpression != null) {
                        Unit cfr_ignored_0 = (Unit)irExpression.accept(this, data);
                    }
                    IrExpression irExpression2 = expression2.getExtensionReceiver();
                    if (irExpression2 != null) {
                        Unit cfr_ignored_1 = (Unit)irExpression2.accept(this, data);
                    }
                    for (IrValueParameter param : callee.getValueParameters()) {
                        IrExpression arg;
                        if (expression2.getValueArgument(param.getIndex()) == null) {
                            continue;
                        }
                        if (FunctionInliningKt.isInlineParameter$default(param, null, 1, null) && !param.isCrossinline() && arg instanceof IrFunctionExpression) {
                            IrSimpleFunction irSimpleFunction = ((IrFunctionExpression)arg).getFunction();
                            IrDeclarationParent irDeclarationParent = data;
                            Intrinsics.checkNotNull(irDeclarationParent);
                            this.$skippedFunctionsParents.put(irSimpleFunction, irDeclarationParent);
                            ((IrFunctionExpression)arg).getFunction().acceptChildren(this, data);
                            this.$skippedFunctionsParents.remove(((IrFunctionExpression)arg).getFunction());
                            continue;
                        }
                        arg.accept(this, data);
                    }
                }

                public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable IrDeclarationParent data) {
                    IrDeclarationParent irDeclarationParent;
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrDeclaration irDeclaration2 = declaration2;
                    if (!(irDeclaration2 instanceof IrDeclarationParent)) {
                        irDeclaration2 = null;
                    }
                    if ((irDeclarationParent = (IrDeclarationParent)((Object)irDeclaration2)) == null) {
                        irDeclarationParent = data;
                    }
                    IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration2, irDeclarationParent);
                }

                public void visitVariable(@NotNull IrVariable declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    declaration2.acceptChildren(this, data);
                    if (declaration2.isVar()) {
                        this.relevantVars.add(declaration2);
                    } else if (declaration2.getInitializer() == null) {
                        this.relevantVals.add(declaration2);
                    }
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    expression2.acceptChildren(this, data);
                    IrValueDeclaration value2 = expression2.getSymbol().getOwner();
                    if (CollectionsKt.contains((Iterable)this.relevantVars, value2)) {
                        IrValueDeclaration irValueDeclaration = value2;
                        if (irValueDeclaration == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                        }
                        if (Intrinsics.areEqual(this.getRealParent((IrVariable)irValueDeclaration), data) ^ true) {
                            SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(value2);
                        }
                    }
                }

                public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSetVariable(this, expression2, data);
                    IrVariable variable2 = (IrVariable)expression2.getSymbol().getOwner();
                    if (variable2.getInitializer() == null && Intrinsics.areEqual(this.getRealParent(variable2), data) ^ true && this.relevantVals.contains(variable2)) {
                        SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(variable2);
                    }
                }

                private final IrDeclarationParent getRealParent(IrVariable variable2) {
                    IrDeclarationParent irDeclarationParent = variable2.getParent();
                    boolean bl = false;
                    boolean bl2 = false;
                    IrDeclarationParent it = irDeclarationParent;
                    boolean bl3 = false;
                    Map map2 = this.$skippedFunctionsParents;
                    boolean bl4 = false;
                    IrDeclarationParent irDeclarationParent2 = (IrDeclarationParent)map2.get(it);
                    if (irDeclarationParent2 == null) {
                        irDeclarationParent2 = it;
                    }
                    return irDeclarationParent2;
                }
                {
                    this.this$0 = this$0;
                    this.$skippedFunctionsParents = $captured_local_variable$1;
                    this.relevantVars = new HashSet<E>();
                    this.relevantVals = new HashSet<E>();
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                }

                public void visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(body2, "body");
                    IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBody(@NotNull IrBody body2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(body2, "body");
                    IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(branch, "branch");
                    IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(jump, "jump");
                    IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(jump, "jump");
                    IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(aCatch, "aCatch");
                    IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(@NotNull IrClass declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitClass(this, declaration2, data);
                }

                public void visitClassReference(@NotNull IrClassReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitComposite(@NotNull IrComposite expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitConstructor(this, declaration2, data);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(jump, "jump");
                    IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(loop2, "loop");
                    IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(branch, "branch");
                    IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration2, data);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitExpression(@NotNull IrExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(body2, "body");
                    IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                }

                public void visitField(@NotNull IrField declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitField(this, declaration2, data);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFile(@NotNull IrFile declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitFile(this, declaration2, data);
                }

                public void visitFunction(@NotNull IrFunction declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitFunction(this, declaration2, data);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitGetClass(@NotNull IrGetClass expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetField(@NotNull IrGetField expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLoop(@NotNull IrLoop loop2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(loop2, "loop");
                    IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration2, data);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration2, data);
                }

                public void visitProperty(@NotNull IrProperty declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitProperty(this, declaration2, data);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                }

                public void visitReturn(@NotNull IrReturn expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitScript(@NotNull IrScript declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitScript(this, declaration2, data);
                }

                public void visitSetField(@NotNull IrSetField expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(spread, "spread");
                    IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(body2, "body");
                    IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitThrow(@NotNull IrThrow expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(aTry, "aTry");
                    IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration2, data);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration2, data);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration2, data);
                }

                public void visitVararg(@NotNull IrVararg expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter(loop2, "loop");
                    IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            };
            IrDeclaration irDeclaration2 = this.irDeclaration;
            if (!(irDeclaration2 instanceof IrDeclarationParent)) {
                irDeclaration2 = null;
            }
            if ((irDeclarationParent = (IrDeclarationParent)((Object)irDeclaration2)) == null) {
                irDeclarationParent = this.irDeclaration.getParent();
            }
            this.irBody.accept(irElementVisitor, irDeclarationParent);
        }

        private final void rewriteSharedVariables() {
            HashMap transformedSymbols = new HashMap();
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(this, transformedSymbols){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ HashMap $transformedSymbols;

                @NotNull
                public IrStatement visitVariable(@NotNull IrVariable declaration2) {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                    if (!SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).contains(declaration2)) {
                        return declaration2;
                    }
                    IrVariable newDeclaration = this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().declareSharedVariable(declaration2);
                    newDeclaration.setParent(declaration2.getParent());
                    ((Map)this.$transformedSymbols).put(declaration2.getSymbol(), newDeclaration.getSymbol());
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().defineSharedValue(declaration2, newDeclaration);
                }
                {
                    this.this$0 = this$0;
                    this.$transformedSymbols = $captured_local_variable$1;
                }
            });
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(this, transformedSymbols){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ HashMap $transformedSymbols;

                @NotNull
                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().getSharedValue(newDeclaration, expression2);
                }

                @NotNull
                public IrExpression visitSetVariable(@NotNull IrSetVariable expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().setSharedValue(newDeclaration, expression2);
                }

                private final IrVariableSymbol getTransformedSymbol(IrValueSymbol oldSymbol) {
                    Map map2 = this.$transformedSymbols;
                    boolean bl = false;
                    V v = map2.get(oldSymbol);
                    if (v == null) {
                        boolean bl2 = false;
                        boolean bl3 = !CollectionsKt.contains(SharedVariablesTransformer.access$getSharedVariables$p(this.this$0), oldSymbol.getOwner());
                        boolean bl4 = false;
                        if (_Assertions.ENABLED && !bl3) {
                            boolean bl5 = false;
                            String string2 = "Shared variable is not transformed: " + DumpIrTreeKt.dump$default(oldSymbol.getOwner(), false, 1, null);
                            throw (Throwable)((Object)new AssertionError((Object)string2));
                        }
                        v = null;
                    }
                    return (IrVariableSymbol)v;
                }
                {
                    this.this$0 = this$0;
                    this.$transformedSymbols = $captured_local_variable$1;
                }
            });
        }

        @NotNull
        public final IrBody getIrBody() {
            return this.irBody;
        }

        @NotNull
        public final IrDeclaration getIrDeclaration() {
            return this.irDeclaration;
        }

        public SharedVariablesTransformer(@NotNull IrBody irBody, IrDeclaration irDeclaration2) {
            Intrinsics.checkNotNullParameter(irBody, "irBody");
            Intrinsics.checkNotNullParameter(irDeclaration2, "irDeclaration");
            this.irBody = irBody;
            this.irDeclaration = irDeclaration2;
            this.sharedVariables = new HashSet();
        }

        public static final /* synthetic */ HashSet access$getSharedVariables$p(SharedVariablesTransformer $this) {
            return $this.sharedVariables;
        }
    }
}

