/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a:\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u00020\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"canHaveSideEffects", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getCanHaveSideEffects", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Z", "constLongValue", "", "getConstLongValue", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Ljava/lang/Long;", "createTemporaryVariableIfNecessary", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "expression", "nameHint", "", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "decrement", "negate", "ir.backend.common"})
public final class UtilsKt {
    @NotNull
    public static final IrExpression negate(@NotNull IrExpression $this$negate) {
        IrExpressionBase irExpressionBase;
        Number value2;
        Intrinsics.checkNotNullParameter($this$negate, "$this$negate");
        IrExpression irExpression = $this$negate;
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        Object object = irConst != null ? irConst.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        if ((value2 = (Number)object) instanceof Integer) {
            irExpressionBase = new IrConstImpl<Integer>($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Int.INSTANCE, -value2.intValue());
        } else if (value2 instanceof Long) {
            irExpressionBase = new IrConstImpl<Long>($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Long.INSTANCE, -value2.longValue());
        } else {
            if (IrTypePredicatesKt.isNothing($this$negate.getType())) {
                return $this$negate;
            }
            IrClass irClass2 = IrTypesKt.getClass($this$negate.getType());
            Intrinsics.checkNotNull(irClass2);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$single = false;
            IrSimpleFunction single$iv = null;
            boolean found$iv = false;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.UNARY_MINUS) && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction unaryMinusFun = single$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), unaryMinusFun.getSymbol(), null, null, 48, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$negate);
            irExpressionBase = irCallImpl;
        }
        return irExpressionBase;
    }

    @NotNull
    public static final IrExpression decrement(@NotNull IrExpression $this$decrement) {
        IrExpressionBase irExpressionBase;
        Object thisValue;
        Intrinsics.checkNotNullParameter($this$decrement, "$this$decrement");
        IrExpression irExpression = $this$decrement;
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        Object object = thisValue = irConst != null ? irConst.getValue() : null;
        if (thisValue instanceof Integer) {
            irExpressionBase = new IrConstImpl<Integer>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Int.INSTANCE, ((Number)thisValue).intValue() - 1);
        } else if (thisValue instanceof Long) {
            irExpressionBase = new IrConstImpl<Long>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Long.INSTANCE, ((Number)thisValue).longValue() - 1L);
        } else if (thisValue instanceof Character) {
            irExpressionBase = new IrConstImpl<Character>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Char.INSTANCE, Character.valueOf((char)(((Character)thisValue).charValue() - '\u0001')));
        } else {
            IrClass irClass2 = IrTypesKt.getClass($this$decrement.getType());
            Intrinsics.checkNotNull(irClass2);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$single = false;
            IrSimpleFunction single$iv = null;
            boolean found$iv = false;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.DEC) && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction decFun = single$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), decFun.getSymbol(), null, null, 48, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$decrement);
            irExpressionBase = irCallImpl;
        }
        return irExpressionBase;
    }

    public static final boolean getCanHaveSideEffects(@NotNull IrExpression $this$canHaveSideEffects) {
        Intrinsics.checkNotNullParameter($this$canHaveSideEffects, "$this$canHaveSideEffects");
        return !($this$canHaveSideEffects instanceof IrConst) && !($this$canHaveSideEffects instanceof IrGetValue);
    }

    @Nullable
    public static final Long getConstLongValue(@NotNull IrExpression $this$constLongValue) {
        Object value2;
        Intrinsics.checkNotNullParameter($this$constLongValue, "$this$constLongValue");
        return $this$constLongValue instanceof IrConst ? ((value2 = ((IrConst)$this$constLongValue).getValue()) instanceof Number ? Long.valueOf(((Number)value2).longValue()) : (value2 instanceof Character ? Long.valueOf(((Character)value2).charValue()) : null)) : null;
    }

    @NotNull
    public static final Pair<IrVariable, IrExpression> createTemporaryVariableIfNecessary(@NotNull DeclarationIrBuilder $this$createTemporaryVariableIfNecessary, @NotNull IrExpression expression2, @Nullable String nameHint, @Nullable IrType irType) {
        Pair<IrVariable, IrGetValueImpl> pair;
        Intrinsics.checkNotNullParameter($this$createTemporaryVariableIfNecessary, "$this$createTemporaryVariableIfNecessary");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (UtilsKt.getCanHaveSideEffects(expression2)) {
            IrVariable irVariable2 = IrBuildersKt.createTmpVariable$default($this$createTemporaryVariableIfNecessary.getScope(), expression2, nameHint, false, null, irType, 12, null);
            boolean bl = false;
            boolean bl2 = false;
            IrVariable it = irVariable2;
            boolean bl3 = false;
            pair = new Pair<IrVariable, IrGetValueImpl>(it, ExpressionHelpersKt.irGet($this$createTemporaryVariableIfNecessary, it));
        } else {
            pair = new Pair<IrVariable, IrGetValueImpl>((IrVariable)null, (IrGetValueImpl)expression2);
        }
        return pair;
    }

    public static /* synthetic */ Pair createTemporaryVariableIfNecessary$default(DeclarationIrBuilder declarationIrBuilder, IrExpression irExpression, String string2, IrType irType, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            irType = null;
        }
        return UtilsKt.createTemporaryVariableIfNecessary(declarationIrBuilder, irExpression, string2, irType);
    }
}

