/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirEffectiveVisibility;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityImpl;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolveTransformer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\n\u001a\u00020\u0007*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0002\u001a(\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0012\u001a\u00020\u0013*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0002\u001a'\u0010\u0014\u001a\u0002H\u0002\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\u0002H\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017\".\u0010\u0000\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"0\u0010\u0006\u001a\u0004\u0018\u00010\u0007\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"effectiveVisibility", "Lorg/jetbrains/kotlin/fir/FirEffectiveVisibility;", "F", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getEffectiveVisibility", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/fir/FirEffectiveVisibility;", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "getModality", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/descriptors/Modality;", "resolveModality", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "containingClass", "resolveStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "status", "isLocal", "", "resolveVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "runStatusResolveForLocalClass", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "resolve"})
public final class FirStatusResolveTransformerKt {
    @NotNull
    public static final <F extends FirClass<F>> F runStatusResolveForLocalClass(@NotNull F $this$runStatusResolveForLocalClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$runStatusResolveForLocalClass, "$this$runStatusResolveForLocalClass");
        Intrinsics.checkNotNullParameter(session, "session");
        FirStatusResolveTransformer transformer2 = new FirStatusResolveTransformer(session);
        return (F)((FirClass)$this$runStatusResolveForLocalClass.transform(transformer2, null).getSingle());
    }

    private static final <F extends FirClass<F>> FirEffectiveVisibility getEffectiveVisibility(FirClass<F> $this$effectiveVisibility) {
        FirEffectiveVisibility firEffectiveVisibility;
        FirClass<F> firClass = $this$effectiveVisibility;
        if (firClass instanceof FirRegularClass) {
            firEffectiveVisibility = ((FirRegularClass)$this$effectiveVisibility).getStatus().getEffectiveVisibility();
        } else if (firClass instanceof FirAnonymousObject) {
            firEffectiveVisibility = FirEffectiveVisibilityImpl.Local.INSTANCE;
        } else {
            String string2 = "Unknown kind of class: " + Reflection.getOrCreateKotlinClass($this$effectiveVisibility.getClass());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firEffectiveVisibility;
    }

    private static final <F extends FirClass<F>> Modality getModality(FirClass<F> $this$modality) {
        Modality modality;
        FirClass<F> firClass = $this$modality;
        if (firClass instanceof FirRegularClass) {
            modality = ((FirRegularClass)$this$modality).getStatus().getModality();
        } else if (firClass instanceof FirAnonymousObject) {
            modality = Modality.FINAL;
        } else {
            String string2 = "Unknown kind of class: " + Reflection.getOrCreateKotlinClass($this$modality.getClass());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return modality;
    }

    @NotNull
    public static final FirDeclarationStatus resolveStatus(@NotNull FirDeclaration $this$resolveStatus, @NotNull FirDeclarationStatus status2, @Nullable FirClass<?> containingClass, boolean isLocal) {
        block5: {
            Object object;
            Modality modality;
            Visibility visibility;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter($this$resolveStatus, "$this$resolveStatus");
                    Intrinsics.checkNotNullParameter(status2, "status");
                    if (!Intrinsics.areEqual(status2.getVisibility(), Visibilities.UNKNOWN) && status2.getModality() != null && !Intrinsics.areEqual(status2.getEffectiveVisibility(), FirEffectiveVisibility.Default.INSTANCE)) break block5;
                    Visibility visibility2 = status2.getVisibility();
                    Visibility visibility3 = Intrinsics.areEqual(visibility2, Visibilities.UNKNOWN) ? (isLocal ? Visibilities.LOCAL : ($this$resolveStatus instanceof FirConstructor && containingClass instanceof FirAnonymousObject ? Visibilities.PRIVATE : FirStatusResolveTransformerKt.resolveVisibility($this$resolveStatus, containingClass))) : status2.getVisibility();
                    Intrinsics.checkNotNullExpressionValue(visibility3, "when (status.visibility)\u2026atus.visibility\n        }");
                    visibility = visibility3;
                    Modality modality2 = status2.getModality();
                    if (modality2 == null) {
                        modality2 = modality = FirStatusResolveTransformerKt.resolveModality($this$resolveStatus, containingClass);
                    }
                    if ((object = containingClass) == null || (object = FirStatusResolveTransformerKt.getEffectiveVisibility(object)) == null) break block6;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    object = !(it instanceof FirEffectiveVisibility.Default) ? object2 : null;
                    if (object != null) break block7;
                }
                object = FirEffectiveVisibilityImpl.Public.INSTANCE;
            }
            Object containerEffectiveVisibility = object;
            FirSession firSession = $this$resolveStatus.getSession();
            FirDeclaration firDeclaration = $this$resolveStatus;
            if (!(firDeclaration instanceof FirMemberDeclaration)) {
                firDeclaration = null;
            }
            FirEffectiveVisibility effectiveVisibility = FirEffectiveVisibilityUtilsKt.firEffectiveVisibility(visibility, firSession, (FirMemberDeclaration)firDeclaration).lowerBound((FirEffectiveVisibility)containerEffectiveVisibility);
            return ((FirDeclarationStatusImpl)status2).resolved(visibility, effectiveVisibility, modality);
        }
        return status2;
    }

    private static final Visibility resolveVisibility(FirDeclaration $this$resolveVisibility, FirClass<?> containingClass) {
        if ($this$resolveVisibility instanceof FirConstructor && containingClass != null && (containingClass.getClassKind() == ClassKind.ENUM_CLASS || containingClass.getClassKind() == ClassKind.ENUM_ENTRY || FirStatusResolveTransformerKt.getModality(containingClass) == Modality.SEALED)) {
            Visibility visibility = Visibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue(visibility, "Visibilities.PRIVATE");
            return visibility;
        }
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue(visibility, "Visibilities.PUBLIC");
        return visibility;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Modality resolveModality(FirDeclaration $this$resolveModality, FirClass<?> containingClass) {
        Modality modality;
        FirDeclaration firDeclaration = $this$resolveModality;
        if (firDeclaration instanceof FirRegularClass) {
            if (((FirRegularClass)$this$resolveModality).getClassKind() == ClassKind.INTERFACE) {
                modality = Modality.ABSTRACT;
                return modality;
            }
            modality = Modality.FINAL;
            return modality;
        }
        if (!(firDeclaration instanceof FirCallableMemberDeclaration)) {
            modality = Modality.FINAL;
            return modality;
        }
        if (containingClass == null) {
            modality = Modality.FINAL;
            return modality;
        }
        if (containingClass.getClassKind() == ClassKind.INTERFACE) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)$this$resolveModality;
            boolean $i$f$getVisibility = false;
            if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.PRIVATE)) {
                modality = Modality.FINAL;
                return modality;
            }
            if ($this$resolveModality instanceof FirSimpleFunction && ((FirSimpleFunction)$this$resolveModality).getBody() == null) {
                modality = Modality.ABSTRACT;
                return modality;
            }
            if ($this$resolveModality instanceof FirProperty && ((FirProperty)$this$resolveModality).getInitializer() == null) {
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$resolveModality).getGetter();
                if ((firPropertyAccessor != null ? firPropertyAccessor.getBody() : null) == null) {
                    FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$resolveModality).getSetter();
                    if ((firPropertyAccessor2 != null ? firPropertyAccessor2.getBody() : null) == null) {
                        modality = Modality.ABSTRACT;
                        return modality;
                    }
                }
            }
            modality = Modality.OPEN;
            return modality;
        }
        FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)$this$resolveModality;
        boolean $i$f$isOverride = false;
        if ($this$isOverride$iv.getStatus().isOverride() && FirStatusResolveTransformerKt.getModality(containingClass) != Modality.FINAL) {
            modality = Modality.OPEN;
            return modality;
        }
        modality = Modality.FINAL;
        return modality;
    }
}

