/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PrimitiveCompanionLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getActualPrimitiveCompanion", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "getActualPrimitiveCompanionPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class PrimitiveCompanionLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    private final IrClass getActualPrimitiveCompanion(IrClass irClass2) {
        if (!irClass2.isCompanion()) {
            return null;
        }
        IrDeclarationParent irDeclarationParent = irClass2.getParent();
        if (irDeclarationParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass parent2 = (IrClass)irDeclarationParent;
        if (!IrTypePredicatesKt.isPrimitiveType(IrUtilsKt.getDefaultType(parent2)) && !IrTypePredicatesKt.isString(IrUtilsKt.getDefaultType(parent2))) {
            return null;
        }
        IrClassSymbol irClassSymbol = this.context.getPrimitiveCompanionObjects().get(parent2.getName());
        return irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction getActualPrimitiveCompanionPropertyAccessor(IrSimpleFunction function2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterator iterator2;
        Object object = function2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null) {
            return null;
        }
        Object property2 = object;
        IrDeclarationParent irDeclarationParent = property2.getParent();
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass irClass2 = (IrClass)irDeclarationParent;
        if (irClass2 == null) {
            return null;
        }
        IrClass companion = irClass2;
        IrClass irClass3 = this.getActualPrimitiveCompanion(companion);
        if (irClass3 == null) {
            return null;
        }
        IrClass actualCompanion = irClass3;
        Iterator<IrProperty> iterator3 = IrUtilsKt.getProperties(actualCompanion).iterator();
        while (iterator3.hasNext()) {
            Iterator it;
            boolean bl;
            boolean bl2;
            IrProperty p = iterator3.next();
            if (p.getGetter() != null) {
                bl2 = false;
                bl = false;
                it = iterator2;
                boolean bl3 = false;
                if (Intrinsics.areEqual(it.getName(), function2.getName())) {
                    return it;
                }
            }
            if (p.getSetter() == null) continue;
            bl2 = false;
            bl = false;
            it = iterator2;
            boolean bl4 = false;
            if (!Intrinsics.areEqual(it.getName(), function2.getName())) continue;
            return it;
        }
        Iterable $this$filterIsInstance$iv = actualCompanion.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        iterator2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$single$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), function2.getName())) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ PrimitiveCompanionLowering this$0;

            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrClass irClass2 = (IrClass)expression2.getSymbol().getOwner();
                IrClass irClass3 = PrimitiveCompanionLowering.access$getActualPrimitiveCompanion(this.this$0, irClass2);
                if (irClass3 == null) {
                    return expression2;
                }
                IrClass actualCompanion = irClass3;
                return new IrGetObjectValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrType)IrUtilsKt.getDefaultType(actualCompanion), (IrClassSymbol)actualCompanion.getSymbol());
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrExpression irExpression = super.visitCall(expression2);
                if (irExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                }
                IrCall newCall = (IrCall)irExpression;
                IrFunction irFunction = expression2.getSymbol().getOwner();
                if (irFunction == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
                }
                IrSimpleFunction function2 = (IrSimpleFunction)irFunction;
                IrSimpleFunction irSimpleFunction = PrimitiveCompanionLowering.access$getActualPrimitiveCompanionPropertyAccessor(this.this$0, function2);
                if (irSimpleFunction == null) {
                    return newCall;
                }
                IrSimpleFunction actualFunction = irSimpleFunction;
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)newCall, actualFunction, false, false, null, 28, null);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public PrimitiveCompanionLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ IrClass access$getActualPrimitiveCompanion(PrimitiveCompanionLowering $this, IrClass irClass2) {
        return $this.getActualPrimitiveCompanion(irClass2);
    }

    public static final /* synthetic */ IrSimpleFunction access$getActualPrimitiveCompanionPropertyAccessor(PrimitiveCompanionLowering $this, IrSimpleFunction function2) {
        return $this.getActualPrimitiveCompanionPropertyAccessor(function2);
    }
}

