/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isSpecialStaticProperty", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "reportOnAnnotationWithNonSourceRetention", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "declarationName", "", "Companion", "frontend.java"})
public final class JvmAnnotationsTargetNonExistentAccessorChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<AnnotationUseSiteTarget> getterUselessTargets = SetsKt.setOf(AnnotationUseSiteTarget.PROPERTY_GETTER);
    @NotNull
    private static final Set<AnnotationUseSiteTarget> setterUselessTargets;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean hasSetterWithBody;
        KtPropertyAccessor ktPropertyAccessor;
        boolean hasGetterWithBody;
        KtPropertyAccessor ktPropertyAccessor2;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        if (!(declaration2 instanceof KtParameter) && !(declaration2 instanceof KtProperty)) {
            return;
        }
        if (!DescriptorVisibilities.isPrivate(((MemberDescriptor)descriptor2).getVisibility()) && !this.isSpecialStaticProperty((MemberDescriptor)descriptor2)) {
            return;
        }
        boolean bl = declaration2 instanceof KtProperty && Intrinsics.areEqual((ktPropertyAccessor2 = ((KtProperty)declaration2).getGetter()) == null ? null : Boolean.valueOf(ktPropertyAccessor2.hasBody()), true) ? true : (hasGetterWithBody = false);
        boolean bl2 = declaration2 instanceof KtProperty && Intrinsics.areEqual((ktPropertyAccessor = ((KtProperty)declaration2).getSetter()) == null ? null : Boolean.valueOf(ktPropertyAccessor.hasBody()), true) ? true : (hasSetterWithBody = false);
        if (hasGetterWithBody && hasSetterWithBody) {
            return;
        }
        if (declaration2 instanceof KtProperty && ((KtProperty)declaration2).hasDelegate()) {
            return;
        }
        Object object = declaration2.getName();
        Object object2 = object == null ? ((MemberDescriptor)descriptor2).getName().asString() : object;
        Intrinsics.checkNotNullExpressionValue(object2, "declaration.name ?: descriptor.name.asString()");
        String declarationName = object2;
        object2 = declaration2.getAnnotationEntries().iterator();
        while (object2.hasNext()) {
            KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget;
            KtAnnotationEntry annotation2 = (KtAnnotationEntry)object2.next();
            KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget2 = annotation2.getUseSiteTarget();
            if (ktAnnotationUseSiteTarget2 == null) continue;
            KtAnnotationUseSiteTarget psiTarget = ktAnnotationUseSiteTarget = ktAnnotationUseSiteTarget2;
            AnnotationUseSiteTarget useSiteTarget = psiTarget.getAnnotationUseSiteTarget();
            if ((hasGetterWithBody || !getterUselessTargets.contains((Object)useSiteTarget)) && (hasSetterWithBody || !setterUselessTargets.contains((Object)useSiteTarget))) continue;
            Intrinsics.checkNotNullExpressionValue(annotation2, "annotation");
            this.reportOnAnnotationWithNonSourceRetention(annotation2, declarationName, context2);
        }
        if (declaration2 instanceof KtProperty) {
            KtAnnotationEntry it;
            Iterable $this$forEach$iv;
            if (!hasGetterWithBody && (object2 = ((KtProperty)declaration2).getGetter()) != null && (object = ((KtModifierListOwnerStub)object2).getAnnotationEntries()) != null) {
                $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (KtAnnotationEntry)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    this.reportOnAnnotationWithNonSourceRetention(it, declarationName, context2);
                }
            }
            if (!hasSetterWithBody && (object2 = ((KtProperty)declaration2).getSetter()) != null && (object = ((KtModifierListOwnerStub)object2).getAnnotationEntries()) != null) {
                $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (KtAnnotationEntry)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    this.reportOnAnnotationWithNonSourceRetention(it, declarationName, context2);
                }
            }
        }
    }

    private final void reportOnAnnotationWithNonSourceRetention(KtAnnotationEntry entry, String declarationName, DeclarationCheckerContext context2) {
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.getTrace().get(BindingContext.ANNOTATION, entry);
        if (annotationDescriptor == null) {
            return;
        }
        ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = annotationDescriptor;
        ParametrizedDiagnostic<KtAnnotationEntry> annotationDescriptor2 = parametrizedDiagnostic;
        if (((parametrizedDiagnostic = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)((Object)annotationDescriptor2))) == null ? null : DescriptorUtilsKt.getAnnotationRetention((Annotated)((Object)parametrizedDiagnostic))) == KotlinRetention.SOURCE) {
            return;
        }
        BindingTrace bindingTrace = context2.getTrace();
        parametrizedDiagnostic = ErrorsJvm.ANNOTATION_TARGETS_NON_EXISTENT_ACCESSOR.on((KtAnnotationEntry)((PsiElement)entry), declarationName);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "ANNOTATION_TARGETS_NON_EXISTENT_ACCESSOR.on(entry, declarationName)");
        DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
    }

    private final boolean isSpecialStaticProperty(MemberDescriptor descriptor2) {
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2) || descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)((Object)descriptor2)).isConst();
    }

    static {
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.SETTER_PARAMETER};
        setterUselessTargets = SetsKt.setOf(annotationUseSiteTargetArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmAnnotationsTargetNonExistentAccessorChecker$Companion;", "", "()V", "getterUselessTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "setterUselessTargets", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

