/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/ExceptionHelperCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "helperMapping", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "referenceFunction", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "transformFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "call", "doNotIntrinsify", "", "backend.js"})
public final class ExceptionHelperCallsTransformer
implements CallsTransformer {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> helperMapping;

    public ExceptionHelperCallsTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        Pair[] pairArray = new Pair[5];
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getIrBuiltIns().getCheckNotNullSymbol();
        FqName fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("ensureNotNull"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinPackageFqn.child(Name.identifier(\"ensureNotNull\"))");
        pairArray[0] = TuplesKt.to(irSimpleFunctionSymbol, this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.context.getIrBuiltIns().getThrowCceSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("THROW_CCE"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinPackageFqn.child(Name.identifier(\"THROW_CCE\"))");
        pairArray[1] = TuplesKt.to(irSimpleFunctionSymbol2, this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = this.context.getIrBuiltIns().getThrowIseSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("THROW_ISE"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinPackageFqn.child(Name.identifier(\"THROW_ISE\"))");
        pairArray[2] = TuplesKt.to(irSimpleFunctionSymbol3, this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = this.context.getIrBuiltIns().getIllegalArgumentExceptionSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("THROW_IAE"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinPackageFqn.child(Name.identifier(\"THROW_IAE\"))");
        pairArray[3] = TuplesKt.to(irSimpleFunctionSymbol4, this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol5 = this.context.getIrBuiltIns().getNoWhenBranchMatchedExceptionSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("noWhenBranchMatchedException"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinPackageFqn.child(Name.identifier(\"noWhenBranchMatchedException\"))");
        pairArray[4] = TuplesKt.to(irSimpleFunctionSymbol5, this.referenceFunction(fqName2));
        this.helperMapping = MapsKt.mapOf(pairArray);
    }

    private final IrSimpleFunctionSymbol referenceFunction(FqName fqn) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        SimpleFunctionDescriptor simpleFunctionDescriptor = CollectionsKt.singleOrNull(this.context.getFunctions(fqn));
        if (simpleFunctionDescriptor == null) {
            irSimpleFunctionSymbol = null;
        } else {
            SimpleFunctionDescriptor simpleFunctionDescriptor2 = simpleFunctionDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            SimpleFunctionDescriptor it = simpleFunctionDescriptor2;
            boolean bl3 = false;
            irSimpleFunctionSymbol = this.context.getSymbolTable().referenceSimpleFunction(it);
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol;
        if (irSimpleFunctionSymbol2 == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus("Function not found: ", fqn));
        }
        return irSimpleFunctionSymbol2;
    }

    @Override
    @NotNull
    public IrFunctionAccessExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call2, boolean doNotIntrinsify) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter(call2, "call");
        Object object = this.helperMapping;
        Object object2 = call2.getSymbol();
        boolean bl = false;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = object.get(object2);
        if (irSimpleFunctionSymbol == null) {
            irFunctionAccessExpression = call2;
        } else {
            object2 = irSimpleFunctionSymbol;
            bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            object = IrUtilsKt.irCall$default(call2, it, false, false, null, null, 60, null);
            irFunctionAccessExpression = object == null ? call2 : (IrFunctionAccessExpression)object;
        }
        return irFunctionAccessExpression;
    }
}

