/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.experimental;

import io.ktor.network.sockets.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplHistoryRecord;
import org.jetbrains.kotlin.daemon.common.experimental.AdditionalDaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.experimental.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.experimental.ReplStateFacadeServerSide;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteReadChannelWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteWriteChannelWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ServerSocketWrapper;
import org.jetbrains.kotlin.daemon.experimental.RemoteReplStateFacadeClientSide;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u001a\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0011\u0010\u001c\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010$\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR0\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/daemon/experimental/RemoteReplStateFacadeServerSide;", "Lorg/jetbrains/kotlin/daemon/common/experimental/ReplStateFacadeServerSide;", "_id", "", "state", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "serverSocketWithPort", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;", "(ILorg/jetbrains/kotlin/cli/common/repl/IReplStageState;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;)V", "get_id", "()I", "clientSide", "Lorg/jetbrains/kotlin/daemon/experimental/RemoteReplStateFacadeClientSide;", "getClientSide", "()Lorg/jetbrains/kotlin/daemon/experimental/RemoteReplStateFacadeClientSide;", "clients", "Ljava/util/HashMap;", "Lio/ktor/network/sockets/Socket;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$ClientInfo;", "Lkotlin/collections/HashMap;", "getClients", "()Ljava/util/HashMap;", "getServerSocketWithPort", "()Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;", "getState", "()Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "getHistorySize", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getId", "historyGet", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "index", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "historyReset", "", "historyResetTo", "id", "(Lorg/jetbrains/kotlin/cli/common/repl/ILineId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kotlin-daemon"})
public final class RemoteReplStateFacadeServerSide
implements ReplStateFacadeServerSide {
    private final int _id;
    @NotNull
    private final IReplStageState<?> state;
    @NotNull
    private final ServerSocketWrapper serverSocketWithPort;
    @NotNull
    private final HashMap<Socket, Server.ClientInfo> clients;

    public RemoteReplStateFacadeServerSide(int _id, @NotNull IReplStageState<?> state, @NotNull ServerSocketWrapper serverSocketWithPort) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)serverSocketWithPort, (String)"serverSocketWithPort");
        this._id = _id;
        this.state = state;
        this.serverSocketWithPort = serverSocketWithPort;
        boolean bl = false;
        this.clients = new HashMap();
    }

    public /* synthetic */ RemoteReplStateFacadeServerSide(int n, IReplStageState iReplStageState, ServerSocketWrapper serverSocketWrapper, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            serverSocketWrapper = NetworkUtilsKt.findPortForSocket((int)10, (int)AdditionalDaemonParamsKt.getREPL_SERVER_PORTS_RANGE_START(), (int)AdditionalDaemonParamsKt.getREPL_SERVER_PORTS_RANGE_END());
        }
        this(n, iReplStageState, serverSocketWrapper);
    }

    public final int get_id() {
        return this._id;
    }

    @NotNull
    public final IReplStageState<?> getState() {
        return this.state;
    }

    @NotNull
    public ServerSocketWrapper getServerSocketWithPort() {
        return this.serverSocketWithPort;
    }

    @NotNull
    public HashMap<Socket, Server.ClientInfo> getClients() {
        return this.clients;
    }

    @Nullable
    public Object getId(@NotNull Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)this.get_id());
    }

    @Nullable
    public Object getHistorySize(@NotNull Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)this.getState().getHistory().size());
    }

    @Nullable
    public Object historyGet(int index, @NotNull Continuation<? super ILineId> $completion) {
        return ((ReplHistoryRecord)this.getState().getHistory().get(index)).getId();
    }

    @Nullable
    public Object historyReset(@NotNull Continuation<? super List<? extends ILineId>> $completion) {
        return CollectionsKt.toList((Iterable)this.getState().getHistory().reset());
    }

    @Nullable
    public Object historyResetTo(@NotNull ILineId id, @NotNull Continuation<? super List<? extends ILineId>> $completion) {
        return CollectionsKt.toList((Iterable)this.getState().getHistory().resetTo(id));
    }

    @NotNull
    public final RemoteReplStateFacadeClientSide getClientSide() {
        return new RemoteReplStateFacadeClientSide(this.getServerSocketWithPort().getPort());
    }

    @NotNull
    public Deferred<Server.State> attachClient(@NotNull Socket client) {
        return ReplStateFacadeServerSide.DefaultImpls.attachClient((ReplStateFacadeServerSide)this, (Socket)client);
    }

    @NotNull
    public Server.State processMessage(@NotNull Server.AnyMessage<? super ReplStateFacadeServerSide> msg, @NotNull ByteWriteChannelWrapper output) {
        return ReplStateFacadeServerSide.DefaultImpls.processMessage((ReplStateFacadeServerSide)this, msg, (ByteWriteChannelWrapper)output);
    }

    @NotNull
    public Deferred<Unit> runServer() {
        return ReplStateFacadeServerSide.DefaultImpls.runServer((ReplStateFacadeServerSide)this);
    }

    public void shutdownServer() {
        ReplStateFacadeServerSide.DefaultImpls.shutdownServer((ReplStateFacadeServerSide)this);
    }

    public int getServerPort() {
        return ReplStateFacadeServerSide.DefaultImpls.getServerPort((ReplStateFacadeServerSide)this);
    }

    @Nullable
    public Object checkClientCanReadFile(@NotNull ByteReadChannelWrapper clientInputChannel, @NotNull Continuation<? super Boolean> $completion) {
        return ReplStateFacadeServerSide.DefaultImpls.checkClientCanReadFile((ReplStateFacadeServerSide)this, (ByteReadChannelWrapper)clientInputChannel, $completion);
    }

    @Nullable
    public Object serverHandshake(@NotNull ByteReadChannelWrapper input, @NotNull ByteWriteChannelWrapper output, @NotNull Logger log2, @NotNull Continuation<? super Boolean> $completion) {
        return ReplStateFacadeServerSide.DefaultImpls.serverHandshake((ReplStateFacadeServerSide)this, (ByteReadChannelWrapper)input, (ByteWriteChannelWrapper)output, (Logger)log2, $completion);
    }
}

