/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.ir.backend.js.JsMappingKt;
import org.jetbrains.kotlin.ir.backend.js.SerializableMapping;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00110\u001fH\u0016J&\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020 0\u001fH\u0016J \u0010#\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00028\u00002\b\u0010$\u001a\u0004\u0018\u00018\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/JsMappingDelegate;", "K", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "V", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/backend/js/SerializableMapping;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "keys", "", "getKeys", "()Ljava/util/Set;", "map", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "values", "", "getValues", "()Ljava/util/Collection;", "get", "key", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "loadMapping", "", "declaration", "mapping", "", "symbolDeserializer", "Lkotlin/Function1;", "", "serializeMapping", "symbolSerializer", "set", "value", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "ir.serialization.js"})
final class JsMappingDelegate<K extends IrDeclaration, V extends IrDeclaration>
extends Mapping.Delegate<K, V>
implements SerializableMapping {
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final Map<IrSymbol, IrSymbol> map;

    public JsMappingDelegate(@NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter(irFactory, "irFactory");
        this.irFactory = irFactory;
        this.map = new LinkedHashMap();
    }

    @NotNull
    public final IrFactory getIrFactory() {
        return this.irFactory;
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.irFactory.getStageController().lazyLower((IrDeclaration)key);
        IrSymbol irSymbol2 = this.map.get(((IrSymbolOwner)key).getSymbol());
        IrSymbolOwner irSymbolOwner = irSymbol2 == null ? null : irSymbol2.getOwner();
        return (V)(irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null);
    }

    @Override
    public void set(@NotNull K key, @Nullable V value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.irFactory.getStageController().lazyLower((IrDeclaration)key);
        if (value2 == null) {
            this.map.remove(((IrSymbolOwner)key).getSymbol());
        } else {
            this.map.put(((IrSymbolOwner)key).getSymbol(), ((IrSymbolOwner)value2).getSymbol());
        }
    }

    @Override
    @Nullable
    public byte[] serializeMapping(@NotNull IrDeclaration declaration2, @NotNull Function1<? super IrSymbol, Long> symbolSerializer) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(symbolSerializer, "symbolSerializer");
        IrSymbol irSymbol2 = this.map.get(declaration2.getSymbol());
        if (irSymbol2 == null) {
            byArray = null;
        } else {
            IrSymbol irSymbol3;
            IrSymbol symbol2 = irSymbol3 = irSymbol2;
            boolean bl = false;
            byArray = JsMappingKt.toByteArray(((Number)symbolSerializer.invoke(symbol2)).longValue());
        }
        return byArray;
    }

    @Override
    public void loadMapping(@NotNull IrDeclaration declaration2, @NotNull byte[] mapping2, @NotNull Function1<? super Long, ? extends IrSymbol> symbolDeserializer2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(mapping2, "mapping");
        Intrinsics.checkNotNullParameter(symbolDeserializer2, "symbolDeserializer");
        this.map.put(declaration2.getSymbol(), symbolDeserializer2.invoke((Long)JsMappingKt.toLong(mapping2)));
    }

    @Override
    @NotNull
    public Set<K> getKeys() {
        throw new NotImplementedError(Intrinsics.stringPlus("An operation is not implemented: ", "Not yet implemented"));
    }

    @Override
    @NotNull
    public Collection<V> getValues() {
        throw new NotImplementedError(Intrinsics.stringPlus("An operation is not implemented: ", "Not yet implemented"));
    }
}

