/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkReifieidTypeParameters", "call", "extractModuleCallee", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.frontend"})
public final class JsModuleCallChecker
implements CallChecker {
    @NotNull
    public static final JsModuleCallChecker INSTANCE = new JsModuleCallChecker();

    private JsModuleCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.checkReifieidTypeParameters(resolvedCall2, reportOn, context2);
        DeclarationDescriptor declarationDescriptor = this.extractModuleCallee(resolvedCall2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor callee = declarationDescriptor;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext2, context2.getTrace(), containingDescriptor, callee, reportOn);
    }

    private final DeclarationDescriptor extractModuleCallee(ResolvedCall<?> call2) {
        Object callee = call2.getResultingDescriptor();
        if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)callee)) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue = call2.getDispatchReceiver();
        if (receiverValue == null) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue2 = receiverValue;
        ReceiverValue receiver = receiverValue2;
        if (receiver instanceof ClassValueReceiver) {
            return ((ClassValueReceiver)receiver).getClassQualifier().getDescriptor();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifieidTypeParameters(ResolvedCall<?> call2, PsiElement reportOn, CallCheckerContext context2) {
        KtTypeReference $this$mapTo$iv$iv;
        Object destination$iv$iv;
        Map map;
        KtTypeArgumentList $this$filterTo$iv$iv;
        TypeParameterDescriptor typeParameterDescriptor;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        List<TypeParameterDescriptor> list2 = call2.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "call.candidateDescriptor.typeParameters");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv2) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)t;
            collection = destination$iv$iv2;
            boolean bl = false;
            typeParameterDescriptor = it.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        Iterable $this$filter$iv = CollectionsKt.withIndex((List)destination$iv$iv2);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            IndexedValue $dstr$_u24__u24$param = (IndexedValue)t;
            boolean bl2 = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)$dstr$_u24__u24$param.component2();
            if (!param.isReified()) continue;
            destination$iv$iv3.add(t);
        }
        List typeParams = (List)destination$iv$iv3;
        KtTypeArgumentList ktTypeArgumentList = call2.getCall().getTypeArgumentList();
        if (ktTypeArgumentList == null) {
            map = null;
        } else {
            void $this$associateTo$iv$iv;
            KtTypeArgumentList args = $this$filterTo$iv$iv = ktTypeArgumentList;
            boolean bl = false;
            Iterable $this$associate$iv = typeParams;
            boolean object2 = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable bl2 = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Object object = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl3 = false;
                int index2 = $dstr$index$param.component1();
                TypeParameterDescriptor param = (TypeParameterDescriptor)$dstr$index$param.component2();
                TypeParameterDescriptor typeParameterDescriptor3 = param.getOriginal();
                List<KtTypeProjection> list3 = args.getArguments();
                Intrinsics.checkNotNullExpressionValue(list3, "args.arguments");
                KtTypeProjection ktTypeProjection = CollectionsKt.getOrNull(list3, index2);
                Pair<TypeParameterDescriptor, KtTypeReference> pair = TuplesKt.to(typeParameterDescriptor3, ktTypeProjection == null ? null : ktTypeProjection.getTypeReference());
                object.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        }
        $this$filterTo$iv$iv = map;
        Object typeArguments2 = $this$filterTo$iv$iv == null ? MapsKt.emptyMap() : $this$filterTo$iv$iv;
        Iterable $this$map$iv2 = typeParams;
        boolean $i$f$map2 = false;
        Iterable bl = $this$map$iv2;
        Object destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean bl2 = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void $dstr$_u24__u24$param;
            Object item$iv$iv = object.next();
            destination$iv$iv = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv32;
            boolean bl4 = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)$dstr$_u24__u24$param.component2();
            typeParameterDescriptor = param.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        for (TypeParameterDescriptor typeParam : (List)destination$iv$iv32) {
            ClassDescriptor classDescriptor;
            PsiElement argPsi;
            $this$mapTo$iv$iv = (KtTypeReference)typeArguments2.get(typeParam);
            PsiElement psiElement = argPsi = $this$mapTo$iv$iv == null ? reportOn : (PsiElement)$this$mapTo$iv$iv;
            destination$iv$iv32 = call2.getTypeArguments().get(typeParam);
            if (destination$iv$iv32 == null) continue;
            Object typeArgument = destination$iv$iv32;
            object = ((KotlinType)typeArgument).getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (classDescriptor == null) continue;
            ClassDescriptor typeArgumentClass = classDescriptor;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
            JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, context2.getTrace(), containingDescriptor, typeArgumentClass, argPsi);
        }
    }
}

