/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.AbstractFunctor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.TypesKt;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ \u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/EqualsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/AbstractFunctor;", "isNegated", "", "(Z)V", "()Z", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "equateCallAndConstant", "call", "constant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "equateValues", "left", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "right", "invokeWithArguments", "isSafeToProduceFalse", "leftCall", "leftConstant", "rightConstant", "resolution"})
public final class EqualsFunctor
extends AbstractFunctor {
    private final boolean isNegated;

    public EqualsFunctor(boolean isNegated) {
        this.isNegated = isNegated;
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        boolean bl;
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        Intrinsics.checkNotNullParameter(reducer, "reducer");
        boolean bl2 = bl = arguments2.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Equals functor expected 2 arguments, got " + arguments2.size();
            throw new AssertionError((Object)string2);
        }
        if (arguments2.size() != 2) {
            return CollectionsKt.emptyList();
        }
        return this.invokeWithArguments(arguments2.get(0), arguments2.get(1));
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation left, @NotNull Computation right) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        if (left instanceof ESValue && right instanceof ESValue) {
            return this.equateValues((ESValue)left, (ESValue)right);
        }
        if (left instanceof ESConstant) {
            return this.equateCallAndConstant(right, (ESConstant)left);
        }
        if (right instanceof ESConstant) {
            return this.equateCallAndConstant(left, (ESConstant)right);
        }
        return CollectionsKt.emptyList();
    }

    private final List<ESEffect> equateCallAndConstant(Computation call2, ESConstant constant) {
        List resultingClauses = new ArrayList();
        for (ESEffect effect : call2.getEffects()) {
            if (!(effect instanceof ConditionalEffect) || !(((ConditionalEffect)effect).getSimpleEffect() instanceof ESReturns) || ValuesKt.isWildcard(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue())) {
                ((Collection)resultingClauses).add(effect);
                continue;
            }
            if (Intrinsics.areEqual(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant)) {
                ConditionalEffect trueClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(ESConstants.INSTANCE.booleanValue(!this.isNegated)));
                resultingClauses.add(trueClause);
            }
            if (Intrinsics.areEqual(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant) || !(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue() instanceof ESConstant) || !this.isSafeToProduceFalse(call2, (ESConstant)((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant)) continue;
            ConditionalEffect falseClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(ESConstants.INSTANCE.booleanValue(this.isNegated)));
            resultingClauses.add(falseClause);
        }
        return resultingClauses;
    }

    private final boolean isSafeToProduceFalse(Computation leftCall, ESConstant leftConstant, ESConstant rightConstant) {
        return TypesKt.isBoolean(rightConstant.getType()) && TypesKt.isBoolean(leftCall.getType()) ? true : leftConstant.isNullConstant() && rightConstant.isNullConstant();
    }

    private final List<ESEffect> equateValues(ESValue left, ESValue right) {
        ConditionalEffect[] conditionalEffectArray = new ConditionalEffect[]{new ConditionalEffect(new ESEqual(left, right, this.isNegated), new ESReturns(ESConstants.INSTANCE.getTrueValue())), new ConditionalEffect(new ESEqual(left, right, !this.isNegated), new ESReturns(ESConstants.INSTANCE.getFalseValue()))};
        return CollectionsKt.listOf(conditionalEffectArray);
    }
}

