/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J!\u0010\u0019\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/ReturnValueInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/AbstractJumpInstruction;", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "blockScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "targetLabel", "Lorg/jetbrains/kotlin/cfg/Label;", "returnedValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "subroutine", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;Lorg/jetbrains/kotlin/psi/KtElement;)V", "inputValues", "", "getInputValues", "()Ljava/util/List;", "returnExpressionIfAny", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getReturnExpressionIfAny", "()Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getReturnedValue", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "getSubroutine", "()Lorg/jetbrains/kotlin/psi/KtElement;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "createCopy", "newLabel", "toString", "", "cfg"})
public final class ReturnValueInstruction
extends AbstractJumpInstruction {
    @NotNull
    private final PseudoValue returnedValue;
    @NotNull
    private final KtElement subroutine;
    @Nullable
    private final KtReturnExpression returnExpressionIfAny;

    public ReturnValueInstruction(@NotNull KtExpression returnExpression, @NotNull BlockScope blockScope, @NotNull Label targetLabel, @NotNull PseudoValue returnedValue, @NotNull KtElement subroutine) {
        Intrinsics.checkNotNullParameter(returnExpression, "returnExpression");
        Intrinsics.checkNotNullParameter(blockScope, "blockScope");
        Intrinsics.checkNotNullParameter(targetLabel, "targetLabel");
        Intrinsics.checkNotNullParameter(returnedValue, "returnedValue");
        Intrinsics.checkNotNullParameter(subroutine, "subroutine");
        super(returnExpression, targetLabel, blockScope);
        this.returnedValue = returnedValue;
        this.subroutine = subroutine;
        KtElement ktElement = this.getElement();
        this.returnExpressionIfAny = ktElement instanceof KtReturnExpression ? (KtReturnExpression)ktElement : null;
    }

    @NotNull
    public final PseudoValue getReturnedValue() {
        return this.returnedValue;
    }

    @NotNull
    public final KtElement getSubroutine() {
        return this.subroutine;
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        List<PseudoValue> list2 = Collections.singletonList(this.returnedValue);
        Intrinsics.checkNotNullExpressionValue(list2, "singletonList(returnedValue)");
        return list2;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        visitor2.visitReturnValue(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<? extends R> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitReturnValue(this);
    }

    @NotNull
    public String toString() {
        return "ret(*|" + this.returnedValue + ") " + this.getTargetLabel();
    }

    @Override
    @NotNull
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel, @NotNull BlockScope blockScope) {
        Intrinsics.checkNotNullParameter(newLabel, "newLabel");
        Intrinsics.checkNotNullParameter(blockScope, "blockScope");
        KtElement ktElement = this.getElement();
        Intrinsics.checkNotNull(ktElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        return new ReturnValueInstruction((KtExpression)ktElement, blockScope, newLabel, this.returnedValue, this.subroutine);
    }

    @Nullable
    public final KtReturnExpression getReturnExpressionIfAny() {
        return this.returnExpressionIfAny;
    }
}

