/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ant;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ant.KotlinAntTaskUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u00103\u001a\u00020\u0005J\u0006\u00104\u001a\u00020+J\b\u00105\u001a\u000206H\u0016J\u0006\u00107\u001a\u000206J\b\u00108\u001a\u000206H&J\u000e\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020;R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0012\u0010\u000b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0018\"\u0004\b2\u0010\u001a\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ant/KotlinCompilerBaseTask;", "Lorg/apache/tools/ant/Task;", "()V", "additionalArguments", "", "Lorg/apache/tools/ant/types/Commandline$Argument;", "getAdditionalArguments", "()Ljava/util/List;", "args", "", "getArgs", "compilerFqName", "getCompilerFqName", "()Ljava/lang/String;", "exitCode", "", "getExitCode", "()Ljava/lang/Integer;", "setExitCode", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "failOnError", "", "getFailOnError", "()Z", "setFailOnError", "(Z)V", "noStdlib", "getNoStdlib", "setNoStdlib", "nowarn", "getNowarn", "setNowarn", "output", "Ljava/io/File;", "getOutput", "()Ljava/io/File;", "setOutput", "(Ljava/io/File;)V", "printVersion", "getPrintVersion", "setPrintVersion", "src", "Lorg/apache/tools/ant/types/Path;", "getSrc", "()Lorg/apache/tools/ant/types/Path;", "setSrc", "(Lorg/apache/tools/ant/types/Path;)V", "verbose", "getVerbose", "setVerbose", "createCompilerArg", "createSrc", "execute", "", "fillArguments", "fillSpecificArguments", "setSrcRef", "ref", "Lorg/apache/tools/ant/types/Reference;", "kotlin-ant"})
public abstract class KotlinCompilerBaseTask
extends Task {
    @NotNull
    private final List<String> args = new ArrayList();
    @Nullable
    private Path src;
    @Nullable
    private File output;
    private boolean nowarn;
    private boolean verbose;
    private boolean printVersion;
    private boolean failOnError = true;
    private boolean noStdlib;
    @NotNull
    private final List<Commandline.Argument> additionalArguments = new ArrayList();
    @Nullable
    private Integer exitCode;

    @NotNull
    protected abstract String getCompilerFqName();

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @Nullable
    public final Path getSrc() {
        return this.src;
    }

    public final void setSrc(@Nullable Path path) {
        this.src = path;
    }

    @Nullable
    public final File getOutput() {
        return this.output;
    }

    public final void setOutput(@Nullable File file) {
        this.output = file;
    }

    public final boolean getNowarn() {
        return this.nowarn;
    }

    public final void setNowarn(boolean bl) {
        this.nowarn = bl;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean getPrintVersion() {
        return this.printVersion;
    }

    public final void setPrintVersion(boolean bl) {
        this.printVersion = bl;
    }

    public final boolean getFailOnError() {
        return this.failOnError;
    }

    public final void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public final boolean getNoStdlib() {
        return this.noStdlib;
    }

    public final void setNoStdlib(boolean bl) {
        this.noStdlib = bl;
    }

    @NotNull
    public final List<Commandline.Argument> getAdditionalArguments() {
        return this.additionalArguments;
    }

    @Nullable
    public final Integer getExitCode() {
        return this.exitCode;
    }

    public final void setExitCode(@Nullable Integer n) {
        this.exitCode = n;
    }

    @NotNull
    public final Path createSrc() {
        Path srcPath = this.src;
        if (srcPath == null) {
            Path t;
            this.src = t = new Path(this.getProject());
            return t;
        }
        Path path = srcPath.createPath();
        Intrinsics.checkNotNullExpressionValue(path, "srcPath.createPath()");
        return path;
    }

    public final void setSrcRef(@NotNull Reference ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.createSrc().setRefid(ref);
    }

    @NotNull
    public final Commandline.Argument createCompilerArg() {
        Commandline.Argument argument = new Commandline.Argument();
        this.additionalArguments.add(argument);
        return argument;
    }

    public abstract void fillSpecificArguments();

    /*
     * WARNING - void declaration
     */
    public final void fillArguments() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Path path = this.src;
        if (path == null) {
            throw new BuildException("\"src\" should be specified");
        }
        Path sourcePaths = path;
        String[] stringArray = sourcePaths.list();
        Intrinsics.checkNotNullExpressionValue(stringArray, "sourcePaths.list()");
        Object[] objectArray = stringArray;
        List<String> list = this.args;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it).getCanonicalPath());
        }
        list.addAll((List)destination$iv$iv);
        if (this.output == null) {
            throw new BuildException("\"output\" should be specified");
        }
        if (this.nowarn) {
            this.args.add("-nowarn");
        }
        if (this.verbose) {
            this.args.add("-verbose");
        }
        if (this.printVersion) {
            this.args.add("-version");
        }
        $this$map$iv = this.additionalArguments;
        list = this.args;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Commandline.Argument it = (Commandline.Argument)element$iv$iv;
            boolean bl = false;
            String[] stringArray2 = it.getParts();
            Intrinsics.checkNotNullExpressionValue(stringArray2, "it.parts");
            Iterable list$iv$iv = ArraysKt.toList((Object[])stringArray2);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        this.fillSpecificArguments();
    }

    public void execute() {
        this.fillArguments();
        Class<?> compilerClass = KotlinAntTaskUtil.INSTANCE.getOrCreateClassLoader().loadClass(this.getCompilerFqName());
        Object compiler = compilerClass.newInstance();
        Class[] classArray = new Class[]{PrintStream.class, String[].class};
        Method exec = compilerClass.getMethod("execFullPathsInMessages", classArray);
        StringBuilder stringBuilder = new StringBuilder().append("Compiling ");
        Path path = this.src;
        Intrinsics.checkNotNull(path);
        String[] stringArray = path.list();
        Intrinsics.checkNotNullExpressionValue(stringArray, "src!!.list()");
        StringBuilder stringBuilder2 = stringBuilder.append(ArraysKt.toList((Object[])stringArray)).append(" => [");
        File file = this.output;
        Intrinsics.checkNotNull(file);
        this.log(stringBuilder2.append(file.getCanonicalPath()).append(']').toString());
        Object[] objectArray = new Object[2];
        objectArray[0] = System.err;
        Collection $this$toTypedArray$iv = this.args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray[1] = thisCollection$iv.toArray(new String[0]);
        Object result = exec.invoke(compiler, objectArray);
        Intrinsics.checkNotNull(result, "null cannot be cast to non-null type kotlin.Enum<*>");
        this.exitCode = ((Enum)result).ordinal();
        if (this.failOnError) {
            Integer n = this.exitCode;
            if (n == null || n != 0) {
                throw new BuildException("Compile failed; see the compiler error output for details.");
            }
        }
    }
}

