/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo;", "Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "()V", "checkIfPlatformSpecificCompilerArgumentWasChanged", "", "key", "", "currentValue", "previousValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "createPropertiesMapFromCompilerArguments", "", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nCommonBuildMetaInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBuildMetaInfo.kt\norg/jetbrains/kotlin/build/CommonBuildMetaInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class CommonBuildMetaInfo
extends BuildMetaInfo {
    @Override
    @Nullable
    public Boolean checkIfPlatformSpecificCompilerArgumentWasChanged(@NotNull String key, @NotNull String currentValue, @NotNull String previousValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(currentValue, "currentValue");
        Intrinsics.checkNotNullParameter(previousValue, "previousValue");
        if (Intrinsics.areEqual(key, "METADATA_VERSION_STRING")) {
            int[] previousVersionIntArray;
            int[] currentVersionIntArray;
            if (!(currentVersionIntArray != null ? (currentVersionIntArray = BinaryVersion.Companion.parseVersionArray(currentValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray = new int[]{currentVersionIntArray[0], currentVersionIntArray[1], currentVersionIntArray[2]};
            JvmMetadataVersion currentVersion = new JvmMetadataVersion(nArray);
            if (!(previousVersionIntArray != null ? (previousVersionIntArray = BinaryVersion.Companion.parseVersionArray(previousValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray2 = new int[]{previousVersionIntArray[0], previousVersionIntArray[1], previousVersionIntArray[2]};
            JvmMetadataVersion previousVersion = new JvmMetadataVersion(nArray2);
            return Intrinsics.areEqual(currentVersion, previousVersion);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> createPropertiesMapFromCompilerArguments(@NotNull CommonCompilerArguments args) {
        JvmMetadataVersion jvmMetadataVersion;
        int[] metadataVersionArray;
        int[] nArray;
        Intrinsics.checkNotNullParameter(args, "args");
        Map resultMap = new LinkedHashMap();
        String string2 = args.getMetadataVersion();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            nArray = BinaryVersion.Companion.parseVersionArray(it);
        } else {
            nArray = null;
        }
        if (metadataVersionArray != null) {
            int[] p0 = metadataVersionArray = nArray;
            boolean bl = false;
            jvmMetadataVersion = new JvmMetadataVersion(p0);
        } else {
            jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
        }
        JvmMetadataVersion metadataVersion = jvmMetadataVersion;
        String metadataVersionString = metadataVersion.toString();
        resultMap.put("METADATA_VERSION_STRING", metadataVersionString);
        return MapsKt.plus(super.createPropertiesMapFromCompilerArguments(args), resultMap);
    }
}

