/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\u0005*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "()V", "ignoredAnnotationShortNames", "", "", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "shortNameToClassId", "", "presentableName", "Lorg/jetbrains/kotlin/types/KotlinType;", "getPresentableName", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/lang/String;", "createAnnotationSerializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "resolveUnresolvedType", "type", "serializeErrorType", "", "builder", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "shouldUseTypeTable", "", "cli"})
public final class BuiltInsSerializerExtension
extends KotlinSerializerExtensionBase {
    private final Map<String, String> shortNameToClassId = MapsKt.mapOf(TuplesKt.to("IntRange", "kotlin/ranges/IntRange"), TuplesKt.to("LongRange", "kotlin/ranges/LongRange"), TuplesKt.to("CharRange", "kotlin/ranges/CharRange"), TuplesKt.to("ExperimentalStdlibApi", "kotlin/ExperimentalStdlibApi"));
    private final Set<String> ignoredAnnotationShortNames = SetsKt.setOf("JvmStatic", "JvmField", "OptIn");

    @Override
    @NotNull
    protected AnnotationSerializer createAnnotationSerializer() {
        return new AnnotationSerializer(this, this.getStringTable()){
            final /* synthetic */ BuiltInsSerializerExtension this$0;

            @Nullable
            protected ClassId getAnnotationClassId(@NotNull AnnotationDescriptor annotation2) {
                Intrinsics.checkNotNullParameter(annotation2, "annotation");
                KotlinType type2 = annotation2.getType();
                ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass(annotation2);
                if (classDescriptor2 == null) {
                    String string2 = "Annotation type is not a class: " + type2;
                    throw new IllegalStateException(string2.toString());
                }
                ClassDescriptor annotationClass = classDescriptor2;
                if (ErrorUtils.isError(annotationClass)) {
                    if (BuiltInsSerializerExtension.access$getIgnoredAnnotationShortNames$p(this.this$0).contains(BuiltInsSerializerExtension.access$getPresentableName$p(this.this$0, type2))) {
                        return null;
                    }
                    return ClassId.fromString(BuiltInsSerializerExtension.access$resolveUnresolvedType(this.this$0, type2));
                }
                return DescriptorUtilsKt.getClassId((ClassifierDescriptor)annotationClass);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
    }

    @Override
    @NotNull
    public BinaryVersion getMetadataVersion() {
        return BuiltInsBinaryVersion.INSTANCE;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return true;
    }

    @Override
    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        String className2 = this.resolveUnresolvedType(type2);
        builder2.setClassName(this.getStringTable().getQualifiedClassNameIndex(className2, false));
    }

    private final String resolveUnresolvedType(KotlinType type2) {
        String string2 = this.shortNameToClassId.get(this.getPresentableName(type2));
        if (string2 == null) {
            throw (Throwable)new UnsupportedOperationException("Unsupported unresolved type: " + type2.unwrap() + ".\n" + "Consider adding it to `BuiltInsSerializerExtension.shortNameToClassId`.");
        }
        return string2;
    }

    private final String getPresentableName(KotlinType $this$presentableName) {
        UnwrappedType unwrapped = $this$presentableName.unwrap();
        if (!TypeUtilsKt.isUnresolvedType(unwrapped)) {
            throw (Throwable)new UnsupportedOperationException("Error types which are not unresolved type instances are not supported here: " + unwrapped);
        }
        return StringsKt.removePrefix(((ErrorType)unwrapped).getDebugMessage(), (CharSequence)"Unresolved type for ");
    }

    public BuiltInsSerializerExtension() {
        super(BuiltInSerializerProtocol.INSTANCE);
    }

    public static final /* synthetic */ Set access$getIgnoredAnnotationShortNames$p(BuiltInsSerializerExtension $this) {
        return $this.ignoredAnnotationShortNames;
    }

    public static final /* synthetic */ String access$getPresentableName$p(BuiltInsSerializerExtension $this, KotlinType $this$access_u24presentableName_u24p) {
        return $this.getPresentableName($this$access_u24presentableName_u24p);
    }

    public static final /* synthetic */ String access$resolveUnresolvedType(BuiltInsSerializerExtension $this, KotlinType type2) {
        return $this.resolveUnresolvedType(type2);
    }
}

