/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrCoroutineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLoweringUtils;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u0018\u001a\u00020\u0019*\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010\u001c\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J\f\u0010 \u001a\u00020!*\u00020!H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLoweringUtils;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "addContinuationObjectAndContinuationParameterToSuspendFunctions", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addContinuationParameterToSuspendCalls", "createStaticSuspendImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "irFunction", "generateContinuationClassForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "attributeContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "capturesCrossinline", "", "lower", "addConstructorForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "capturedThisField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addInvokeSuspendForNamedFunction", "resultField", "labelField", "isStaticSuspendImpl", "toSuspendImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAddContinuationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,506:1\n49#2,4:507\n79#2:511\n73#2,10:512\n79#2:522\n73#2,10:523\n288#2:533\n282#2,13:534\n1#3:547\n346#4,12:548\n346#4,12:572\n404#5,10:560\n404#5,10:584\n72#6,2:570\n72#6,2:594\n*S KotlinDebug\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n*L\n95#1:507,4\n105#1:511\n105#1:512,10\n112#1:522\n112#1:523,10\n133#1:533\n133#1:534,13\n141#1:548,12\n161#1:572,12\n142#1:560,10\n273#1:584,10\n142#1:570,2\n273#1:594,2\n*E\n"})
final class AddContinuationLowering
extends SuspendLoweringUtils
implements FileLoweringPass {
    public AddContinuationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.addContinuationObjectAndContinuationParameterToSuspendFunctions(irFile);
        this.addContinuationParameterToSuspendCalls(irFile);
    }

    private final void addContinuationParameterToSuspendCalls(IrFile irFile) {
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            @NotNull
            private final List<IrFunction> functionStack;
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
                this.functionStack = new ArrayList<E>();
            }

            @NotNull
            public final List<IrFunction> getFunctionStack() {
                return this.functionStack;
            }

            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                UtilsKt.push(this.functionStack, declaration);
                IrStatement it = irStatement = super.visitFunction(declaration);
                boolean bl = false;
                UtilsKt.pop(this.functionStack);
                return irStatement;
            }

            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrExpression irExpression = super.visitFunctionReference(expression2);
                Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference transformed = (IrFunctionReference)irExpression;
                return AddContinuationLoweringKt.access$retargetToSuspendView(transformed, this.this$0.getContext(), null, addContinuationParameterToSuspendCalls.visitFunctionReference.1.INSTANCE);
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall transformed = (IrCall)irExpression;
                IrFunction irFunction2 = UtilsKt.peek(this.functionStack);
                if (irFunction2 == null) {
                    return transformed;
                }
                return AddContinuationLoweringKt.access$retargetToSuspendView(transformed, this.this$0.getContext(), irFunction2, addContinuationParameterToSuspendCalls.visitCall.1.INSTANCE);
            }
        });
    }

    private final IrClass generateContinuationClassForNamedFunction(IrFunction irFunction2, IrValueParameter dispatchReceiverParameter2, IrAttributeContainer attributeContainer, boolean capturesCrossinline) {
        IrField irField;
        IrClass irClass2;
        DescriptorVisibility descriptorVisibility;
        IrFactory $this$buildClass$iv = this.getContext().getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name2 = Name.special("<Continuation>");
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setName(name2);
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.CONTINUATION_CLASS.INSTANCE);
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility3, "PACKAGE_VISIBILITY");
        }
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setVisibility(descriptorVisibility);
        IrClass $this$generateContinuationClassForNamedFunction_u24lambda_u244 = irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$generateContinuationClassForNamedFunction_u24lambda_u244);
        $this$generateContinuationClassForNamedFunction_u24lambda_u244.setSuperTypes(CollectionsKt.plus((Collection)$this$generateContinuationClassForNamedFunction_u24lambda_u244.getSuperTypes(), IrUtilsKt.getDefaultType((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner())));
        $this$generateContinuationClassForNamedFunction_u24lambda_u244.setParent(irFunction2);
        IrUtilsKt.copyTypeParametersFrom$default($this$generateContinuationClassForNamedFunction_u24lambda_u244, irFunction2, null, null, 6, null);
        IrClass $this$addField$iv = $this$generateContinuationClassForNamedFunction_u24lambda_u244;
        boolean $i$f$addField = false;
        Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241 = $this$buildField_u24lambda_u244$iv$iv;
        boolean bl5 = false;
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setOrigin(JvmLoweredDeclarationOrigin.CONTINUATION_CLASS_RESULT_FIELD.INSTANCE);
        Name name3 = Name.identifier("result");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setName(name3);
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setType(this.getContext().getIr().getSymbols().getResultOfAnyType());
        DescriptorVisibility descriptorVisibility4 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility4, "PACKAGE_VISIBILITY");
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setVisibility(descriptorVisibility4);
        Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
        boolean bl6 = false;
        field$iv.setParent($this$addField$iv);
        $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
        Object resultField = $this$buildField$iv$iv;
        IrValueParameter irValueParameter = dispatchReceiverParameter2;
        if (irValueParameter != null) {
            IrField irField2;
            IrValueParameter it = irValueParameter;
            boolean bl7 = false;
            IrClass $this$addField$iv2 = $this$generateContinuationClassForNamedFunction_u24lambda_u244;
            boolean $i$f$addField2 = false;
            IrFactory $this$buildField$iv$iv2 = $this$addField$iv2.getFactory();
            boolean $i$f$buildField2 = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv2 = new IrFieldBuilder();
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv$iv = false;
            IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242 = $this$buildField_u24lambda_u244$iv$iv2;
            boolean bl8 = false;
            Name name4 = Name.identifier("this$0");
            Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setName(name4);
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setType(it.getType());
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setOrigin(IrDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE);
            DescriptorVisibility descriptorVisibility5 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility5, "PACKAGE_VISIBILITY");
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setVisibility(descriptorVisibility5);
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setFinal(true);
            IrField field$iv2 = irField2 = DeclarationBuildersKt.buildField($this$buildField$iv$iv2, $this$buildField_u24lambda_u244$iv$iv2);
            $i$a$-also-DeclarationBuildersKt$addField$1$iv = false;
            field$iv2.setParent($this$addField$iv2);
            $this$addField$iv2.getDeclarations().add(field$iv2);
            irField = irField2;
        } else {
            irField = null;
        }
        IrField capturedThisField = irField;
        IrType irType = this.getContext().getIrBuiltIns().getIntType();
        DescriptorVisibility descriptorVisibility6 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility6, "PACKAGE_VISIBILITY");
        IrField labelField = DeclarationBuildersKt.addField($this$generateContinuationClassForNamedFunction_u24lambda_u244, "label", irType, descriptorVisibility6);
        this.addConstructorForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u244, capturedThisField, capturesCrossinline);
        this.addInvokeSuspendForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u244, irFunction2, (IrField)resultField, labelField, capturedThisField, Intrinsics.areEqual(irFunction2.getOrigin(), JvmLoweredDeclarationOrigin.SUSPEND_IMPL_STATIC_FUNCTION.INSTANCE));
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$generateContinuationClassForNamedFunction_u24lambda_u244, attributeContainer);
        return irClass2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor addConstructorForNamedFunction(IrClass $this$addConstructorForNamedFunction, IrField capturedThisField, boolean capturesCrossinline) {
        void it;
        IrDelegatingConstructorCall irDelegatingConstructorCall2;
        void $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
        void this_$iv$iv;
        IrConstructor it2;
        IrValueParameter irValueParameter;
        Object object;
        DescriptorVisibility descriptorVisibility;
        IrClass $this$addConstructor$iv = $this$addConstructorForNamedFunction;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$addConstructorForNamedFunction_u24lambda_u245 = $this$addConstructor_u24lambda_u2425$iv;
        boolean bl3 = false;
        $this$addConstructorForNamedFunction_u24lambda_u245.setPrimary(true);
        $this$addConstructorForNamedFunction_u24lambda_u245.setReturnType(IrUtilsKt.getDefaultType($this$addConstructorForNamedFunction));
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility3, "PACKAGE_VISIBILITY");
        }
        $this$addConstructorForNamedFunction_u24lambda_u245.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u2425$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2424$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        constructor$iv.setParent($this$addConstructor$iv);
        Object constructor2 = object = $this$buildConstructor$iv$iv;
        boolean bl5 = false;
        IrField irField = capturedThisField;
        if (irField != null) {
            IrField it3 = irField;
            boolean bl6 = false;
            IrFunction irFunction2 = (IrFunction)constructor2;
            String string2 = it3.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            irValueParameter = DeclarationBuildersKt.addValueParameter$default(irFunction2, string2, it3.getType(), null, 4, null);
        } else {
            irValueParameter = null;
        }
        IrValueParameter capturedThisParameter = irValueParameter;
        IrValueParameter completionParameterSymbol = this.addCompletionValueParameter((IrFunction)constructor2);
        Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner());
        boolean $i$f$single = false;
        IrConstructor single$iv = null;
        boolean found$iv = false;
        Object object2 = $this$single$iv.iterator();
        while (object2.hasNext()) {
            IrConstructor element$iv;
            it2 = element$iv = object2.next();
            boolean bl7 = false;
            if (!(it2.getValueParameters().size() == 1)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructor superClassConstructor = single$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)constructor2).getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        object2 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        it2 = this_$iv$iv;
        Object object3 = constructor2;
        boolean bl8 = false;
        if (capturedThisField != null) {
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrValueParameter irValueParameter2 = $this$addConstructorForNamedFunction.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter2);
            IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter2);
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrValueParameter irValueParameter3 = capturedThisParameter;
            Intrinsics.checkNotNull(irValueParameter3);
            $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, irExpression, capturedThisField, ExpressionHelpersKt.irGet(irBuilderWithScope3, irValueParameter3), null, 8, null));
        }
        IrDelegatingConstructorCall irDelegatingConstructorCall3 = irDelegatingConstructorCall2 = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249, superClassConstructor);
        void var21_29 = $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
        boolean bl9 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249, completionParameterSymbol));
        var21_29.unaryPlus(irDelegatingConstructorCall2);
        ((IrFunction)object3).setBody(this_$iv$iv.doBuild());
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void addInvokeSuspendForNamedFunction(IrClass $this$addInvokeSuspendForNamedFunction, IrFunction irFunction2, IrField resultField, IrField labelField, IrField capturedThisField, boolean isStaticSuspendImpl) {
        void $this$single$iv;
        JvmBackendContext backendContext = this.getContext();
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), Name.identifier("invokeSuspend"))) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction invokeSuspend = single$iv;
        this.addFunctionOverride($this$addInvokeSuspendForNamedFunction, invokeSuspend, irFunction2.getStartOffset(), irFunction2.getEndOffset(), (Function2<? super IrBlockBodyBuilder, ? super IrFunction, Unit>)new Function2<IrBlockBodyBuilder, IrFunction, Unit>(resultField, labelField, irFunction2, $this$addInvokeSuspendForNamedFunction, capturedThisField, backendContext, isStaticSuspendImpl){
            final /* synthetic */ IrField $resultField;
            final /* synthetic */ IrField $labelField;
            final /* synthetic */ IrFunction $irFunction;
            final /* synthetic */ IrClass $this_addInvokeSuspendForNamedFunction;
            final /* synthetic */ IrField $capturedThisField;
            final /* synthetic */ JvmBackendContext $backendContext;
            final /* synthetic */ boolean $isStaticSuspendImpl;
            {
                this.$resultField = $resultField;
                this.$labelField = $labelField;
                this.$irFunction = $irFunction;
                this.$this_addInvokeSuspendForNamedFunction = $receiver;
                this.$capturedThisField = $capturedThisField;
                this.$backendContext = $backendContext;
                this.$isStaticSuspendImpl = $isStaticSuspendImpl;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IrBlockBodyBuilder $this$addFunctionOverride, @NotNull IrFunction function2) {
                IrGetFieldImpl capturedThisValue;
                IrGetFieldImpl irGetFieldImpl;
                Object it;
                void $this$single$iv;
                Intrinsics.checkNotNullParameter($this$addFunctionOverride, "$this$addFunctionOverride");
                Intrinsics.checkNotNullParameter(function2, "function");
                IrBuilderWithScope irBuilderWithScope = $this$addFunctionOverride;
                IrBuilderWithScope irBuilderWithScope2 = $this$addFunctionOverride;
                IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
                Intrinsics.checkNotNull(irValueParameter);
                $this$addFunctionOverride.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), this.$resultField, ExpressionHelpersKt.irGet($this$addFunctionOverride, function2.getValueParameters().get(0)), null, 8, null));
                int signBit = Integer.MIN_VALUE;
                IrBuilderWithScope irBuilderWithScope3 = $this$addFunctionOverride;
                IrBuilderWithScope irBuilderWithScope4 = $this$addFunctionOverride;
                IrValueParameter irValueParameter2 = function2.getDispatchReceiverParameter();
                Intrinsics.checkNotNull(irValueParameter2);
                Object object = IrUtilsKt.getFunctions($this$addFunctionOverride.getContext().getIrBuiltIns().getIntClass());
                IrBuilderWithScope irBuilderWithScope5 = $this$addFunctionOverride;
                IrField irField = this.$labelField;
                Object object2 = ExpressionHelpersKt.irGet(irBuilderWithScope4, irValueParameter2);
                IrBuilderWithScope irBuilderWithScope6 = irBuilderWithScope3;
                IrBlockBodyBuilder irBlockBodyBuilder = $this$addFunctionOverride;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName(), OperatorNameConventions.OR)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                Object var22_20 = single$iv;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = var22_20;
                IrType irType = $this$addFunctionOverride.getContext().getIrBuiltIns().getIntType();
                IrBuilderWithScope irBuilderWithScope7 = $this$addFunctionOverride;
                IrBuilderWithScope irBuilderWithScope8 = $this$addFunctionOverride;
                IrValueParameter irValueParameter3 = function2.getDispatchReceiverParameter();
                Intrinsics.checkNotNull(irValueParameter3);
                irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope6, (IrExpression)object2, irField, ExpressionHelpersKt.irCallOp$default(irBuilderWithScope5, irSimpleFunctionSymbol, irType, ExpressionHelpersKt.irGetField$default(irBuilderWithScope7, ExpressionHelpersKt.irGet(irBuilderWithScope8, irValueParameter3), this.$labelField, null, 4, null), ExpressionHelpersKt.irInt$default($this$addFunctionOverride, signBit, null, 2, null), null, 16, null), null, 8, null));
                object = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$addFunctionOverride, this.$irFunction);
                IrFunction irFunction2 = this.$irFunction;
                IrClass irClass2 = this.$this_addInvokeSuspendForNamedFunction;
                IrField irField2 = this.$capturedThisField;
                JvmBackendContext jvmBackendContext = this.$backendContext;
                boolean bl = this.$isStaticSuspendImpl;
                it = object;
                irBuilderWithScope6 = $this$addFunctionOverride;
                irBlockBodyBuilder = $this$addFunctionOverride;
                boolean bl2 = false;
                int n = irFunction2.getTypeParameters().size();
                for (int i = 0; i < n; ++i) {
                    ((IrMemberAccessExpression)it).putTypeArgument(i, IrTypesKt.getDefaultType(irClass2.getTypeParameters().get(i)));
                }
                IrField irField3 = irField2;
                if (irField3 != null) {
                    IrField irField4 = irField3;
                    boolean bl3 = false;
                    IrBuilderWithScope irBuilderWithScope9 = $this$addFunctionOverride;
                    IrBuilderWithScope irBuilderWithScope10 = $this$addFunctionOverride;
                    IrValueParameter irValueParameter4 = function2.getDispatchReceiverParameter();
                    Intrinsics.checkNotNull(irValueParameter4);
                    irGetFieldImpl = ExpressionHelpersKt.irGetField$default(irBuilderWithScope9, ExpressionHelpersKt.irGet(irBuilderWithScope10, irValueParameter4), irField4, null, 4, null);
                } else {
                    irGetFieldImpl = capturedThisValue = null;
                }
                if (irFunction2.getDispatchReceiverParameter() != null) {
                    ((IrMemberAccessExpression)it).setDispatchReceiver(capturedThisValue);
                }
                IrValueParameter irValueParameter5 = irFunction2.getExtensionReceiverParameter();
                if (irValueParameter5 != null) {
                    IrValueParameter extensionReceiverParameter2 = irValueParameter5;
                    boolean bl4 = false;
                    ((IrMemberAccessExpression)it).setExtensionReceiver(JvmIrTypeUtilsKt.defaultValue(extensionReceiverParameter2.getType(), -1, -1, jvmBackendContext));
                }
                Iterator<IrValueParameter> iterator2 = CollectionsKt.dropLast(irFunction2.getValueParameters(), 1).iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    int i = n2++;
                    IrValueParameter parameter2 = iterator2.next();
                    ((IrMemberAccessExpression)it).putValueArgument(i, JvmIrTypeUtilsKt.defaultValue(parameter2.getType(), -1, -1, jvmBackendContext));
                }
                int n3 = irFunction2.getValueParameters().size() - 1;
                IrValueParameter irValueParameter6 = function2.getDispatchReceiverParameter();
                Intrinsics.checkNotNull(irValueParameter6);
                ((IrMemberAccessExpression)it).putValueArgument(n3, new IrGetValueImpl(-1, -1, irValueParameter6.getSymbol(), null, 8, null));
                if (bl) {
                    ((IrMemberAccessExpression)it).putValueArgument(0, capturedThisValue);
                }
                object2 = Unit.INSTANCE;
                irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope6, (IrExpression)object));
            }
        });
    }

    private final Name toSuspendImplementationName(Name $this$toSuspendImplementationName) {
        Name name2 = Name.guessByFirstCharacter($this$toSuspendImplementationName.asString() + "$suspendImpl");
        Intrinsics.checkNotNullExpressionValue(name2, "guessByFirstCharacter(...)");
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createStaticSuspendImpl(IrSimpleFunction irFunction2) {
        void it;
        int i;
        void $this$createStaticSuspendImpl_u24lambda_u2414;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        IrFactory irFactory = this.getContext().getIrFactory();
        IrDeclarationParent irDeclarationParent = irFunction2.getParent();
        Name name2 = this.toSuspendImplementationName(irFunction2.getName());
        IrFunction irFunction3 = irFunction2;
        IrDeclarationOrigin irDeclarationOrigin = JvmLoweredDeclarationOrigin.SUSPEND_IMPL_STATIC_FUNCTION.INSTANCE;
        DescriptorVisibility descriptorVisibility = JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(irFunction2)) ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNull(descriptorVisibility);
        IrSimpleFunction irSimpleFunction = IrUtilsKt.createStaticFunctionWithReceivers$default(irFactory, irDeclarationParent, name2, irFunction3, null, irDeclarationOrigin, Modality.OPEN, descriptorVisibility, false, false, IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass(irFunction2)), new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.getContext()){

            public final void invoke(@NotNull IrFunction p0, @NotNull IrFunction p1, @Nullable Map<IrValueParameter, ? extends IrValueParameter> p2) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
            }

            @NotNull
            public final String getSignature() {
                return "remapMultiFieldValueClassStructure(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Ljava/util/Map;)V";
            }

            @NotNull
            public final String getName() {
                return "remapMultiFieldValueClassStructure";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(JvmBackendContext.class);
            }
        }, 8, null);
        irSimpleFunction.setBody(IrInlineUtilsKt.moveBodyTo(irFunction2, irSimpleFunction));
        if (IrUtilsKt.getParentAsClass(irFunction2).isInner()) {
            IrValueParameter movedDispatchParameter = irSimpleFunction.getValueParameters().get(0);
            boolean bl = Intrinsics.areEqual(movedDispatchParameter.getOrigin(), IrDeclarationOrigin.MOVED_DISPATCH_RECEIVER.INSTANCE);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = false;
                String $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = "MOVED_DISPATCH_RECEIVER should be the first parameter in " + RenderIrElementKt.render$default(irSimpleFunction, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22);
            }
            IrBody irBody = irSimpleFunction.getBody();
            Intrinsics.checkNotNull(irBody);
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(irFunction2, movedDispatchParameter, this){
                final /* synthetic */ IrSimpleFunction $irFunction;
                final /* synthetic */ IrValueParameter $movedDispatchParameter;
                final /* synthetic */ AddContinuationLowering this$0;
                {
                    this.$irFunction = $irFunction;
                    this.$movedDispatchParameter = $movedDispatchParameter;
                    this.this$0 = $receiver;
                }

                @NotNull
                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrValueDeclaration owner = expression2.getSymbol().getOwner();
                    if (owner instanceof IrValueParameter && this.isInstanceReceiverOfOuterClass((IrValueParameter)owner)) {
                        IrClass cursor = IrUtilsKt.getParentAsClass(this.$irFunction);
                        IrExpression value2 = new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.$movedDispatchParameter.getSymbol(), null, 8, null);
                        while (!Intrinsics.areEqual(cursor, owner.getParent())) {
                            IrField outerThisField = this.this$0.getContext().getInnerClassesSupport().getOuterThisField(cursor);
                            value2 = new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), outerThisField.getSymbol(), outerThisField.getType(), value2, null, null, 96, null);
                            cursor = IrUtilsKt.getParentAsClass(cursor);
                        }
                        return value2;
                    }
                    return super.visitGetValue(expression2);
                }

                private final boolean isInstanceReceiverOfOuterClass(IrValueParameter param) {
                    if (!Intrinsics.areEqual(param.getOrigin(), IrDeclarationOrigin.INSTANCE_RECEIVER.INSTANCE)) {
                        return false;
                    }
                    if (!(param.getParent() instanceof IrClass)) {
                        return false;
                    }
                    IrDeclarationParent cursor = IrUtilsKt.getParentAsClass(this.$irFunction).getParent();
                    while (cursor instanceof IrClass) {
                        if (Intrinsics.areEqual(cursor, param.getParent())) {
                            return true;
                        }
                        cursor = ((IrClass)cursor).getParent();
                    }
                    return false;
                }
            });
        }
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)irSimpleFunction, irFunction2);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)irFunction2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_11 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = irFunction2;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2414, irSimpleFunction);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2414;
        void var14_17 = $this$createStaticSuspendImpl_u24lambda_u2414;
        boolean bl2 = false;
        int n = irFunction2.getTypeParameters().size();
        for (i = 0; i < n; ++i) {
            it.putTypeArgument(i, $this$createStaticSuspendImpl_u24lambda_u2414.getContext().getIrBuiltIns().getAnyNType());
        }
        i = 0;
        if (irFunction2.getDispatchReceiverParameter() != null) {
            int n2 = i++;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2414;
            IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            it.putValueArgument(n2, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter));
        }
        if (irFunction2.getExtensionReceiverParameter() != null) {
            int n3 = i++;
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2414;
            IrValueParameter irValueParameter = irFunction2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            it.putValueArgument(n3, ExpressionHelpersKt.irGet(irBuilderWithScope3, irValueParameter));
        }
        for (IrValueParameter parameter2 : irFunction2.getValueParameters()) {
            it.putValueArgument(i++, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2414, parameter2));
        }
        Unit unit2 = Unit.INSTANCE;
        var14_17.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
        irSimpleFunction2.setBody(this_$iv$iv.doBuild());
        return irSimpleFunction;
    }

    private final void addContinuationObjectAndContinuationParameterToSuspendFunctions(IrFile irFile) {
        irFile.accept(new IrElementTransformerVoid(this){
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                TransformKt.transformDeclarationsFlat(declaration, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
                    final /* synthetic */ addContinuationObjectAndContinuationParameterToSuspendFunctions.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final List<IrDeclaration> invoke(@NotNull IrDeclaration it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isSuspend()) {
                            return addContinuationObjectAndContinuationParameterToSuspendFunctions.1.access$transformToView(this.this$0, (IrSimpleFunction)it);
                        }
                        it.accept(this.this$0, null);
                        return null;
                    }
                });
                return declaration;
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrFunction> transformToView(IrSimpleFunction function2) {
                void $this$transformToView_u24lambda_u244;
                void this_$iv$iv;
                void $this$irBlockBody_u24default$iv;
                IrSimpleFunction irSimpleFunction;
                Object $this$buildFun$iv;
                Object $this$transformToView_u24lambda_u241;
                IrFactory $this$filterTo$iv$iv;
                void $this$filter$iv;
                function2.accept(this, null);
                boolean capturesCrossinline = this.isCapturingCrossinline(function2);
                IrSimpleFunction view = AddContinuationLoweringKt.access$suspendFunctionViewOrStub(function2, this.this$0.getContext());
                IrValueParameter continuationParameter = JvmIrCoroutineUtilsKt.continuationParameter(view);
                Iterable iterable = IrUtilsKt.getExplicitParameters(view);
                Object object = IrUtilsKt.getExplicitParameters(function2);
                boolean $i$f$filter22 = false;
                void var8_9 = $this$filter$iv;
                Object destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Object object2 = $this$filterTo$iv$iv.iterator();
                while (object2.hasNext()) {
                    T element$iv$iv = object2.next();
                    IrValueParameter it = (IrValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual(it, continuationParameter))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Map<K, V> parameterMap = MapsKt.toMap((Iterable)CollectionsKt.zip(object, (List)destination$iv$iv));
                view.setBody(IrInlineUtilsKt.moveBodyTo(function2, view, parameterMap));
                Object $i$f$filter22 = new IrSimpleFunction[]{view};
                List<IrFunction> result2 = CollectionsKt.mutableListOf($i$f$filter22);
                if (function2.getBody() == null || !JvmIrCoroutineUtilsKt.hasContinuation(function2)) {
                    return result2;
                }
                if (Intrinsics.areEqual(IrUtilsKt.getParentAsClass(function2).getOrigin(), JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE) || Intrinsics.areEqual(IrUtilsKt.getParentAsClass(function2).getOrigin(), JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE)) {
                    JvmBackendContext jvmBackendContext = this.this$0.getContext();
                    IrAttributeContainer irAttributeContainer = function2.getAttributeOwnerId();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    Type type2 = this.this$0.getContext().getLocalClassType(IrUtilsKt.getParentAsClass(function2));
                    Intrinsics.checkNotNull(type2);
                    Type type3 = Type.getObjectType(stringBuilder2.append(type2.getInternalName()).append('$').append(function2.getName()).append("$1").toString());
                    Intrinsics.checkNotNullExpressionValue(type3, "getObjectType(...)");
                    jvmBackendContext.putLocalClassType(irAttributeContainer, type3);
                }
                if (capturesCrossinline || function2.isInline()) {
                    DescriptorVisibility descriptorVisibility;
                    $i$f$filter22 = result2;
                    $this$filterTo$iv$iv = this.this$0.getContext().getIrFactory();
                    destination$iv$iv = this.this$0;
                    boolean $i$f$buildFun = false;
                    IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
                    boolean bl = false;
                    $this$transformToView_u24lambda_u241 = $this$buildFun_u24lambda_u2420$iv;
                    boolean bl2 = false;
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u241).setContainerSource(view.getContainerSource());
                    Name name2 = Name.identifier(MethodSignatureMapper.mapFunctionName$default(((SuspendLoweringUtils)destination$iv$iv).getContext().getDefaultMethodSignatureMapper(), view, false, 2, null) + "$$forInline");
                    Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u241).setName(name2);
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u241).setReturnType(view.getReturnType());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u241).setModality(view.getModality());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u241).setSuspend(view.isSuspend());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u241).setInline(view.isInline());
                    if (view.isInline()) {
                        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PRIVATE;
                        descriptorVisibility = descriptorVisibility2;
                        Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "PRIVATE");
                    } else {
                        descriptorVisibility = view.getVisibility();
                    }
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u241).setVisibility(descriptorVisibility);
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u241).setOrigin(view.isInline() ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.FOR_INLINE_STATE_MACHINE_TEMPLATE.INSTANCE : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.FOR_INLINE_STATE_MACHINE_TEMPLATE_CAPTURES_CROSSINLINE.INSTANCE);
                    $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
                    destination$iv$iv = this.this$0;
                    Object $this$transformToView_u24lambda_u242 = $this$buildFun$iv;
                    boolean bl3 = false;
                    IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)$this$transformToView_u24lambda_u242, view);
                    IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)$this$transformToView_u24lambda_u242, view);
                    ((SuspendLoweringUtils)destination$iv$iv).getContext().remapMultiFieldValueClassStructure(view, (IrFunction)$this$transformToView_u24lambda_u242, null);
                    IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$transformToView_u24lambda_u242, view);
                    ((SuspendLoweringUtils)destination$iv$iv).generateErrorForInlineBody((IrSimpleFunction)$this$transformToView_u24lambda_u242);
                    $i$f$filter22.add($this$buildFun$iv);
                }
                if (IrUtilsKt.isOverridable(function2)) {
                    $this$buildFun$iv = AddContinuationLowering.access$createStaticSuspendImpl(this.this$0, view);
                    IrSimpleFunction it = $this$buildFun$iv;
                    boolean bl = false;
                    ((Collection)result2).add(it);
                    irSimpleFunction = $this$buildFun$iv;
                } else {
                    irSimpleFunction = view;
                }
                IrSimpleFunction newFunction2 = irSimpleFunction;
                $this$buildFun$iv = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)newFunction2.getSymbol(), 0, 0, 6, null);
                object2 = this.this$0;
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                $this$transformToView_u24lambda_u241 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var15_22 = this_$iv$iv;
                object = newFunction2;
                boolean bl = false;
                IrFunction irFunction2 = newFunction2;
                IrValueParameter irValueParameter = view.getDispatchReceiverParameter();
                Intrinsics.checkNotNull(function2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrAttributeContainer");
                $this$transformToView_u24lambda_u244.unaryPlus(AddContinuationLowering.access$generateContinuationClassForNamedFunction((AddContinuationLowering)object2, irFunction2, irValueParameter, function2, capturesCrossinline));
                if (newFunction2.getBody() instanceof IrExpressionBody) {
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformToView_u24lambda_u244;
                    IrBody irBody = newFunction2.getBody();
                    Intrinsics.checkNotNull(irBody);
                    IrStatement irStatement = IrUtilsKt.getStatements(irBody).get(0);
                    Intrinsics.checkNotNull(irStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    $this$transformToView_u24lambda_u244.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, (IrExpression)irStatement));
                } else {
                    IrBody irBody = newFunction2.getBody();
                    Intrinsics.checkNotNull(irBody);
                    for (IrStatement statement2 : IrUtilsKt.getStatements(irBody)) {
                        $this$transformToView_u24lambda_u244.unaryPlus(statement2);
                    }
                }
                ((IrFunction)object).setBody(this_$iv$iv.doBuild());
                return result2;
            }

            private final boolean isCapturingCrossinline(IrSimpleFunction $this$isCapturingCrossinline) {
                Ref.BooleanRef capturesCrossinline = new Ref.BooleanRef();
                IrAttributeContainer irAttributeContainer = $this$isCapturingCrossinline.getOriginalBeforeInline();
                if (irAttributeContainer == null) {
                    irAttributeContainer = $this$isCapturingCrossinline;
                }
                IrVisitorsKt.acceptVoid(irAttributeContainer, new IrElementVisitorVoid(capturesCrossinline){
                    final /* synthetic */ Ref.BooleanRef $capturesCrossinline;
                    {
                        this.$capturesCrossinline = $capturesCrossinline;
                    }

                    public void visitElement(@NotNull IrElement element) {
                        Intrinsics.checkNotNullParameter(element, "element");
                        IrVisitorsKt.acceptChildrenVoid(element, this);
                    }

                    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        if (Intrinsics.areEqual(((IrField)expression2.getSymbol().getOwner()).getOrigin(), LocalDeclarationsLowering.DECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE.INSTANCE)) {
                            this.$capturesCrossinline.element = true;
                            return;
                        }
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                    }

                    public void visitClass(@NotNull IrClass declaration) {
                        Intrinsics.checkNotNullParameter(declaration, "declaration");
                    }

                    public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
                    }

                    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
                    }

                    public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
                    }

                    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                    }

                    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
                    }

                    public void visitBlock(@NotNull IrBlock expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                    }

                    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
                    }

                    public void visitBlockBody(@NotNull IrBlockBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                    }

                    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
                    }

                    public void visitBody(@NotNull IrBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                    }

                    public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
                    }

                    public void visitBranch(@NotNull IrBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                    }

                    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
                    }

                    public void visitBreak(@NotNull IrBreak jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                    }

                    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
                    }

                    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                    }

                    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
                    }

                    public void visitCall(@NotNull IrCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                    }

                    public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
                    }

                    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                    }

                    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
                    }

                    public void visitCatch(@NotNull IrCatch aCatch) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                    }

                    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
                    }

                    public void visitClassReference(@NotNull IrClassReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                    }

                    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
                    }

                    public void visitComposite(@NotNull IrComposite expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                    }

                    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
                    }

                    public void visitConst(@NotNull IrConst<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                    }

                    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
                    }

                    public void visitConstantArray(@NotNull IrConstantArray expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
                    }

                    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
                    }

                    public void visitConstantObject(@NotNull IrConstantObject expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
                    }

                    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
                    }

                    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
                    }

                    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
                    }

                    public void visitConstantValue(@NotNull IrConstantValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
                    }

                    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
                    }

                    public void visitConstructor(@NotNull IrConstructor declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                    }

                    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
                    }

                    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                    }

                    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
                    }

                    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                    }

                    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
                    }

                    public void visitContinue(@NotNull IrContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                    }

                    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
                    }

                    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                    }

                    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
                    }

                    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                    }

                    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
                    }

                    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                    }

                    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
                    }

                    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                    }

                    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
                    }

                    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                    }

                    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
                    }

                    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                    }

                    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
                    }

                    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                    }

                    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
                    }

                    public void visitElseBranch(@NotNull IrElseBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                    }

                    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
                    }

                    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                    }

                    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
                    }

                    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                    }

                    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
                    }

                    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                    }

                    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
                    }

                    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                    }

                    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
                    }

                    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                    }

                    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
                    }

                    public void visitExpression(@NotNull IrExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                    }

                    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
                    }

                    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                    }

                    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
                    }

                    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                    }

                    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
                    }

                    public void visitField(@NotNull IrField declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                    }

                    public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
                    }

                    public void visitFile(@NotNull IrFile declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                    }

                    public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
                    }

                    public void visitFunction(@NotNull IrFunction declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
                    }

                    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
                    }

                    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                    }

                    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
                    }

                    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                    }

                    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
                    }

                    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                    }

                    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
                    }

                    public void visitGetClass(@NotNull IrGetClass expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                    }

                    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
                    }

                    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                    }

                    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
                    }

                    public void visitGetField(@NotNull IrGetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                    }

                    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
                    }

                    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                    }

                    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
                    }

                    public void visitGetValue(@NotNull IrGetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                    }

                    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
                    }

                    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                    }

                    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
                    }

                    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                    }

                    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
                    }

                    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                    }

                    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
                    }

                    public void visitLoop(@NotNull IrLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                    }

                    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
                    }

                    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                    }

                    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
                    }

                    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                    }

                    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
                    }

                    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                    }

                    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
                    }

                    public void visitProperty(@NotNull IrProperty declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                    }

                    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
                    }

                    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                    }

                    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
                    }

                    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                    }

                    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
                    }

                    public void visitReturn(@NotNull IrReturn expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                    }

                    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
                    }

                    public void visitScript(@NotNull IrScript declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
                    }

                    public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
                    }

                    public void visitSetField(@NotNull IrSetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                    }

                    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
                    }

                    public void visitSetValue(@NotNull IrSetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                    }

                    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
                    }

                    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                    }

                    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
                    }

                    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                    }

                    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
                    }

                    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                    }

                    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
                    }

                    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                    }

                    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
                    }

                    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                    }

                    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
                    }

                    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                    }

                    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
                    }

                    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                    }

                    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
                    }

                    public void visitThrow(@NotNull IrThrow expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                    }

                    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
                    }

                    public void visitTry(@NotNull IrTry aTry) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                    }

                    public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
                    }

                    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                    }

                    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
                    }

                    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                    }

                    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
                    }

                    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                    }

                    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
                    }

                    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
                    }

                    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
                    }

                    public void visitValueParameter(@NotNull IrValueParameter declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                    }

                    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
                    }

                    public void visitVararg(@NotNull IrVararg expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                    }

                    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
                    }

                    public void visitVariable(@NotNull IrVariable declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
                    }

                    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
                    }

                    public void visitWhen(@NotNull IrWhen expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                    }

                    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
                    }

                    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                    }

                    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
                    }
                });
                return capturesCrossinline.element;
            }

            public static final /* synthetic */ List access$transformToView(addContinuationObjectAndContinuationParameterToSuspendFunctions.1 $this, IrSimpleFunction function2) {
                return $this.transformToView(function2);
            }
        }, null);
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticSuspendImpl(AddContinuationLowering $this, IrSimpleFunction irFunction2) {
        return $this.createStaticSuspendImpl(irFunction2);
    }

    public static final /* synthetic */ IrClass access$generateContinuationClassForNamedFunction(AddContinuationLowering $this, IrFunction irFunction2, IrValueParameter dispatchReceiverParameter2, IrAttributeContainer attributeContainer, boolean capturesCrossinline) {
        return $this.generateContinuationClassForNamedFunction(irFunction2, dispatchReceiverParameter2, attributeContainer, capturesCrossinline);
    }
}

