/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.DefaultDiagnosticReporter;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.GenericDiagnostics;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.load.java.components.TraceBasedErrorReporter;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\u0016\u0010 \u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u001a\u0010\f\u001a\u00020\rX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport;", "Lorg/jetbrains/kotlin/analyzer/AbstractAnalyzerWithCompilerReport;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "renderDiagnosticName", "", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Z)V", "analysisResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "setAnalysisResult", "(Lorg/jetbrains/kotlin/analyzer/AnalysisResult;)V", "targetEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "getTargetEnvironment", "()Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "analyzeAndReport", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "analyze", "Lkotlin/Function0;", "hasErrors", "reportAlternativeSignatureErrors", "reportIncompleteHierarchies", "reportSyntaxErrors", "Companion", "MyDiagnostic", "SyntaxErrorReport", "cli"})
public final class AnalyzerWithCompilerReport
implements AbstractAnalyzerWithCompilerReport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean renderDiagnosticName;
    public AnalysisResult analysisResult;
    @NotNull
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY;

    public AnalyzerWithCompilerReport(@NotNull MessageCollector messageCollector, @NotNull LanguageVersionSettings languageVersionSettings2, boolean renderDiagnosticName) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
        this.messageCollector = messageCollector;
        this.languageVersionSettings = languageVersionSettings2;
        this.renderDiagnosticName = renderDiagnosticName;
    }

    @Override
    @NotNull
    public TargetEnvironment getTargetEnvironment() {
        return CompilerEnvironment.INSTANCE;
    }

    @Override
    @NotNull
    public AnalysisResult getAnalysisResult() {
        AnalysisResult analysisResult2 = this.analysisResult;
        if (analysisResult2 != null) {
            return analysisResult2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("analysisResult");
        return null;
    }

    public void setAnalysisResult(@NotNull AnalysisResult analysisResult2) {
        Intrinsics.checkNotNullParameter(analysisResult2, "<set-?>");
        this.analysisResult = analysisResult2;
    }

    public AnalyzerWithCompilerReport(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        MessageCollector messageCollector = configuration2.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            messageCollector = MessageCollector.Companion.getNONE();
        }
        MessageCollector messageCollector2 = messageCollector;
        Intrinsics.checkNotNull(messageCollector2);
        this(messageCollector2, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2), configuration2.getBoolean(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME));
    }

    private final void reportIncompleteHierarchies() {
        BindingContext bindingContext = this.getAnalysisResult().getBindingContext();
        Collection<ClassDescriptor> collection = bindingContext.getKeys(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY);
        Intrinsics.checkNotNullExpressionValue(collection, "getKeys(...)");
        Collection<ClassDescriptor> classes2 = collection;
        if (!classes2.isEmpty()) {
            StringBuilder message2 = new StringBuilder("Supertypes of the following classes cannot be resolved. Please make sure you have the required dependencies in the classpath:\n");
            for (ClassDescriptor descriptor2 : classes2) {
                String fqName2;
                boolean bl;
                Intrinsics.checkNotNullExpressionValue(DescriptorUtils.getFqName(descriptor2).asString(), "asString(...)");
                List unresolved = (List)bindingContext.get(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY, descriptor2);
                boolean bl2 = bl = unresolved != null && !unresolved.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Incomplete hierarchy should be reported with names of unresolved superclasses: " + fqName2;
                    throw new AssertionError((Object)string2);
                }
                StringBuilder stringBuilder2 = message2.append("    class ").append(fqName2).append(", unresolved supertypes: ");
                List list2 = unresolved;
                Intrinsics.checkNotNull(list2);
                stringBuilder2.append(CollectionsKt.joinToString$default(list2, null, null, null, 0, null, null, 63, null)).append("\n");
            }
            if (!this.languageVersionSettings.getFlag(AnalysisFlags.getExtendedCompilerChecks()).booleanValue()) {
                message2.append("Adding -Xextended-compiler-checks argument might provide additional information.\n");
            }
            String string3 = message2.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string3, null, 4, null);
        }
    }

    private final void reportAlternativeSignatureErrors() {
        BindingContext bc = this.getAnalysisResult().getBindingContext();
        Collection<DeclarationDescriptor> collection = bc.getKeys(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        Intrinsics.checkNotNullExpressionValue(collection, "getKeys(...)");
        Collection<DeclarationDescriptor> descriptorsWithErrors = collection;
        if (!descriptorsWithErrors.isEmpty()) {
            StringBuilder message2 = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            for (DeclarationDescriptor descriptor2 : descriptorsWithErrors) {
                boolean bl;
                Intrinsics.checkNotNull(descriptor2);
                PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
                boolean bl2 = declaration instanceof PsiModifierListOwner;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                List errors2 = (List)bc.get(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2);
                boolean bl3 = bl = errors2 != null && !errors2.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                Intrinsics.checkNotNull(declaration, "null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)declaration);
                message2.append(externalName).append(":\n");
                List list2 = errors2;
                Intrinsics.checkNotNull(list2);
                for (String error : list2) {
                    message2.append("    ").append(error).append("\n");
                }
            }
            String string4 = message2.toString();
            Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
            MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string4, null, 4, null);
        }
    }

    private final void reportSyntaxErrors(Collection<? extends KtFile> files2) {
        for (KtFile ktFile : files2) {
            Companion.reportSyntaxErrors((PsiElement)ktFile, this.messageCollector);
        }
    }

    @Override
    public boolean hasErrors() {
        return this.messageCollector.hasErrors();
    }

    @Override
    public void analyzeAndReport(@NotNull Collection<? extends KtFile> files2, @NotNull Function0<? extends AnalysisResult> analyze2) {
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(analyze2, "analyze");
        this.setAnalysisResult(analyze2.invoke());
        if (!this.getAnalysisResult().isError()) {
            OptInUsageChecker.Companion.checkCompilerArguments(this.getAnalysisResult().getModuleDescriptor(), this.languageVersionSettings, (Function1<? super String, Unit>)new Function1<String, Unit>(this){
                final /* synthetic */ AnalyzerWithCompilerReport this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String message2) {
                    Intrinsics.checkNotNullParameter(message2, "message");
                    MessageCollector.report$default(AnalyzerWithCompilerReport.access$getMessageCollector$p(this.this$0), CompilerMessageSeverity.ERROR, message2, null, 4, null);
                }
            }, (Function1<? super String, Unit>)new Function1<String, Unit>(this){
                final /* synthetic */ AnalyzerWithCompilerReport this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String message2) {
                    Intrinsics.checkNotNullParameter(message2, "message");
                    MessageCollector.report$default(AnalyzerWithCompilerReport.access$getMessageCollector$p(this.this$0), CompilerMessageSeverity.WARNING, message2, null, 4, null);
                }
            });
        }
        this.reportSyntaxErrors(files2);
        Diagnostics diagnostics2 = this.getAnalysisResult().getBindingContext().getDiagnostics();
        Intrinsics.checkNotNullExpressionValue(diagnostics2, "getDiagnostics(...)");
        Companion.reportDiagnostics((GenericDiagnostics)diagnostics2, this.messageCollector, this.renderDiagnosticName);
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
    }

    public static final /* synthetic */ MessageCollector access$getMessageCollector$p(AnalyzerWithCompilerReport $this) {
        return $this.messageCollector;
    }

    public static final /* synthetic */ DiagnosticFactory0 access$getSYNTAX_ERROR_FACTORY$cp() {
        return SYNTAX_ERROR_FACTORY;
    }

    static {
        DiagnosticFactory0 diagnosticFactory0 = DiagnosticFactory0.create(Severity.ERROR);
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "create(...)");
        SYNTAX_ERROR_FACTORY = diagnosticFactory0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\"\u0010\u0012\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\"\u0010\u0012\u001a\u00020\f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion;", "", "()V", "SYNTAX_ERROR_FACTORY", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lcom/intellij/psi/PsiErrorElement;", "kotlin.jvm.PlatformType", "convertSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reporter", "Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;", "renderDiagnosticName", "reportDiagnostics", "unsortedDiagnostics", "Lorg/jetbrains/kotlin/diagnostics/GenericDiagnostics;", "diagnostics", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "renderInternalDiagnosticName", "reportSyntaxErrors", "Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "file", "Lcom/intellij/psi/PsiElement;", "cli"})
    @SourceDebugExtension(value={"SMAP\nAnalyzerWithCompilerReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzerWithCompilerReport.kt\norg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n800#2,11:265\n1747#2,3:276\n1747#2,3:279\n1747#2,3:282\n1747#2,3:285\n*S KotlinDebug\n*F\n+ 1 AnalyzerWithCompilerReport.kt\norg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion\n*L\n171#1:265,11\n185#1:276,3\n193#1:279,3\n202#1:282,3\n210#1:285,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
            CompilerMessageSeverity compilerMessageSeverity;
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    compilerMessageSeverity = CompilerMessageSeverity.INFO;
                    break;
                }
                case 2: {
                    compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    break;
                }
                case 3: {
                    compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown severity: " + (Object)((Object)severity));
                }
            }
            return compilerMessageSeverity;
        }

        private final boolean reportDiagnostic(Diagnostic diagnostic, DiagnosticMessageReporter reporter, boolean renderDiagnosticName) {
            Object object;
            if (!diagnostic.isValid()) {
                return false;
            }
            Object object2 = diagnostic instanceof MyDiagnostic ? (MyDiagnostic)diagnostic : null;
            if (object2 == null || (object2 = ((MyDiagnostic)object2).getMessage()) == null) {
                String string2 = DefaultErrorMessages.render(diagnostic);
                object2 = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "render(...)");
            }
            Object message2 = object2;
            boolean bl = renderDiagnosticName;
            if (bl) {
                object = '[' + diagnostic.getFactoryName() + "] " + (String)message2;
            } else if (!bl) {
                object = message2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Object textToRender = object;
            reporter.report(diagnostic, diagnostic.getPsiFile(), (String)textToRender);
            return diagnostic.getSeverity() == Severity.ERROR;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean reportDiagnostics(@NotNull GenericDiagnostics<?> unsortedDiagnostics, @NotNull DiagnosticMessageReporter reporter, boolean renderDiagnosticName) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(unsortedDiagnostics, "unsortedDiagnostics");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            boolean hasErrors = false;
            Iterable $this$filterIsInstance$iv = unsortedDiagnostics.all();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Diagnostic)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Diagnostic> list2 = DiagnosticUtils.sortedDiagnostics((List)destination$iv$iv);
            Intrinsics.checkNotNullExpressionValue(list2, "sortedDiagnostics(...)");
            List<Diagnostic> diagnostics2 = list2;
            for (Diagnostic diagnostic : diagnostics2) {
                Intrinsics.checkNotNull(diagnostic);
                hasErrors |= this.reportDiagnostic(diagnostic, reporter, renderDiagnosticName);
            }
            return hasErrors;
        }

        public final boolean reportDiagnostics(@NotNull GenericDiagnostics<?> diagnostics2, @NotNull MessageCollector messageCollector, boolean renderInternalDiagnosticName) {
            boolean bl;
            boolean hasErrors;
            block19: {
                boolean bl2;
                UnboundDiagnostic it;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block18: {
                    boolean bl3;
                    block17: {
                        boolean bl4;
                        block16: {
                            Intrinsics.checkNotNullParameter(diagnostics2, "diagnostics");
                            Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
                            hasErrors = this.reportDiagnostics(diagnostics2, new DefaultDiagnosticReporter(messageCollector), renderInternalDiagnosticName);
                            $this$any$iv = diagnostics2;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl4 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (UnboundDiagnostic)element$iv;
                                    boolean bl5 = false;
                                    if (!Intrinsics.areEqual(it.getFactory(), Errors.INCOMPATIBLE_CLASS)) continue;
                                    bl4 = true;
                                    break block16;
                                }
                                bl4 = false;
                            }
                        }
                        if (bl4) {
                            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Incompatible classes were found in dependencies. Remove them from the classpath or use '-Xskip-metadata-version-check' to suppress errors", null, 4, null);
                        }
                        $this$any$iv = diagnostics2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (UnboundDiagnostic)element$iv;
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual(it.getFactory(), Errors.PRE_RELEASE_CLASS)) continue;
                                bl3 = true;
                                break block17;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Pre-release classes were found in dependencies. Remove them from the classpath, recompile with a release compiler or use '-Xskip-prerelease-check' to suppress errors", null, 4, null);
                    }
                    $this$any$iv = diagnostics2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (UnboundDiagnostic)element$iv;
                            boolean bl7 = false;
                            if (!Intrinsics.areEqual(it.getFactory(), Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS)) continue;
                            bl2 = true;
                            break block18;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Classes compiled by an unstable version of the Kotlin compiler were found in dependencies. Remove them from the classpath or use '-Xallow-unstable-dependencies' to suppress errors", null, 4, null);
                }
                $this$any$iv = diagnostics2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (UnboundDiagnostic)element$iv;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual(it.getFactory(), Errors.FIR_COMPILED_CLASS)) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            if (bl) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Classes compiled by the new Kotlin compiler frontend were found in dependencies. Remove them from the classpath or use '-Xallow-unstable-dependencies' to suppress errors", null, 4, null);
            }
            return hasErrors;
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file2, @NotNull DiagnosticMessageReporter reporter) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0004*\u00020\u000fH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0019"}, d2={"org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion$reportSyntaxErrors$ErrorReportingVisitor", "Lorg/jetbrains/kotlin/resolve/AnalyzingUtils$PsiErrorElementVisitor;", "(Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;)V", "allErrorsAtEof", "", "getAllErrorsAtEof", "()Z", "setAllErrorsAtEof", "(Z)V", "hasErrors", "getHasErrors", "setHasErrors", "reportDiagnostic", "", "E", "Lcom/intellij/psi/PsiElement;", "element", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "message", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "visitErrorElement", "Lcom/intellij/psi/PsiErrorElement;", "isAtEof", "cli"})
            public final class ErrorReportingVisitor
            extends AnalyzingUtils.PsiErrorElementVisitor {
                private boolean hasErrors;
                private boolean allErrorsAtEof;
                final /* synthetic */ DiagnosticMessageReporter $reporter;

                public ErrorReportingVisitor(@NotNull DiagnosticMessageReporter $reporter) {
                    Intrinsics.checkNotNullParameter($reporter, "$reporter");
                    this.$reporter = $reporter;
                    this.allErrorsAtEof = true;
                }

                public final boolean getHasErrors() {
                    return this.hasErrors;
                }

                public final void setHasErrors(boolean bl) {
                    this.hasErrors = bl;
                }

                public final boolean getAllErrorsAtEof() {
                    return this.allErrorsAtEof;
                }

                public final void setAllErrorsAtEof(boolean bl) {
                    this.allErrorsAtEof = bl;
                }

                private final <E extends PsiElement> void reportDiagnostic(E element, DiagnosticFactory0<E> factory2, String message2) {
                    MyDiagnostic<E> diagnostic = new MyDiagnostic<E>(element, factory2, message2);
                    org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport$Companion.access$reportDiagnostic(AnalyzerWithCompilerReport.Companion, diagnostic, this.$reporter, false);
                    if (this.allErrorsAtEof && !this.isAtEof(element)) {
                        this.allErrorsAtEof = false;
                    }
                    this.hasErrors = true;
                }

                private final boolean isAtEof(PsiElement $this$isAtEof) {
                    PsiElement element = $this$isAtEof;
                    do {
                        if (element.getNextSibling() != null) continue;
                        return true;
                    } while (element instanceof PsiWhiteSpace && element instanceof PsiComment);
                    return false;
                }

                public void visitErrorElement(@NotNull PsiErrorElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    String string2 = element.getErrorDescription();
                    Intrinsics.checkNotNullExpressionValue(string2, "getErrorDescription(...)");
                    String description2 = string2;
                    this.reportDiagnostic((PsiElement)element, AnalyzerWithCompilerReport.access$getSYNTAX_ERROR_FACTORY$cp(), StringUtil.isEmpty(description2) ? "Syntax error" : description2);
                }
            }
            ErrorReportingVisitor visitor2 = new ErrorReportingVisitor(reporter);
            file2.accept(visitor2);
            return new SyntaxErrorReport(visitor2.getHasErrors(), visitor2.getAllErrorsAtEof());
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file2, @NotNull MessageCollector messageCollector) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
            return this.reportSyntaxErrors(file2, new DefaultDiagnosticReporter(messageCollector));
        }

        public static final /* synthetic */ boolean access$reportDiagnostic(Companion $this, Diagnostic diagnostic, DiagnosticMessageReporter reporter, boolean renderDiagnosticName) {
            return $this.reportDiagnostic(diagnostic, reporter, renderDiagnosticName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Severity.values().length];
                try {
                    nArray[Severity.INFO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.WARNING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic;", "E", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/diagnostics/SimpleDiagnostic;", "psiElement", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "message", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "isValid", "", "()Z", "getMessage", "()Ljava/lang/String;", "cli"})
    private static final class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        @NotNull
        private final String message;
        private final boolean isValid;

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory2, @NotNull String message2) {
            Intrinsics.checkNotNullParameter(psiElement, "psiElement");
            Intrinsics.checkNotNullParameter(factory2, "factory");
            Intrinsics.checkNotNullParameter(message2, "message");
            super(psiElement, factory2, Severity.ERROR);
            this.message = message2;
            this.isValid = true;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "", "isHasErrors", "", "isAllErrorsAtEof", "(ZZ)V", "()Z", "cli"})
    public static final class SyntaxErrorReport {
        private final boolean isHasErrors;
        private final boolean isAllErrorsAtEof;

        public SyntaxErrorReport(boolean isHasErrors, boolean isAllErrorsAtEof) {
            this.isHasErrors = isHasErrors;
            this.isAllErrorsAtEof = isAllErrorsAtEof;
        }

        public final boolean isHasErrors() {
            return this.isHasErrors;
        }

        public final boolean isAllErrorsAtEof() {
            return this.isAllErrorsAtEof;
        }
    }
}

