/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadataKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "", "tag", "Lorg/jetbrains/kotlin/js/backend/ast/JsStringLiteral;", "function", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStringLiteral;Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;)V", "getTag", "()Lorg/jetbrains/kotlin/js/backend/ast/JsStringLiteral;", "getFunction", "()Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "functionWithMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "sourceInfo", "Companion", "js.translator"})
public final class InlineMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsStringLiteral tag;
    @NotNull
    private final FunctionWithWrapper function;

    public InlineMetadata(@NotNull JsStringLiteral tag, @NotNull FunctionWithWrapper function2) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(function2, "function");
        this.tag = tag;
        this.function = function2;
    }

    @NotNull
    public final JsStringLiteral getTag() {
        return this.tag;
    }

    @NotNull
    public final FunctionWithWrapper getFunction() {
        return this.function;
    }

    @NotNull
    public final JsExpression functionWithMetadata(@NotNull TranslationContext context2, @Nullable Object sourceInfo) {
        Intrinsics.checkNotNullParameter(context2, "context");
        JsExpression[] jsExpressionArray = new JsExpression[]{this.tag, Companion.wrapFunction(context2, this.function, sourceInfo)};
        return new JsInvocation((JsExpression)context2.getNameForSpecialFunction(SpecialFunction.DEFINE_INLINE_FUNCTION).makeRef(), jsExpressionArray);
    }

    @JvmStatic
    @NotNull
    public static final InlineMetadata compose(@NotNull JsFunction function2, @NotNull CallableDescriptor descriptor, @NotNull TranslationContext context2) {
        return Companion.compose(function2, descriptor, context2);
    }

    @JvmStatic
    @Nullable
    public static final InlineMetadata decompose(@Nullable JsExpression expression2) {
        return Companion.decompose(expression2);
    }

    @JvmStatic
    @Nullable
    public static final FunctionWithWrapper tryExtractFunction(@NotNull JsExpression callExpression) {
        return Companion.tryExtractFunction(callExpression);
    }

    @JvmStatic
    @Nullable
    public static final FunctionWithWrapper decomposeWrapper(@NotNull JsFunction wrapperFunction) {
        return Companion.decomposeWrapper(wrapperFunction);
    }

    @JvmStatic
    @NotNull
    public static final JsExpression wrapFunction(@NotNull TranslationContext context2, @NotNull FunctionWithWrapper function2, @Nullable Object sourceInfo) {
        return Companion.wrapFunction(context2, function2, sourceInfo);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\"\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata$Companion;", "", "<init>", "()V", "compose", "Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "decompose", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "decomposeCreateFunctionCall", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "tryExtractFunction", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "callExpression", "decomposeWrapper", "wrapperFunction", "wrapFunction", "sourceInfo", "js.translator"})
    @SourceDebugExtension(value={"SMAP\nInlineMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineMetadata.kt\norg/jetbrains/kotlin/js/translate/expression/InlineMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1863#2,2:106\n*S KotlinDebug\n*F\n+ 1 InlineMetadata.kt\norg/jetbrains/kotlin/js/translate/expression/InlineMetadata$Companion\n*L\n89#1:106,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InlineMetadata compose(@NotNull JsFunction function2, @NotNull CallableDescriptor descriptor, @NotNull TranslationContext context2) {
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(descriptor, "descriptor");
            Intrinsics.checkNotNullParameter(context2, "context");
            JsStringLiteral tag = new JsStringLiteral(Namer.getFunctionTag(descriptor, context2.getConfig(), context2.bindingContext()));
            InlineFunctionContext inlineFunctionContext = context2.getInlineFunctionContext();
            Intrinsics.checkNotNull(inlineFunctionContext);
            InlineFunctionContext inliningContext = inlineFunctionContext;
            List<JsStatement> list = inliningContext.getImportBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
            Collection collection = list;
            List<JsStatement> list2 = inliningContext.getPrototypeBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
            Collection collection2 = CollectionsKt.plus(collection, (Iterable)list2);
            List<JsStatement> list3 = inliningContext.getDeclarationsBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "getStatements(...)");
            JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus(collection2, (Iterable)list3), new JsReturn(function2)));
            context2.reportInlineFunctionTag(tag.getValue());
            return new InlineMetadata(tag, new FunctionWithWrapper(function2, block));
        }

        @JvmStatic
        @Nullable
        public final InlineMetadata decompose(@Nullable JsExpression expression2) {
            return expression2 instanceof JsInvocation ? this.decomposeCreateFunctionCall((JsInvocation)expression2) : null;
        }

        private final InlineMetadata decomposeCreateFunctionCall(JsInvocation call2) {
            JsExpression jsExpression = call2.getQualifier();
            JsNameRef jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
            if (jsNameRef == null) {
                return null;
            }
            JsNameRef qualifier = jsNameRef;
            if (!Intrinsics.areEqual(qualifier.getIdent(), "defineInlineFunction")) {
                JsName jsName = qualifier.getName();
                if ((jsName != null ? MetadataProperties.getSpecialFunction(jsName) : null) != SpecialFunction.DEFINE_INLINE_FUNCTION) {
                    return null;
                }
            }
            List<JsExpression> list = call2.getArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
            List<JsExpression> arguments = list;
            if (arguments.size() != InlineMetadataKt.access$getMETADATA_PROPERTIES_COUNT$p()) {
                return null;
            }
            JsExpression jsExpression2 = arguments.get(0);
            JsStringLiteral jsStringLiteral = jsExpression2 instanceof JsStringLiteral ? (JsStringLiteral)jsExpression2 : null;
            if (jsStringLiteral == null) {
                return null;
            }
            JsStringLiteral tag = jsStringLiteral;
            JsExpression jsExpression3 = arguments.get(1);
            Intrinsics.checkNotNullExpressionValue(jsExpression3, "get(...)");
            FunctionWithWrapper functionWithWrapper = this.tryExtractFunction(jsExpression3);
            if (functionWithWrapper == null) {
                return null;
            }
            FunctionWithWrapper function2 = functionWithWrapper;
            return new InlineMetadata(tag, function2);
        }

        @JvmStatic
        @Nullable
        public final FunctionWithWrapper tryExtractFunction(@NotNull JsExpression callExpression) {
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            if (callExpression instanceof JsFunction) {
                return new FunctionWithWrapper((JsFunction)callExpression, null);
            }
            if (!(callExpression instanceof JsInvocation)) {
                return null;
            }
            JsExpression jsExpression = ((JsInvocation)callExpression).getQualifier();
            JsNameRef jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
            if (jsNameRef == null) {
                return null;
            }
            JsNameRef qualifier = jsNameRef;
            JsName jsName = qualifier.getName();
            if ((jsName != null ? MetadataProperties.getSpecialFunction(jsName) : null) != SpecialFunction.WRAP_FUNCTION) {
                return null;
            }
            if (((JsInvocation)callExpression).getArguments().size() != 1) {
                return null;
            }
            JsExpression jsExpression2 = ((JsInvocation)callExpression).getArguments().get(0);
            JsFunction jsFunction = jsExpression2 instanceof JsFunction ? (JsFunction)jsExpression2 : null;
            if (jsFunction == null) {
                return null;
            }
            JsFunction argument = jsFunction;
            return this.decomposeWrapper(argument);
        }

        @JvmStatic
        @Nullable
        public final FunctionWithWrapper decomposeWrapper(@NotNull JsFunction wrapperFunction) {
            Intrinsics.checkNotNullParameter(wrapperFunction, "wrapperFunction");
            List<JsStatement> list = wrapperFunction.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
            JsStatement jsStatement = CollectionsKt.lastOrNull(list);
            JsReturn jsReturn = jsStatement instanceof JsReturn ? (JsReturn)jsStatement : null;
            if (jsReturn == null) {
                return null;
            }
            JsReturn returnExpr = jsReturn;
            JsExpression jsExpression = returnExpr.getExpression();
            JsFunction jsFunction = jsExpression instanceof JsFunction ? (JsFunction)jsExpression : null;
            if (jsFunction == null) {
                return null;
            }
            JsFunction function2 = jsFunction;
            return new FunctionWithWrapper(function2, wrapperFunction.getBody());
        }

        @JvmStatic
        @NotNull
        public final JsExpression wrapFunction(@NotNull TranslationContext context2, @NotNull FunctionWithWrapper function2, @Nullable Object sourceInfo) {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(function2, "function");
            JsBlock jsBlock = function2.getWrapperBody();
            if (jsBlock == null) {
                jsBlock = new JsBlock((JsStatement)new JsReturn(function2.getFunction()));
            }
            JsBlock wrapperBody = jsBlock;
            JsFunction wrapper = new JsFunction((JsScope)function2.getFunction().getScope(), wrapperBody, "");
            Object object = function2.getWrapperBody();
            if (object != null && (object = ((JsBlock)object).getStatements()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsStatement it = (JsStatement)element$iv;
                    boolean bl = false;
                    if (it instanceof JsExpressionStatement) {
                        ((JsExpressionStatement)it).getExpression().setSource(sourceInfo);
                        continue;
                    }
                    it.setSource(sourceInfo);
                }
            }
            JsExpression[] jsExpressionArray = new JsExpression[]{wrapper};
            JsNode jsNode = new JsInvocation((JsExpression)context2.getNameForSpecialFunction(SpecialFunction.WRAP_FUNCTION).makeRef(), jsExpressionArray).source(sourceInfo);
            Intrinsics.checkNotNullExpressionValue(jsNode, "source(...)");
            return jsNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

