/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.dependencies.maven.impl;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.maven.impl.MavenSettingsKt$$Lambda$0;
import kotlin.script.experimental.dependencies.maven.impl.MavenSettingsKt$$Lambda$1;
import kotlin.script.experimental.dependencies.maven.impl.MavenSettingsKt$$Lambda$2;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.org.apache.commons.io.filefilter.NameFileFilter;
import org.jetbrains.kotlin.org.apache.maven.settings.Settings;
import org.jetbrains.kotlin.org.apache.maven.settings.SettingsUtils;
import org.jetbrains.kotlin.org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.jetbrains.kotlin.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.jetbrains.kotlin.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.settings.building.SettingsBuilder;
import org.jetbrains.kotlin.org.apache.maven.settings.building.SettingsBuildingException;
import org.jetbrains.kotlin.org.apache.maven.settings.building.SettingsBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.settings.building.SettingsBuildingResult;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0018\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a&\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"createMavenSettings", "Lorg/jetbrains/kotlin/org/apache/maven/settings/Settings;", "invokers", "builder", "Lorg/jetbrains/kotlin/org/apache/maven/settings/building/SettingsBuilder;", "result", "Lorg/jetbrains/kotlin/org/apache/maven/settings/building/SettingsBuildingResult;", "getFilePath", "", "filePattern", "systemPropertyPattern", "Lkotlin/text/Regex;", "substitutePropertiesValues", "pattern", "propValueMapper", "Lkotlin/Function1;", "kotlin-scripting-dependencies-maven"})
public final class MavenSettingsKt {
    @NotNull
    private static final Regex systemPropertyPattern = new Regex("\\$\\{([^{}$]+)}");

    @NotNull
    public static final Settings createMavenSettings() {
        SettingsBuildingResult settingsBuildingResult;
        DefaultSettingsBuilder defaultSettingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
        Intrinsics.checkNotNullExpressionValue((Object)defaultSettingsBuilder, (String)"newInstance(...)");
        SettingsBuilder builder = defaultSettingsBuilder;
        SettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String user = System.getProperty("org.jetbrains.kotlin.org.apache.maven.user-settings");
        if (user == null) {
            request.setUserSettingsFile(new File(new File(System.getProperty("user.home")).getAbsoluteFile(), ".m2/settings.xml"));
        } else {
            request.setUserSettingsFile(new File(user));
        }
        String global = System.getProperty("org.jetbrains.kotlin.org.apache.maven.global-settings");
        if (global != null) {
            request.setGlobalSettingsFile(new File(global));
        }
        try {
            settingsBuildingResult = builder.build(request);
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException(ex);
        }
        SettingsBuildingResult result = settingsBuildingResult;
        return MavenSettingsKt.invokers(builder, result);
    }

    private static final Settings invokers(SettingsBuilder builder, SettingsBuildingResult result) {
        String string;
        File settingsFile;
        Settings main = result.getEffectiveSettings();
        File file = new File(System.getProperty("user.dir")).getParentFile();
        File[] files = file != null ? file.listFiles(new NameFileFilter("interpolated-settings.xml")) : null;
        File file2 = settingsFile = files != null ? (File)ArraysKt.singleOrNull(files) : null;
        if (settingsFile != null) {
            Settings settings;
            DefaultSettingsBuildingRequest irequest = new DefaultSettingsBuildingRequest();
            irequest.setUserSettingsFile(settingsFile);
            try {
                Settings isettings = builder.build(irequest).getEffectiveSettings();
                SettingsUtils.merge(isettings, main, "user-level");
                settings = isettings;
            }
            catch (SettingsBuildingException ex) {
                throw new IllegalStateException(ex);
            }
            main = settings;
        }
        if ((string = main.getLocalRepository()) == null) {
            string = "${user.home}/.m2/repository";
        }
        main.setLocalRepository(MavenSettingsKt.getFilePath(string));
        Settings settings = main;
        Intrinsics.checkNotNull((Object)settings);
        return settings;
    }

    private static final String getFilePath(String filePattern) {
        return StringsKt.replace$default((String)MavenSettingsKt.substitutePropertiesValues(filePattern, MavenSettingsKt$$Lambda$0.INSTANCE), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    private static final String substitutePropertiesValues(String pattern, Function1<? super String, String> propValueMapper) {
        Function1<? super String, String> function1 = propValueMapper;
        return systemPropertyPattern.replace((CharSequence)pattern, (Function1)new MavenSettingsKt$$Lambda$1(function1));
    }

    static /* synthetic */ String substitutePropertiesValues$default(String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = MavenSettingsKt$$Lambda$2.INSTANCE;
        }
        return MavenSettingsKt.substitutePropertiesValues(string, (Function1<? super String, String>)function1);
    }

    private static final String getFilePath$lambda$0(String propertyValue) {
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)propertyValue, (char)'\\', (char)'/', (boolean)false, (int)4, null), (String)"$", (String)"\\$", (boolean)false, (int)4, null);
    }

    private static final String substitutePropertiesValues$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final CharSequence substitutePropertiesValues$lambda$2(Function1 $propValueMapper, MatchResult match) {
        String propName;
        String propValue;
        String string;
        Intrinsics.checkNotNullParameter((Object)$propValueMapper, (String)"$propValueMapper");
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        MatchGroup matchGroup = match.getGroups().get(1);
        String string2 = matchGroup != null ? matchGroup.getValue() : null;
        if (string2 == null) {
            string2 = "";
        }
        if ((string = (propValue = System.getProperty(propName = ((Object)StringsKt.trim((CharSequence)string2)).toString()))) == null) {
            string = "";
        }
        return (CharSequence)$propValueMapper.invoke((Object)string);
    }

    static /* synthetic */ String accessor$MavenSettingsKt$lambda0(String string) {
        return MavenSettingsKt.getFilePath$lambda$0(string);
    }

    static /* synthetic */ CharSequence accessor$MavenSettingsKt$lambda1(Function1 function1, MatchResult matchResult) {
        return MavenSettingsKt.substitutePropertiesValues$lambda$2(function1, matchResult);
    }

    static /* synthetic */ String accessor$MavenSettingsKt$lambda2(String string) {
        return MavenSettingsKt.substitutePropertiesValues$lambda$1(string);
    }
}

