/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.util.lang.UrlUtilRt;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class URLUtil {
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern URL_WITH_PARENS_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;()]*[-A-Za-z0-9+$&@#/%=~_|()]");
    public static final Pattern FILE_URL_PATTERN = Pattern.compile("\\b(file:///)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block7: {
            int pivot;
            if (url == null) {
                URLUtil.$$$reportNull$$$0(12);
            }
            if ((pivot = url.indexOf("!/")) < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (jarPath.startsWith("jar:")) {
                jarPath = jarPath.substring("jar".length() + 1);
            }
            if (jarPath.startsWith("file")) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring("file".length());
                    if (jarPath.startsWith("://")) {
                        jarPath = jarPath.substring("://".length());
                    }
                    if (jarPath.length() == 0 || jarPath.charAt(0) != ':') break block7;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(13);
        }
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url + "'", e);
        }
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            URLUtil.$$$reportNull$$$0(14);
        }
        String string2 = URLUtil.unescapePercentSequences(s, 0, s.length()).toString();
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from2, int end) {
        if (s == null) {
            URLUtil.$$$reportNull$$$0(16);
        }
        CharSequence charSequence = UrlUtilRt.unescapePercentSequences(s, from2, end);
        if (charSequence == null) {
            URLUtil.$$$reportNull$$$0(17);
        }
        return charSequence;
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        int index;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(33);
        }
        String string2 = (index = url.indexOf("://")) >= 0 ? url.substring(index + "://".length()) : url;
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(34);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 18: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/URLUtil";
                break;
            }
            case 14: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUrl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshUrl";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/URLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "openStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openResourceStream";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resourceExists";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePercentSequences";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHostFromSshUrl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeURIComponent";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canContainUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openStream";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openResourceStream";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resourceExists";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unescapePercentSequences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDataUri";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getBytesFromDataUri";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseHostFromSshUrl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getJarEntryURL";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "encodeURIComponent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findUrl";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

