/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchy;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.OrdinalNode;
import org.gradle.execution.plan.OrdinalNodeAccess;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskInAnotherBuild;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.execution.plan.WorkSource;
import org.gradle.internal.Pair;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultExecutionPlan
implements ExecutionPlan,
WorkSource<Node> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionPlan.class);
    private final Set<Node> entryNodes = new LinkedHashSet<Node>();
    private final NodeMapping nodeMapping = new NodeMapping();
    private final ExecutionQueue executionQueue = new ExecutionQueue();
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private final String displayName;
    private final TaskNodeFactory taskNodeFactory;
    private final TaskDependencyResolver dependencyResolver;
    private final ExecutionNodeAccessHierarchy outputHierarchy;
    private final ExecutionNodeAccessHierarchy destroyableHierarchy;
    private final ResourceLockCoordinationService lockCoordinator;
    private final Action<ResourceLock> resourceUnlockListener = this::resourceUnlocked;
    private Spec<? super Task> filter = Specs.satisfyAll();
    private int order = 0;
    private boolean invalidNodeRunning;
    private boolean continueOnFailure;
    private final Set<Node> runningNodes = Sets.newIdentityHashSet();
    private final Set<Node> filteredNodes = Sets.newIdentityHashSet();
    private final Set<Node> producedButNotYetConsumed = Sets.newIdentityHashSet();
    private final Map<Pair<Node, Node>, Boolean> reachableCache = new HashMap<Pair<Node, Node>, Boolean>();
    private final Set<Node> finalizers = new LinkedHashSet<Node>();
    private final OrdinalNodeAccess ordinalNodeAccess = new OrdinalNodeAccess();
    private Consumer<LocalTaskNode> completionHandler = localTaskNode -> {};
    private boolean maybeNodesReady;
    private boolean maybeNodesSelectable;
    private boolean buildCancelled;

    public DefaultExecutionPlan(String displayName, TaskNodeFactory taskNodeFactory, TaskDependencyResolver dependencyResolver, ExecutionNodeAccessHierarchy outputHierarchy, ExecutionNodeAccessHierarchy destroyableHierarchy, ResourceLockCoordinationService lockCoordinator) {
        this.displayName = displayName;
        this.taskNodeFactory = taskNodeFactory;
        this.dependencyResolver = dependencyResolver;
        this.outputHierarchy = outputHierarchy;
        this.destroyableHierarchy = destroyableHierarchy;
        this.lockCoordinator = lockCoordinator;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public TaskNode getNode(Task task) {
        return this.nodeMapping.get(task);
    }

    @Override
    public void addNodes(Collection<? extends Node> nodes) {
        ArrayDeque<Node> queue = new ArrayDeque<Node>(nodes.size());
        for (Node node : nodes) {
            assert (node.isInKnownState());
            if (!node.isRequired()) continue;
            this.entryNodes.add(node);
            queue.add(node);
        }
        this.doAddNodes(queue);
    }

    @Override
    public void addEntryTasks(Collection<? extends Task> tasks) {
        this.addEntryTasks(tasks, this.order++);
    }

    @Override
    public void addEntryTasks(Collection<? extends Task> tasks, int ordinal) {
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        OrdinalGroup group = this.ordinalNodeAccess.group(ordinal);
        for (Task task : this.sorted(tasks)) {
            TaskNode node = this.taskNodeFactory.getOrCreateNode(task);
            node.maybeInheritOrdinalAsDependency(group);
            group.addEntryNode(node);
            this.entryNodes.add(node);
            queue.add(node);
        }
        this.doAddNodes(queue);
    }

    private List<Task> sorted(Collection<? extends Task> tasks) {
        ArrayList<Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        return sortedTasks;
    }

    private void doAddNodes(Deque<Node> queue) {
        HashSet<Node> visiting = new HashSet<Node>();
        while (!queue.isEmpty()) {
            boolean filtered;
            Node node = queue.getFirst();
            if (node.getDependenciesProcessed() || node.isCannotRunInAnyPlan()) {
                queue.removeFirst();
                continue;
            }
            boolean bl = filtered = !this.nodeSatisfiesTaskFilter(node);
            if (filtered) {
                queue.removeFirst();
                node.dependenciesProcessed();
                node.filtered();
                this.filteredNodes.add(node);
                continue;
            }
            node.require();
            if (visiting.add(node)) {
                node.prepareForExecution((Action<Node>)((Action)this::monitoredNodeReady));
                node.resolveDependencies(this.dependencyResolver);
                for (Node successor : node.getHardSuccessors()) {
                    successor.maybeInheritOrdinalAsDependency(node.getGroup());
                }
                for (Node successor : node.getDependencySuccessorsInReverseOrder()) {
                    if (visiting.contains(successor)) continue;
                    queue.addFirst(successor);
                }
                continue;
            }
            queue.removeFirst();
            visiting.remove(node);
            node.dependenciesProcessed();
            for (Node finalizer : node.getFinalizers()) {
                this.finalizers.add(finalizer);
                if (visiting.contains(finalizer)) continue;
                queue.addFirst(finalizer);
            }
        }
    }

    private boolean nodeSatisfiesTaskFilter(Node successor) {
        if (successor instanceof LocalTaskNode) {
            return this.filter.isSatisfiedBy((Object)((LocalTaskNode)successor).getTask());
        }
        return true;
    }

    @Override
    public void determineExecutionPlan() {
        this.updateFinalizerGroups();
        LinkedList nodeQueue = Lists.newLinkedList();
        int visitingSegmentCounter = 0;
        for (Node node : this.entryNodes) {
            nodeQueue.add(new NodeInVisitingSegment(node, visitingSegmentCounter++));
        }
        HashMultimap visitingNodes = HashMultimap.create();
        ArrayDeque<GraphEdge> walkedShouldRunAfterEdges = new ArrayDeque<GraphEdge>();
        ArrayDeque<Node> path = new ArrayDeque<Node>();
        HashMap<Node, Integer> planBeforeVisiting = new HashMap<Node, Integer>();
        while (!nodeQueue.isEmpty()) {
            NodeInVisitingSegment nodeInVisitingSegment = (NodeInVisitingSegment)nodeQueue.peekFirst();
            int currentSegment = nodeInVisitingSegment.visitingSegment;
            Node node = nodeInVisitingSegment.node;
            if (node.isDoNotIncludeInPlan() || this.nodeMapping.contains(node)) {
                nodeQueue.removeFirst();
                visitingNodes.remove((Object)node, (Object)currentSegment);
                this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, node);
                continue;
            }
            boolean alreadyVisited = visitingNodes.containsKey((Object)node);
            visitingNodes.put((Object)node, (Object)currentSegment);
            if (!alreadyVisited) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, node);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle((HashMultimap<Node, Integer>)visitingNodes, nodeInVisitingSegment);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, node);
                for (Node finalizer : node.getFinalizers()) {
                    this.addFinalizerToQueue(nodeQueue, visitingSegmentCounter++, finalizer);
                }
                for (Node successor : node.getAllSuccessorsInReverseOrder()) {
                    if (visitingNodes.containsEntry((Object)successor, (Object)currentSegment)) {
                        if (!walkedShouldRunAfterEdges.isEmpty()) {
                            GraphEdge toBeRemoved = (GraphEdge)walkedShouldRunAfterEdges.pop();
                            TaskNode sourceTask = (TaskNode)toBeRemoved.from;
                            TaskNode targetTask = (TaskNode)toBeRemoved.to;
                            sourceTask.removeShouldSuccessor(targetTask);
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, (HashMultimap<Node, Integer>)visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle(successor, node);
                    }
                    nodeQueue.addFirst(new NodeInVisitingSegment(successor, currentSegment));
                }
                path.push(node);
                continue;
            }
            nodeQueue.removeFirst();
            this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, node);
            visitingNodes.remove((Object)node, (Object)currentSegment);
            path.pop();
            this.nodeMapping.add(node);
            for (Node dependency : node.getDependencySuccessors()) {
                dependency.getMutationInfo().consumingNodes.add(node);
            }
        }
        for (Node node : this.nodeMapping) {
            node.maybeUpdateOrdinalGroup();
            this.createOrdinalRelationships(node);
        }
        this.ordinalNodeAccess.createInterNodeRelationships();
        this.nodeMapping.addAll(this.ordinalNodeAccess.getAllNodes());
        this.dependencyResolver.clear();
        this.executionQueue.setNodes(this.nodeMapping);
    }

    @Override
    public void finalizePlan() {
        this.executionQueue.restart();
        while (this.executionQueue.hasNext()) {
            Node node = this.executionQueue.next();
            node.updateAllDependenciesComplete();
            this.maybeNodeReady(node);
        }
        this.lockCoordinator.addLockReleaseListener(this.resourceUnlockListener);
    }

    @Override
    public WorkSource<Node> asWorkSource() {
        return this;
    }

    private void addFinalizerToQueue(LinkedList<NodeInVisitingSegment> nodeQueue, int visitingSegmentCounter, Node finalizer) {
        int insertPosition = 1;
        int pos = 0;
        for (NodeInVisitingSegment segment : nodeQueue) {
            if (segment.node == finalizer) {
                return;
            }
            if (finalizer.getFinalizingSuccessors().contains(segment.node) && pos > insertPosition) {
                insertPosition = pos;
            }
            ++pos;
        }
        nodeQueue.add(insertPosition, new NodeInVisitingSegment(finalizer, visitingSegmentCounter));
    }

    @Override
    public void close() {
        this.lockCoordinator.removeLockReleaseListener(this.resourceUnlockListener);
        this.completionHandler = localTaskNode -> {};
        for (Node node : this.nodeMapping) {
            node.reset();
        }
        this.entryNodes.clear();
        this.nodeMapping.clear();
        this.executionQueue.clear();
        this.runningNodes.clear();
        for (Node node : this.filteredNodes) {
            node.reset();
        }
        this.filteredNodes.clear();
        this.producedButNotYetConsumed.clear();
        this.reachableCache.clear();
        this.ordinalNodeAccess.reset();
    }

    private void resourceUnlocked(ResourceLock resourceLock) {
        if (!(resourceLock instanceof WorkerLeaseRegistry.WorkerLease) && this.maybeNodesReady) {
            this.maybeNodesSelectable = true;
        }
    }

    private void createOrdinalRelationships(Node node) {
        if (node instanceof TaskNode && node.getOrdinal() != null) {
            TaskNode taskNode = (TaskNode)node;
            TaskClassifier taskClassifier = new TaskClassifier();
            ProjectInternal project = (ProjectInternal)taskNode.getTask().getProject();
            ServiceRegistry serviceRegistry = project.getServices();
            PropertyWalker propertyWalker = (PropertyWalker)serviceRegistry.get(PropertyWalker.class);
            propertyWalker.visitProperties(taskNode.getTask(), TypeValidationContext.NOOP, taskClassifier);
            taskNode.getTask().getOutputs().visitRegisteredProperties(taskClassifier);
            ((TaskDestroyablesInternal)taskNode.getTask().getDestroyables()).visitRegisteredProperties(taskClassifier);
            ((TaskLocalStateInternal)taskNode.getTask().getLocalState()).visitRegisteredProperties(taskClassifier);
            if (taskClassifier.isDestroyer()) {
                OrdinalNode ordinalNode = this.ordinalNodeAccess.getOrCreateDestroyableLocationNode(taskNode.getOrdinal());
                ordinalNode.addDependenciesFrom(taskNode);
                Node precedingProducersNode = this.ordinalNodeAccess.getPrecedingProducerLocationNode(taskNode.getOrdinal());
                if (precedingProducersNode != null) {
                    taskNode.addDependencySuccessor(precedingProducersNode);
                }
            } else if (taskClassifier.isProducer()) {
                OrdinalNode ordinalNode = this.ordinalNodeAccess.getOrCreateOutputLocationNode(taskNode.getOrdinal());
                ordinalNode.addDependenciesFrom(taskNode);
                Node precedingDestroyersNode = this.ordinalNodeAccess.getPrecedingDestroyerLocationNode(taskNode.getOrdinal());
                if (precedingDestroyersNode != null) {
                    taskNode.addDependencySuccessor(precedingDestroyersNode);
                }
            }
        }
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Deque<GraphEdge> walkedShouldRunAfterEdges, Node node) {
        GraphEdge edge = walkedShouldRunAfterEdges.peek();
        if (edge != null && edge.to.equals(node)) {
            walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(Map<Node, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        int count = planBeforeVisiting.get(toBeRemoved.from);
        this.nodeMapping.retainFirst(count);
    }

    private void restoreQueue(Deque<NodeInVisitingSegment> nodeQueue, HashMultimap<Node, Integer> visitingNodes, GraphEdge toBeRemoved) {
        NodeInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.node)) {
            nextInQueue = nodeQueue.peekFirst();
            visitingNodes.remove((Object)nextInQueue.node, (Object)nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.node)) continue;
            nodeQueue.removeFirst();
        }
    }

    private void restorePath(Deque<Node> path, GraphEdge toBeRemoved) {
        Node removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(HashMultimap<Node, Integer> visitingNodes, NodeInVisitingSegment nodeWithVisitingSegment) {
        Node node = nodeWithVisitingSegment.node;
        if (!(node instanceof TaskNode)) {
            return;
        }
        Iterables.removeIf(((TaskNode)node).getShouldSuccessors(), input -> visitingNodes.containsEntry(input, (Object)nodeWithVisitingSegment.visitingSegment));
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(Map<Node, Integer> planBeforeVisiting, Node node) {
        if (node instanceof TaskNode && !((TaskNode)node).getShouldSuccessors().isEmpty()) {
            planBeforeVisiting.put(node, this.nodeMapping.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Deque<GraphEdge> walkedShouldRunAfterEdges, Deque<Node> path, Node node) {
        if (!(node instanceof TaskNode)) {
            return;
        }
        Node previous = path.peek();
        if (previous instanceof TaskNode && ((TaskNode)previous).getShouldSuccessors().contains(node)) {
            walkedShouldRunAfterEdges.push(new GraphEdge(previous, node));
        }
    }

    private void onOrderingCycle(Node successor, Node currentNode) {
        CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((node, values, connectedNodes) -> node.getHardSuccessors().forEach(connectedNodes::add));
        graphWalker.add((Object[])new Node[]{successor});
        List cycles = graphWalker.findCycles();
        if (cycles.isEmpty()) {
            throw new GradleException("Misdetected cycle between " + currentNode + " and " + successor + ". Help us by reporting this to https://github.com/gradle/gradle/issues/2293");
        }
        ArrayList firstCycle = new ArrayList((Collection)cycles.get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<Node> graphRenderer = new DirectedGraphRenderer<Node>((it, output) -> output.withStyle(StyledTextOutput.Style.Identifier).text(it), (it, values, connectedNodes) -> {
            HashSet successors = Sets.newHashSet(it.getHardSuccessors());
            for (Node dependency : firstCycle) {
                if (!(dependency instanceof TaskNode) || !successors.contains(dependency)) continue;
                connectedNodes.add(dependency);
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((Node)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer));
    }

    @Override
    public void onComplete(Consumer<LocalTaskNode> handler) {
        Consumer<LocalTaskNode> previous = this.completionHandler;
        this.completionHandler = node -> {
            previous.accept((LocalTaskNode)node);
            handler.accept((LocalTaskNode)node);
        };
    }

    @Override
    public Set<Task> getTasks() {
        return this.nodeMapping.getTasks();
    }

    @Override
    public Set<Task> getRequestedTasks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node entryNode : this.entryNodes) {
            if (!(entryNode instanceof LocalTaskNode)) continue;
            builder.add((Object)((LocalTaskNode)entryNode).getTask());
        }
        return builder.build();
    }

    @Override
    public ExecutionPlan.ScheduledNodes getScheduledNodes() {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.nodeMapping.nodes.size());
        for (Node node : this.nodeMapping.nodes) {
            if (node instanceof TaskInAnotherBuild && ((TaskInAnotherBuild)node).getTask().getState().getExecuted()) continue;
            builder.add((Object)node);
        }
        return visitor -> this.lockCoordinator.withStateLock(() -> visitor.accept(builder.build()));
    }

    @Override
    public Set<Task> getFilteredTasks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node filteredNode : this.filteredNodes) {
            if (!(filteredNode instanceof LocalTaskNode)) continue;
            builder.add((Object)((LocalTaskNode)filteredNode).getTask());
        }
        return builder.build();
    }

    @Override
    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    @Override
    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    @Override
    public WorkSource.State executionState() {
        this.lockCoordinator.assertHasStateLock();
        if (this.executionQueue.isEmpty()) {
            return WorkSource.State.NoMoreWorkToStart;
        }
        if (this.maybeNodesSelectable) {
            return WorkSource.State.MaybeWorkReadyToStart;
        }
        return WorkSource.State.NoWorkReadyToStart;
    }

    @Override
    public boolean canMakeProgress() {
        return this.executionState() != WorkSource.State.NoWorkReadyToStart || !this.runningNodes.isEmpty();
    }

    @Override
    public WorkSource.Diagnostics healthDiagnostics() {
        Node node;
        this.lockCoordinator.assertHasStateLock();
        ArrayList<String> ordinalGroups = new ArrayList<String>();
        for (OrdinalGroup group : this.ordinalNodeAccess.getAllGroups()) {
            ordinalGroups.add(group.diagnostics());
        }
        ArrayList<String> queuedNodes = new ArrayList<String>(this.executionQueue.size());
        ArrayList<String> otherNodes = new ArrayList<String>();
        ArrayList<Node> queue = new ArrayList<Node>();
        HashSet<Node> reported = new HashSet<Node>();
        this.executionQueue.restart();
        while (this.executionQueue.hasNext()) {
            node = this.executionQueue.next();
            queuedNodes.add(node.healthDiagnostics());
            reported.add(node);
            for (Node successor : node.getHardSuccessors()) {
                queue.add(successor);
            }
        }
        while (!queue.isEmpty()) {
            node = (Node)queue.remove(0);
            if (!reported.add(node)) continue;
            otherNodes.add(node.healthDiagnostics());
            for (Node successor : node.getHardSuccessors()) {
                queue.add(successor);
            }
        }
        return new WorkSource.Diagnostics(this.displayName, ordinalGroups, queuedNodes, otherNodes);
    }

    @Override
    public WorkSource.Selection<Node> selectNext() {
        this.lockCoordinator.assertHasStateLock();
        if (this.executionQueue.isEmpty()) {
            return WorkSource.Selection.noMoreWorkToStart();
        }
        if (!this.maybeNodesSelectable) {
            return WorkSource.Selection.noWorkReadyToStart();
        }
        ArrayList<ResourceLock> resources = new ArrayList<ResourceLock>();
        boolean foundReadyNode = false;
        this.executionQueue.restart();
        while (this.executionQueue.hasNext()) {
            Node node = this.executionQueue.next();
            if (!node.allDependenciesComplete()) continue;
            if (!node.allDependenciesSuccessful()) {
                if (node.shouldCancelExecutionDueToDependencies()) {
                    node.cancelExecution(this::recordNodeCompleted);
                    if (node.getPrepareNode() != null && node.getPrepareNode().isRequired()) {
                        node.getPrepareNode().cancelExecution(this::recordNodeCompleted);
                    }
                } else {
                    node.markFailedDueToDependencies(this::recordNodeCompleted);
                    if (node.getPrepareNode() != null && node.getPrepareNode().isRequired()) {
                        node.getPrepareNode().markFailedDueToDependencies(this::recordNodeCompleted);
                    }
                }
                this.executionQueue.remove();
                this.executionQueue.restart();
                continue;
            }
            foundReadyNode = true;
            Node prepareNode = node.getPrepareNode();
            if (prepareNode != null) {
                if (!prepareNode.isRequired()) {
                    prepareNode.require();
                    prepareNode.updateAllDependenciesComplete();
                }
                if (prepareNode.allDependenciesComplete()) {
                    if (!this.attemptToStart(prepareNode, resources)) continue;
                    node.addDependencySuccessor(prepareNode);
                    node.forceAllDependenciesCompleteUpdate();
                    return WorkSource.Selection.of(prepareNode);
                }
            }
            if (!this.attemptToStart(node, resources)) continue;
            this.executionQueue.remove();
            return WorkSource.Selection.of(node);
        }
        LOGGER.debug("No node could be selected, nodes ready: {}", (Object)foundReadyNode);
        this.maybeNodesReady = foundReadyNode;
        this.maybeNodesSelectable = false;
        if (this.executionQueue.isEmpty()) {
            return WorkSource.Selection.noMoreWorkToStart();
        }
        return WorkSource.Selection.noWorkReadyToStart();
    }

    private boolean attemptToStart(Node node, List<ResourceLock> resources) {
        resources.clear();
        if (!this.tryAcquireLocksForNode(node, resources)) {
            this.releaseLocks(resources);
            return false;
        }
        MutationInfo mutations = this.getResolvedMutationInfo(node);
        if (this.conflictsWithOtherNodes(node, mutations)) {
            this.releaseLocks(resources);
            return false;
        }
        node.startExecution(this::recordNodeExecutionStarted);
        if (mutations.hasValidationProblem) {
            this.invalidNodeRunning = true;
        }
        return true;
    }

    private void releaseLocks(List<ResourceLock> resources) {
        for (ResourceLock resource : resources) {
            resource.unlock();
        }
    }

    private boolean tryAcquireLocksForNode(Node node, List<ResourceLock> resources) {
        if (!this.tryLockProjectFor(node, resources)) {
            LOGGER.debug("Cannot acquire project lock for node {}", (Object)node);
            return false;
        }
        if (!this.tryLockSharedResourceFor(node, resources)) {
            LOGGER.debug("Cannot acquire shared resource lock for node {}", (Object)node);
            return false;
        }
        return true;
    }

    private boolean conflictsWithOtherNodes(Node node, MutationInfo mutations) {
        if (!this.canRunWithCurrentlyExecutedNodes(mutations)) {
            LOGGER.debug("Node {} cannot run with currently running nodes {}", (Object)node, this.runningNodes);
            return true;
        }
        if (this.destroysNotYetConsumedOutputOfAnotherNode(node, mutations.destroyablePaths)) {
            LOGGER.debug("Node {} destroys not yet consumed output of another node", (Object)node);
            return true;
        }
        return false;
    }

    private void updateAllDependenciesCompleteForPredecessors(Node node) {
        node.visitAllNodesWaitingForThisNode(dependent -> {
            if (dependent.updateAllDependenciesComplete()) {
                this.maybeNodeReady((Node)dependent);
            }
        });
    }

    private boolean tryLockProjectFor(Node node, List<ResourceLock> resources) {
        ResourceLock toLock = node.getProjectToLock();
        if (toLock == null) {
            return true;
        }
        if (toLock.tryLock()) {
            resources.add(toLock);
            return true;
        }
        return false;
    }

    private void unlockProjectFor(Node node) {
        ResourceLock toUnlock = node.getProjectToLock();
        if (toUnlock != null) {
            toUnlock.unlock();
        }
    }

    private boolean tryLockSharedResourceFor(Node node, List<ResourceLock> resources) {
        for (ResourceLock resourceLock : node.getResourcesToLock()) {
            if (!resourceLock.tryLock()) {
                return false;
            }
            resources.add(resourceLock);
        }
        return true;
    }

    private void unlockSharedResourcesFor(Node node) {
        node.getResourcesToLock().forEach(ResourceLock::unlock);
    }

    private MutationInfo getResolvedMutationInfo(Node node) {
        MutationInfo mutations = node.getMutationInfo();
        if (!mutations.resolved) {
            this.outputHierarchy.recordNodeAccessingLocations(node, mutations.outputPaths);
            this.destroyableHierarchy.recordNodeAccessingLocations(node, mutations.destroyablePaths);
            mutations.resolved = true;
        }
        return mutations;
    }

    private boolean canRunWithCurrentlyExecutedNodes(MutationInfo mutations) {
        if (mutations.hasValidationProblem ? !this.runningNodes.isEmpty() : this.invalidNodeRunning) {
            return false;
        }
        return !this.hasRunningNodeWithOverlappingMutations(mutations);
    }

    private boolean hasRunningNodeWithOverlappingMutations(MutationInfo mutations) {
        Set<String> candidateMutationPaths;
        if (this.runningNodes.isEmpty()) {
            return false;
        }
        Set<String> candidateNodeOutputs = mutations.outputPaths;
        Set<String> set = candidateMutationPaths = !candidateNodeOutputs.isEmpty() ? candidateNodeOutputs : mutations.destroyablePaths;
        if (!candidateMutationPaths.isEmpty()) {
            for (String candidateMutationPath : candidateMutationPaths) {
                Stream<Node> nodesMutatingCandidatePath = Stream.concat(this.outputHierarchy.getNodesAccessing(candidateMutationPath).stream(), this.destroyableHierarchy.getNodesAccessing(candidateMutationPath).stream());
                if (!nodesMutatingCandidatePath.anyMatch(this.runningNodes::contains)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean destroysNotYetConsumedOutputOfAnotherNode(Node destroyer, Set<String> destroyablePaths) {
        if (destroyablePaths.isEmpty()) {
            return false;
        }
        for (String destroyablePath : destroyablePaths) {
            ImmutableSet<Node> producersDestroyedByDestroyer = this.outputHierarchy.getNodesAccessing(destroyablePath);
            for (Node producingNode : this.producedButNotYetConsumed) {
                if (!producersDestroyedByDestroyer.contains((Object)producingNode)) continue;
                MutationInfo producingNodeMutations = producingNode.getMutationInfo();
                assert (!producingNodeMutations.consumingNodes.isEmpty());
                for (Node consumer : producingNodeMutations.consumingNodes) {
                    if (this.doesConsumerDependOnDestroyer(consumer, destroyer)) continue;
                    LOGGER.debug("Node {} destroys output of consumer {}", (Object)destroyer, (Object)consumer);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean doesConsumerDependOnDestroyer(Node consumer, Node destroyer) {
        if (consumer == destroyer) {
            return true;
        }
        Pair nodePair = Pair.of((Object)consumer, (Object)destroyer);
        if (this.reachableCache.get(nodePair) != null) {
            return this.reachableCache.get(nodePair);
        }
        boolean reachable = false;
        for (Node dependency : consumer.getAllSuccessors()) {
            if (dependency.isComplete() || !this.doesConsumerDependOnDestroyer(dependency, destroyer)) continue;
            reachable = true;
        }
        this.reachableCache.put((Pair<Node, Node>)nodePair, reachable);
        return reachable;
    }

    private void recordNodeExecutionStarted(Node node) {
        this.runningNodes.add(node);
    }

    private void recordNodeCompleted(Node node) {
        LOGGER.debug("Node {} completed, executed: {}", (Object)node, (Object)node.isExecuted());
        MutationInfo mutations = node.getMutationInfo();
        for (Node producer : node.getDependencySuccessors()) {
            MutationInfo producerMutations = producer.getMutationInfo();
            if (!producerMutations.consumingNodes.remove(node) || !producerMutations.consumingNodes.isEmpty()) continue;
            this.producedButNotYetConsumed.remove(producer);
        }
        if (!mutations.consumingNodes.isEmpty() && !mutations.outputPaths.isEmpty()) {
            this.producedButNotYetConsumed.add(node);
        }
        this.updateAllDependenciesCompleteForPredecessors(node);
        if (node instanceof LocalTaskNode) {
            try {
                this.completionHandler.accept((LocalTaskNode)node);
            }
            catch (Throwable t) {
                this.failures.add(t);
            }
        }
    }

    private void monitoredNodeReady(Node node) {
        this.lockCoordinator.assertHasStateLock();
        if (node.updateAllDependenciesComplete()) {
            this.maybeNodeReady(node);
        }
    }

    @Override
    public void finishedExecuting(Node node, @Nullable Throwable failure) {
        this.lockCoordinator.assertHasStateLock();
        if (failure != null) {
            node.setExecutionFailure(failure);
        }
        if (!node.isExecuting()) {
            throw new IllegalStateException(String.format("Cannot finish executing %s as it is in an unexpected state.", node));
        }
        try {
            if (this.maybeNodesReady) {
                this.maybeNodesSelectable = true;
            }
            this.runningNodes.remove(node);
            node.finishExecution(this::recordNodeCompleted);
            if (node.isFailed()) {
                LOGGER.debug("Node {} failed", (Object)node);
                this.handleFailure(node);
            } else {
                LOGGER.debug("Node {} finished executing", (Object)node);
            }
        }
        finally {
            this.unlockProjectFor(node);
            this.unlockSharedResourcesFor(node);
            this.invalidNodeRunning = false;
        }
    }

    private void maybeNodeReady(Node node) {
        if (node.allDependenciesComplete()) {
            this.maybeNodesReady = true;
            this.maybeNodesSelectable = true;
            if (node.isPriority()) {
                this.executionQueue.priorityNode(node);
            }
        }
    }

    private void updateFinalizerGroups() {
        LinkedList<Node> nodes = new LinkedList<Node>();
        HashSet<Node> visiting = new HashSet<Node>();
        HashSet<Node> visited = new HashSet<Node>();
        ArrayDeque<Node> queue = new ArrayDeque<Node>(this.finalizers);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.peek();
            if (visited.contains(node)) {
                queue.remove();
                continue;
            }
            if (visiting.add(node)) {
                for (Node successor : node.getDependencySuccessors()) {
                    queue.addFirst(successor);
                }
                continue;
            }
            visiting.remove(node);
            visited.add(node);
            nodes.addFirst(node);
        }
        for (Node node : nodes) {
            node.updateGroupOfFinalizer();
        }
        this.finalizers.clear();
    }

    private void handleFailure(Node node) {
        Throwable executionFailure = node.getExecutionFailure();
        if (executionFailure != null) {
            this.failures.add(executionFailure);
            this.abortExecution();
            return;
        }
        Throwable nodeFailure = node.getNodeFailure();
        if (nodeFailure != null) {
            this.failures.add(node.getNodeFailure());
            if (!this.continueOnFailure) {
                this.abortExecution();
            }
        }
    }

    private boolean abortExecution() {
        return this.abortExecution(false);
    }

    @Override
    public void abortAllAndFail(Throwable t) {
        this.lockCoordinator.assertHasStateLock();
        this.failures.add(t);
        this.abortExecution(true);
    }

    @Override
    public void cancelExecution() {
        this.lockCoordinator.assertHasStateLock();
        this.buildCancelled = this.abortExecution() || this.buildCancelled;
    }

    private boolean abortExecution(boolean abortAll) {
        boolean aborted = false;
        this.executionQueue.restart();
        while (this.executionQueue.hasNext()) {
            Node node = this.executionQueue.next();
            if (!abortAll && !node.isCanCancel()) continue;
            node.cancelExecution(this::recordNodeCompleted);
            this.executionQueue.remove();
            aborted = true;
        }
        if (aborted) {
            this.maybeNodesSelectable = true;
        }
        return aborted;
    }

    @Override
    public void collectFailures(Collection<? super Throwable> failures) {
        failures.addAll(this.failures);
        if (this.buildCancelled && failures.isEmpty()) {
            failures.add((Throwable)new BuildCancelledException());
        }
    }

    @Override
    public boolean allExecutionComplete() {
        return this.executionQueue.isEmpty() && this.runningNodes.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeMapping.getNumberOfPublicNodes();
    }

    private static class ExecutionQueue {
        private final List<Node> nodes = new ArrayList<Node>();
        private int pos = 0;

        private ExecutionQueue() {
        }

        public void setNodes(Collection<Node> nodes) {
            this.nodes.clear();
            this.nodes.addAll(nodes);
            this.pos = 0;
        }

        public void clear() {
            this.nodes.clear();
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public int size() {
            return this.nodes.size();
        }

        public void restart() {
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos < this.nodes.size();
        }

        public Node next() {
            return this.nodes.get(this.pos++);
        }

        public void remove() {
            --this.pos;
            this.nodes.remove(this.pos);
        }

        public void priorityNode(Node node) {
            int previousPos = this.nodes.indexOf(node);
            this.nodes.remove(previousPos);
            this.nodes.add(0, node);
            if (previousPos >= this.pos) {
                ++this.pos;
            }
        }

        public String toString() {
            StringBuilder str = new StringBuilder("ExecutionQueue[");
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                if (i == this.pos) {
                    str.append('*');
                }
                str.append(this.nodes.get(i));
            }
            str.append("]");
            return str.toString();
        }
    }

    private static class TaskClassifier
    extends PropertyVisitor.Adapter {
        private boolean isProducer;
        private boolean isDestroyer;

        private TaskClassifier() {
        }

        @Override
        public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
            this.isProducer = true;
        }

        @Override
        public void visitDestroyableProperty(Object value) {
            this.isDestroyer = true;
        }

        @Override
        public void visitLocalStateProperty(Object value) {
            this.isProducer = true;
        }

        public boolean isProducer() {
            return this.isProducer;
        }

        public boolean isDestroyer() {
            return this.isDestroyer;
        }
    }

    private static class NodeMapping
    extends AbstractCollection<Node> {
        private final Map<Task, LocalTaskNode> taskMapping = Maps.newLinkedHashMap();
        private final Set<Node> nodes = Sets.newLinkedHashSet();

        private NodeMapping() {
        }

        @Override
        public boolean contains(Object o) {
            return this.nodes.contains(o);
        }

        @Override
        public boolean add(Node node) {
            if (!this.nodes.add(node)) {
                return false;
            }
            if (node instanceof LocalTaskNode) {
                LocalTaskNode taskNode = (LocalTaskNode)node;
                this.taskMapping.put(taskNode.getTask(), taskNode);
            }
            return true;
        }

        public TaskNode get(Task task) {
            TaskNode taskNode = this.taskMapping.get(task);
            if (taskNode == null) {
                throw new IllegalStateException("Task is not part of the execution plan, no dependency information is available.");
            }
            return taskNode;
        }

        public Set<Task> getTasks() {
            return this.taskMapping.keySet();
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodes.iterator();
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.taskMapping.clear();
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        public int getNumberOfPublicNodes() {
            int publicNodes = 0;
            for (Node node : this) {
                if (!node.isPublicNode()) continue;
                ++publicNodes;
            }
            return publicNodes;
        }

        public void retainFirst(int count) {
            Iterator<Node> executionPlanIterator = this.nodes.iterator();
            for (int i = 0; i < count; ++i) {
                executionPlanIterator.next();
            }
            while (executionPlanIterator.hasNext()) {
                Node removedNode = executionPlanIterator.next();
                executionPlanIterator.remove();
                if (!(removedNode instanceof LocalTaskNode)) continue;
                this.taskMapping.remove(((LocalTaskNode)removedNode).getTask());
            }
        }
    }

    private static class NodeInVisitingSegment {
        private final Node node;
        private final int visitingSegment;

        private NodeInVisitingSegment(Node node, int visitingSegment) {
            this.node = node;
            this.visitingSegment = visitingSegment;
        }
    }

    private static class GraphEdge {
        private final Node from;
        private final Node to;

        private GraphEdge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }
    }
}

