/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.DelegatingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;

public class CachingExcludeFactory
extends DelegatingExcludeFactory {
    private final MergeCaches caches;

    public CachingExcludeFactory(ExcludeFactory delegate, MergeCaches caches) {
        super(delegate);
        this.caches = caches;
    }

    @Override
    public ExcludeSpec anyOf(ExcludeSpec one, ExcludeSpec two) {
        return this.cachedAnyPair(one, two);
    }

    private ExcludeSpec cachedAnyPair(ExcludeSpec left, ExcludeSpec right) {
        return this.caches.getAnyPair(ExcludePair.of(left, right), key -> this.delegate.anyOf(((ExcludePair)key).left, ((ExcludePair)key).right));
    }

    @Override
    public ExcludeSpec allOf(ExcludeSpec one, ExcludeSpec two) {
        return this.caches.getAllPair(ExcludePair.of(one, two), key -> this.delegate.allOf(((ExcludePair)key).left, ((ExcludePair)key).right));
    }

    @Override
    public ExcludeSpec anyOf(Set<ExcludeSpec> specs) {
        return this.caches.getAnyOf(new ExcludesKey(specs), key -> this.delegate.anyOf(((ExcludesKey)key).specs));
    }

    @Override
    public ExcludeSpec allOf(Set<ExcludeSpec> specs) {
        return this.caches.getAllOf(new ExcludesKey(specs), key -> this.delegate.allOf(((ExcludesKey)key).specs));
    }

    private static class ConcurrentCache<K, V> {
        private final Map<K, V> backingMap = Maps.newHashMap();

        private ConcurrentCache() {
        }

        static <K, V> ConcurrentCache<K, V> of() {
            return new ConcurrentCache<K, V>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V computeIfAbsent(K key, Function<K, V> producer) {
            Map<K, V> map = this.backingMap;
            synchronized (map) {
                V value = this.backingMap.get(key);
                if (value != null) {
                    return value;
                }
                value = producer.apply(key);
                this.backingMap.put(key, value);
                return value;
            }
        }
    }

    public static class MergeCaches {
        private final ConcurrentCache<ExcludePair, ExcludeSpec> allOfPairCache = ConcurrentCache.of();
        private final ConcurrentCache<ExcludePair, ExcludeSpec> anyOfPairCache = ConcurrentCache.of();
        private final ConcurrentCache<ExcludesKey, ExcludeSpec> allOfListCache = ConcurrentCache.of();
        private final ConcurrentCache<ExcludesKey, ExcludeSpec> anyOfListCache = ConcurrentCache.of();

        ExcludeSpec getAnyPair(ExcludePair pair, Function<ExcludePair, ExcludeSpec> onMiss) {
            return this.anyOfPairCache.computeIfAbsent(pair, onMiss);
        }

        ExcludeSpec getAllPair(ExcludePair pair, Function<ExcludePair, ExcludeSpec> onMiss) {
            return this.allOfPairCache.computeIfAbsent(pair, onMiss);
        }

        ExcludeSpec getAnyOf(ExcludesKey list, Function<ExcludesKey, ExcludeSpec> onMiss) {
            return this.anyOfListCache.computeIfAbsent(list, onMiss);
        }

        ExcludeSpec getAllOf(ExcludesKey list, Function<ExcludesKey, ExcludeSpec> onMiss) {
            return this.allOfListCache.computeIfAbsent(list, onMiss);
        }
    }

    private static class ExcludesKey {
        private final Set<ExcludeSpec> specs;
        private final int size;
        private final int hashCode;

        private ExcludesKey(Set<ExcludeSpec> specs) {
            this.specs = specs;
            this.size = specs.size();
            this.hashCode = specs.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExcludesKey that = (ExcludesKey)o;
            if (this.size != that.size) {
                return false;
            }
            return this.specs.equals(that.specs);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class ExcludePair {
        private final ExcludeSpec left;
        private final ExcludeSpec right;
        private final int hashCode;

        private static ExcludePair of(ExcludeSpec left, ExcludeSpec right) {
            if (left.hashCode() > right.hashCode()) {
                return new ExcludePair(right, left);
            }
            return new ExcludePair(left, right);
        }

        private ExcludePair(ExcludeSpec left, ExcludeSpec right) {
            this.left = left;
            this.right = right;
            this.hashCode = 31 * left.hashCode() + right.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExcludePair that = (ExcludePair)o;
            return this.left.equals(that.left) && this.right.equals(that.right);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

