/* ============================================================================ */
/* Copyright (c) 2021, Texas Instruments Incorporated                           */
/*  All rights reserved.                                                        */
/*                                                                              */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  *  Redistributions of source code must retain the above copyright           */
/*     notice, this list of conditions and the following disclaimer.            */
/*                                                                              */
/*  *  Redistributions in binary form must reproduce the above copyright        */
/*     notice, this list of conditions and the following disclaimer in the      */
/*     documentation and/or other materials provided with the distribution.     */
/*                                                                              */
/*  *  Neither the name of Texas Instruments Incorporated nor the names of      */
/*     its contributors may be used to endorse or promote products derived      */
/*     from this software without specific prior written permission.            */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" */
/*  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,       */
/*  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR      */
/*  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR            */
/*  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,       */
/*  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         */
/*  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; */
/*  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,    */
/*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR     */
/*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,              */
/*  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                          */
/* ============================================================================ */

/* This file supports MSP430FR5041 devices. */

/* 1.212 */

/************************************************************
* PERIPHERAL FILE MAP
************************************************************/


/*****************************************************************************
 ADC12_B
*****************************************************************************/
PROVIDE(ADC12CTL0          = 0x0800);
PROVIDE(ADC12CTL0_L        = 0x0800);
PROVIDE(ADC12CTL0_H        = 0x0801);
PROVIDE(ADC12CTL1          = 0x0802);
PROVIDE(ADC12CTL1_L        = 0x0802);
PROVIDE(ADC12CTL1_H        = 0x0803);
PROVIDE(ADC12CTL2          = 0x0804);
PROVIDE(ADC12CTL2_L        = 0x0804);
PROVIDE(ADC12CTL2_H        = 0x0805);
PROVIDE(ADC12CTL3          = 0x0806);
PROVIDE(ADC12CTL3_L        = 0x0806);
PROVIDE(ADC12CTL3_H        = 0x0807);
PROVIDE(ADC12LO            = 0x0808);
PROVIDE(ADC12LO_L          = 0x0808);
PROVIDE(ADC12LO_H          = 0x0809);
PROVIDE(ADC12HI            = 0x080A);
PROVIDE(ADC12HI_L          = 0x080A);
PROVIDE(ADC12HI_H          = 0x080B);
PROVIDE(ADC12IFGR0         = 0x080C);
PROVIDE(ADC12IFGR0_L       = 0x080C);
PROVIDE(ADC12IFGR0_H       = 0x080D);
PROVIDE(ADC12IFGR1         = 0x080E);
PROVIDE(ADC12IFGR1_L       = 0x080E);
PROVIDE(ADC12IFGR1_H       = 0x080F);
PROVIDE(ADC12IFGR2         = 0x0810);
PROVIDE(ADC12IFGR2_L       = 0x0810);
PROVIDE(ADC12IFGR2_H       = 0x0811);
PROVIDE(ADC12IER0          = 0x0812);
PROVIDE(ADC12IER0_L        = 0x0812);
PROVIDE(ADC12IER0_H        = 0x0813);
PROVIDE(ADC12IER1          = 0x0814);
PROVIDE(ADC12IER1_L        = 0x0814);
PROVIDE(ADC12IER1_H        = 0x0815);
PROVIDE(ADC12IER2          = 0x0816);
PROVIDE(ADC12IER2_L        = 0x0816);
PROVIDE(ADC12IER2_H        = 0x0817);
PROVIDE(ADC12IV            = 0x0818);
PROVIDE(ADC12IV_L          = 0x0818);
PROVIDE(ADC12IV_H          = 0x0819);
PROVIDE(ADC12MCTL0         = 0x0820);
PROVIDE(ADC12MCTL0_L       = 0x0820);
PROVIDE(ADC12MCTL0_H       = 0x0821);
PROVIDE(ADC12MCTL1         = 0x0822);
PROVIDE(ADC12MCTL1_L       = 0x0822);
PROVIDE(ADC12MCTL1_H       = 0x0823);
PROVIDE(ADC12MCTL2         = 0x0824);
PROVIDE(ADC12MCTL2_L       = 0x0824);
PROVIDE(ADC12MCTL2_H       = 0x0825);
PROVIDE(ADC12MCTL3         = 0x0826);
PROVIDE(ADC12MCTL3_L       = 0x0826);
PROVIDE(ADC12MCTL3_H       = 0x0827);
PROVIDE(ADC12MCTL4         = 0x0828);
PROVIDE(ADC12MCTL4_L       = 0x0828);
PROVIDE(ADC12MCTL4_H       = 0x0829);
PROVIDE(ADC12MCTL5         = 0x082A);
PROVIDE(ADC12MCTL5_L       = 0x082A);
PROVIDE(ADC12MCTL5_H       = 0x082B);
PROVIDE(ADC12MCTL6         = 0x082C);
PROVIDE(ADC12MCTL6_L       = 0x082C);
PROVIDE(ADC12MCTL6_H       = 0x082D);
PROVIDE(ADC12MCTL7         = 0x082E);
PROVIDE(ADC12MCTL7_L       = 0x082E);
PROVIDE(ADC12MCTL7_H       = 0x082F);
PROVIDE(ADC12MCTL8         = 0x0830);
PROVIDE(ADC12MCTL8_L       = 0x0830);
PROVIDE(ADC12MCTL8_H       = 0x0831);
PROVIDE(ADC12MCTL9         = 0x0832);
PROVIDE(ADC12MCTL9_L       = 0x0832);
PROVIDE(ADC12MCTL9_H       = 0x0833);
PROVIDE(ADC12MCTL10        = 0x0834);
PROVIDE(ADC12MCTL10_L      = 0x0834);
PROVIDE(ADC12MCTL10_H      = 0x0835);
PROVIDE(ADC12MCTL11        = 0x0836);
PROVIDE(ADC12MCTL11_L      = 0x0836);
PROVIDE(ADC12MCTL11_H      = 0x0837);
PROVIDE(ADC12MCTL12        = 0x0838);
PROVIDE(ADC12MCTL12_L      = 0x0838);
PROVIDE(ADC12MCTL12_H      = 0x0839);
PROVIDE(ADC12MCTL13        = 0x083A);
PROVIDE(ADC12MCTL13_L      = 0x083A);
PROVIDE(ADC12MCTL13_H      = 0x083B);
PROVIDE(ADC12MCTL14        = 0x083C);
PROVIDE(ADC12MCTL14_L      = 0x083C);
PROVIDE(ADC12MCTL14_H      = 0x083D);
PROVIDE(ADC12MCTL15        = 0x083E);
PROVIDE(ADC12MCTL15_L      = 0x083E);
PROVIDE(ADC12MCTL15_H      = 0x083F);
PROVIDE(ADC12MCTL16        = 0x0840);
PROVIDE(ADC12MCTL16_L      = 0x0840);
PROVIDE(ADC12MCTL16_H      = 0x0841);
PROVIDE(ADC12MCTL17        = 0x0842);
PROVIDE(ADC12MCTL17_L      = 0x0842);
PROVIDE(ADC12MCTL17_H      = 0x0843);
PROVIDE(ADC12MCTL18        = 0x0844);
PROVIDE(ADC12MCTL18_L      = 0x0844);
PROVIDE(ADC12MCTL18_H      = 0x0845);
PROVIDE(ADC12MCTL19        = 0x0846);
PROVIDE(ADC12MCTL19_L      = 0x0846);
PROVIDE(ADC12MCTL19_H      = 0x0847);
PROVIDE(ADC12MCTL20        = 0x0848);
PROVIDE(ADC12MCTL20_L      = 0x0848);
PROVIDE(ADC12MCTL20_H      = 0x0849);
PROVIDE(ADC12MCTL21        = 0x084A);
PROVIDE(ADC12MCTL21_L      = 0x084A);
PROVIDE(ADC12MCTL21_H      = 0x084B);
PROVIDE(ADC12MCTL22        = 0x084C);
PROVIDE(ADC12MCTL22_L      = 0x084C);
PROVIDE(ADC12MCTL22_H      = 0x084D);
PROVIDE(ADC12MCTL23        = 0x084E);
PROVIDE(ADC12MCTL23_L      = 0x084E);
PROVIDE(ADC12MCTL23_H      = 0x084F);
PROVIDE(ADC12MCTL24        = 0x0850);
PROVIDE(ADC12MCTL24_L      = 0x0850);
PROVIDE(ADC12MCTL24_H      = 0x0851);
PROVIDE(ADC12MCTL25        = 0x0852);
PROVIDE(ADC12MCTL25_L      = 0x0852);
PROVIDE(ADC12MCTL25_H      = 0x0853);
PROVIDE(ADC12MCTL26        = 0x0854);
PROVIDE(ADC12MCTL26_L      = 0x0854);
PROVIDE(ADC12MCTL26_H      = 0x0855);
PROVIDE(ADC12MCTL27        = 0x0856);
PROVIDE(ADC12MCTL27_L      = 0x0856);
PROVIDE(ADC12MCTL27_H      = 0x0857);
PROVIDE(ADC12MCTL28        = 0x0858);
PROVIDE(ADC12MCTL28_L      = 0x0858);
PROVIDE(ADC12MCTL28_H      = 0x0859);
PROVIDE(ADC12MCTL29        = 0x085A);
PROVIDE(ADC12MCTL29_L      = 0x085A);
PROVIDE(ADC12MCTL29_H      = 0x085B);
PROVIDE(ADC12MCTL30        = 0x085C);
PROVIDE(ADC12MCTL30_L      = 0x085C);
PROVIDE(ADC12MCTL30_H      = 0x085D);
PROVIDE(ADC12MCTL31        = 0x085E);
PROVIDE(ADC12MCTL31_L      = 0x085E);
PROVIDE(ADC12MCTL31_H      = 0x085F);
PROVIDE(ADC12MEM0          = 0x0860);
PROVIDE(ADC12MEM0_L        = 0x0860);
PROVIDE(ADC12MEM0_H        = 0x0861);
PROVIDE(ADC12MEM1          = 0x0862);
PROVIDE(ADC12MEM1_L        = 0x0862);
PROVIDE(ADC12MEM1_H        = 0x0863);
PROVIDE(ADC12MEM2          = 0x0864);
PROVIDE(ADC12MEM2_L        = 0x0864);
PROVIDE(ADC12MEM2_H        = 0x0865);
PROVIDE(ADC12MEM3          = 0x0866);
PROVIDE(ADC12MEM3_L        = 0x0866);
PROVIDE(ADC12MEM3_H        = 0x0867);
PROVIDE(ADC12MEM4          = 0x0868);
PROVIDE(ADC12MEM4_L        = 0x0868);
PROVIDE(ADC12MEM4_H        = 0x0869);
PROVIDE(ADC12MEM5          = 0x086A);
PROVIDE(ADC12MEM5_L        = 0x086A);
PROVIDE(ADC12MEM5_H        = 0x086B);
PROVIDE(ADC12MEM6          = 0x086C);
PROVIDE(ADC12MEM6_L        = 0x086C);
PROVIDE(ADC12MEM6_H        = 0x086D);
PROVIDE(ADC12MEM7          = 0x086E);
PROVIDE(ADC12MEM7_L        = 0x086E);
PROVIDE(ADC12MEM7_H        = 0x086F);
PROVIDE(ADC12MEM8          = 0x0870);
PROVIDE(ADC12MEM8_L        = 0x0870);
PROVIDE(ADC12MEM8_H        = 0x0871);
PROVIDE(ADC12MEM9          = 0x0872);
PROVIDE(ADC12MEM9_L        = 0x0872);
PROVIDE(ADC12MEM9_H        = 0x0873);
PROVIDE(ADC12MEM10         = 0x0874);
PROVIDE(ADC12MEM10_L       = 0x0874);
PROVIDE(ADC12MEM10_H       = 0x0875);
PROVIDE(ADC12MEM11         = 0x0876);
PROVIDE(ADC12MEM11_L       = 0x0876);
PROVIDE(ADC12MEM11_H       = 0x0877);
PROVIDE(ADC12MEM12         = 0x0878);
PROVIDE(ADC12MEM12_L       = 0x0878);
PROVIDE(ADC12MEM12_H       = 0x0879);
PROVIDE(ADC12MEM13         = 0x087A);
PROVIDE(ADC12MEM13_L       = 0x087A);
PROVIDE(ADC12MEM13_H       = 0x087B);
PROVIDE(ADC12MEM14         = 0x087C);
PROVIDE(ADC12MEM14_L       = 0x087C);
PROVIDE(ADC12MEM14_H       = 0x087D);
PROVIDE(ADC12MEM15         = 0x087E);
PROVIDE(ADC12MEM15_L       = 0x087E);
PROVIDE(ADC12MEM15_H       = 0x087F);
PROVIDE(ADC12MEM16         = 0x0880);
PROVIDE(ADC12MEM16_L       = 0x0880);
PROVIDE(ADC12MEM16_H       = 0x0881);
PROVIDE(ADC12MEM17         = 0x0882);
PROVIDE(ADC12MEM17_L       = 0x0882);
PROVIDE(ADC12MEM17_H       = 0x0883);
PROVIDE(ADC12MEM18         = 0x0884);
PROVIDE(ADC12MEM18_L       = 0x0884);
PROVIDE(ADC12MEM18_H       = 0x0885);
PROVIDE(ADC12MEM19         = 0x0886);
PROVIDE(ADC12MEM19_L       = 0x0886);
PROVIDE(ADC12MEM19_H       = 0x0887);
PROVIDE(ADC12MEM20         = 0x0888);
PROVIDE(ADC12MEM20_L       = 0x0888);
PROVIDE(ADC12MEM20_H       = 0x0889);
PROVIDE(ADC12MEM21         = 0x088A);
PROVIDE(ADC12MEM21_L       = 0x088A);
PROVIDE(ADC12MEM21_H       = 0x088B);
PROVIDE(ADC12MEM22         = 0x088C);
PROVIDE(ADC12MEM22_L       = 0x088C);
PROVIDE(ADC12MEM22_H       = 0x088D);
PROVIDE(ADC12MEM23         = 0x088E);
PROVIDE(ADC12MEM23_L       = 0x088E);
PROVIDE(ADC12MEM23_H       = 0x088F);
PROVIDE(ADC12MEM24         = 0x0890);
PROVIDE(ADC12MEM24_L       = 0x0890);
PROVIDE(ADC12MEM24_H       = 0x0891);
PROVIDE(ADC12MEM25         = 0x0892);
PROVIDE(ADC12MEM25_L       = 0x0892);
PROVIDE(ADC12MEM25_H       = 0x0893);
PROVIDE(ADC12MEM26         = 0x0894);
PROVIDE(ADC12MEM26_L       = 0x0894);
PROVIDE(ADC12MEM26_H       = 0x0895);
PROVIDE(ADC12MEM27         = 0x0896);
PROVIDE(ADC12MEM27_L       = 0x0896);
PROVIDE(ADC12MEM27_H       = 0x0897);
PROVIDE(ADC12MEM28         = 0x0898);
PROVIDE(ADC12MEM28_L       = 0x0898);
PROVIDE(ADC12MEM28_H       = 0x0899);
PROVIDE(ADC12MEM29         = 0x089A);
PROVIDE(ADC12MEM29_L       = 0x089A);
PROVIDE(ADC12MEM29_H       = 0x089B);
PROVIDE(ADC12MEM30         = 0x089C);
PROVIDE(ADC12MEM30_L       = 0x089C);
PROVIDE(ADC12MEM30_H       = 0x089D);
PROVIDE(ADC12MEM31         = 0x089E);
PROVIDE(ADC12MEM31_L       = 0x089E);
PROVIDE(ADC12MEM31_H       = 0x089F);


/*****************************************************************************
 AES256
*****************************************************************************/
PROVIDE(AESACTL0           = 0x09C0);
PROVIDE(AESACTL0_L         = 0x09C0);
PROVIDE(AESACTL0_H         = 0x09C1);
PROVIDE(AESACTL1           = 0x09C2);
PROVIDE(AESACTL1_L         = 0x09C2);
PROVIDE(AESACTL1_H         = 0x09C3);
PROVIDE(AESASTAT           = 0x09C4);
PROVIDE(AESASTAT_L         = 0x09C4);
PROVIDE(AESASTAT_H         = 0x09C5);
PROVIDE(AESAKEY            = 0x09C6);
PROVIDE(AESAKEY_L          = 0x09C6);
PROVIDE(AESAKEY_H          = 0x09C7);
PROVIDE(AESADIN            = 0x09C8);
PROVIDE(AESADIN_L          = 0x09C8);
PROVIDE(AESADIN_H          = 0x09C9);
PROVIDE(AESADOUT           = 0x09CA);
PROVIDE(AESADOUT_L         = 0x09CA);
PROVIDE(AESADOUT_H         = 0x09CB);
PROVIDE(AESAXDIN           = 0x09CC);
PROVIDE(AESAXDIN_L         = 0x09CC);
PROVIDE(AESAXDIN_H         = 0x09CD);
PROVIDE(AESAXIN            = 0x09CE);
PROVIDE(AESAXIN_L          = 0x09CE);
PROVIDE(AESAXIN_H          = 0x09CF);


/*****************************************************************************
 CAPTIO0
*****************************************************************************/
PROVIDE(CAPTIO0CTL         = 0x043E);
PROVIDE(CAPTIO0CTL_L       = 0x043E);
PROVIDE(CAPTIO0CTL_H       = 0x043F);


/*****************************************************************************
 CAPTIO1
*****************************************************************************/
PROVIDE(CAPTIO1CTL         = 0x047E);
PROVIDE(CAPTIO1CTL_L       = 0x047E);
PROVIDE(CAPTIO1CTL_H       = 0x047F);


/*****************************************************************************
 COMP_E
*****************************************************************************/
PROVIDE(CECTL0             = 0x08C0);
PROVIDE(CECTL0_L           = 0x08C0);
PROVIDE(CECTL0_H           = 0x08C1);
PROVIDE(CECTL1             = 0x08C2);
PROVIDE(CECTL1_L           = 0x08C2);
PROVIDE(CECTL1_H           = 0x08C3);
PROVIDE(CECTL2             = 0x08C4);
PROVIDE(CECTL2_L           = 0x08C4);
PROVIDE(CECTL2_H           = 0x08C5);
PROVIDE(CECTL3             = 0x08C6);
PROVIDE(CECTL3_L           = 0x08C6);
PROVIDE(CECTL3_H           = 0x08C7);
PROVIDE(CEINT              = 0x08CC);
PROVIDE(CEINT_L            = 0x08CC);
PROVIDE(CEINT_H            = 0x08CD);
PROVIDE(CEIV               = 0x08CE);
PROVIDE(CEIV_L             = 0x08CE);
PROVIDE(CEIV_H             = 0x08CF);


/*****************************************************************************
 CRC
*****************************************************************************/
PROVIDE(CRCDI              = 0x0150);
PROVIDE(CRCDI_L            = 0x0150);
PROVIDE(CRCDI_H            = 0x0151);
PROVIDE(CRCDIRB            = 0x0152);
PROVIDE(CRCDIRB_L          = 0x0152);
PROVIDE(CRCDIRB_H          = 0x0153);
PROVIDE(CRCINIRES          = 0x0154);
PROVIDE(CRCINIRES_L        = 0x0154);
PROVIDE(CRCINIRES_H        = 0x0155);
PROVIDE(CRCRESR            = 0x0156);
PROVIDE(CRCRESR_L          = 0x0156);
PROVIDE(CRCRESR_H          = 0x0157);


/*****************************************************************************
 CRC32
*****************************************************************************/
PROVIDE(CRC32DIW0          = 0x0980);
PROVIDE(CRC32DIW0_L        = 0x0980);
PROVIDE(CRC32DIW0_H        = 0x0981);
PROVIDE(CRC32DIW1          = 0x0982);
PROVIDE(CRC32DIW1_L        = 0x0982);
PROVIDE(CRC32DIW1_H        = 0x0983);
PROVIDE(CRC32DIRBW1        = 0x0984);
PROVIDE(CRC32DIRBW1_L      = 0x0984);
PROVIDE(CRC32DIRBW1_H      = 0x0985);
PROVIDE(CRC32DIRBW0        = 0x0986);
PROVIDE(CRC32DIRBW0_L      = 0x0986);
PROVIDE(CRC32DIRBW0_H      = 0x0987);
PROVIDE(CRC32INIRESW0      = 0x0988);
PROVIDE(CRC32INIRESW0_L    = 0x0988);
PROVIDE(CRC32INIRESW0_H    = 0x0989);
PROVIDE(CRC32INIRESW1      = 0x098A);
PROVIDE(CRC32INIRESW1_L    = 0x098A);
PROVIDE(CRC32INIRESW1_H    = 0x098B);
PROVIDE(CRC32RESRW1        = 0x098C);
PROVIDE(CRC32RESRW1_L      = 0x098C);
PROVIDE(CRC32RESRW1_H      = 0x098D);
PROVIDE(CRC32RESRW0        = 0x098E);
PROVIDE(CRC32RESRW0_L      = 0x098E);
PROVIDE(CRC32RESRW0_H      = 0x098F);
PROVIDE(CRC16DIW0          = 0x0990);
PROVIDE(CRC16DIW0_L        = 0x0990);
PROVIDE(CRC16DIW0_H        = 0x0991);
PROVIDE(CRC16DIRBW0        = 0x0996);
PROVIDE(CRC16DIRBW0_L      = 0x0996);
PROVIDE(CRC16DIRBW0_H      = 0x0997);
PROVIDE(CRC16INIRESW0      = 0x0998);
PROVIDE(CRC16INIRESW0_L    = 0x0998);
PROVIDE(CRC16INIRESW0_H    = 0x0999);
PROVIDE(CRC16RESRW0        = 0x099E);
PROVIDE(CRC16RESRW0_L      = 0x099E);
PROVIDE(CRC16RESRW0_H      = 0x099F);


/*****************************************************************************
 CS
*****************************************************************************/
PROVIDE(CSCTL0             = 0x0160);
PROVIDE(CSCTL0_L           = 0x0160);
PROVIDE(CSCTL0_H           = 0x0161);
PROVIDE(CSCTL1             = 0x0162);
PROVIDE(CSCTL1_L           = 0x0162);
PROVIDE(CSCTL1_H           = 0x0163);
PROVIDE(CSCTL2             = 0x0164);
PROVIDE(CSCTL2_L           = 0x0164);
PROVIDE(CSCTL2_H           = 0x0165);
PROVIDE(CSCTL3             = 0x0166);
PROVIDE(CSCTL3_L           = 0x0166);
PROVIDE(CSCTL3_H           = 0x0167);
PROVIDE(CSCTL4             = 0x0168);
PROVIDE(CSCTL4_L           = 0x0168);
PROVIDE(CSCTL4_H           = 0x0169);
PROVIDE(CSCTL5             = 0x016A);
PROVIDE(CSCTL5_L           = 0x016A);
PROVIDE(CSCTL5_H           = 0x016B);
PROVIDE(CSCTL6             = 0x016C);
PROVIDE(CSCTL6_L           = 0x016C);
PROVIDE(CSCTL6_H           = 0x016D);


/*****************************************************************************
 DIO
*****************************************************************************/
PROVIDE(PAIN               = 0x0200);
PROVIDE(PAIN_L             = 0x0200);
PROVIDE(PAIN_H             = 0x0201);
PROVIDE(PAOUT              = 0x0202);
PROVIDE(PAOUT_L            = 0x0202);
PROVIDE(PAOUT_H            = 0x0203);
PROVIDE(PADIR              = 0x0204);
PROVIDE(PADIR_L            = 0x0204);
PROVIDE(PADIR_H            = 0x0205);
PROVIDE(PAREN              = 0x0206);
PROVIDE(PAREN_L            = 0x0206);
PROVIDE(PAREN_H            = 0x0207);
PROVIDE(PASEL0             = 0x020A);
PROVIDE(PASEL0_L           = 0x020A);
PROVIDE(PASEL0_H           = 0x020B);
PROVIDE(PASEL1             = 0x020C);
PROVIDE(PASEL1_L           = 0x020C);
PROVIDE(PASEL1_H           = 0x020D);
PROVIDE(P1IV               = 0x020E);
PROVIDE(P1IV_L             = 0x020E);
PROVIDE(P1IV_H             = 0x020F);
PROVIDE(PASELC             = 0x0216);
PROVIDE(PASELC_L           = 0x0216);
PROVIDE(PASELC_H           = 0x0217);
PROVIDE(PAIES              = 0x0218);
PROVIDE(PAIES_L            = 0x0218);
PROVIDE(PAIES_H            = 0x0219);
PROVIDE(PAIE               = 0x021A);
PROVIDE(PAIE_L             = 0x021A);
PROVIDE(PAIE_H             = 0x021B);
PROVIDE(PAIFG              = 0x021C);
PROVIDE(PAIFG_L            = 0x021C);
PROVIDE(PAIFG_H            = 0x021D);
PROVIDE(P2IV               = 0x021E);
PROVIDE(P2IV_L             = 0x021E);
PROVIDE(P2IV_H             = 0x021F);
PROVIDE(PBIN               = 0x0220);
PROVIDE(PBIN_L             = 0x0220);
PROVIDE(PBIN_H             = 0x0221);
PROVIDE(PBOUT              = 0x0222);
PROVIDE(PBOUT_L            = 0x0222);
PROVIDE(PBOUT_H            = 0x0223);
PROVIDE(PBDIR              = 0x0224);
PROVIDE(PBDIR_L            = 0x0224);
PROVIDE(PBDIR_H            = 0x0225);
PROVIDE(PBREN              = 0x0226);
PROVIDE(PBREN_L            = 0x0226);
PROVIDE(PBREN_H            = 0x0227);
PROVIDE(PBSEL0             = 0x022A);
PROVIDE(PBSEL0_L           = 0x022A);
PROVIDE(PBSEL0_H           = 0x022B);
PROVIDE(PBSEL1             = 0x022C);
PROVIDE(PBSEL1_L           = 0x022C);
PROVIDE(PBSEL1_H           = 0x022D);
PROVIDE(P3IV               = 0x022E);
PROVIDE(P3IV_L             = 0x022E);
PROVIDE(P3IV_H             = 0x022F);
PROVIDE(PBSELC             = 0x0236);
PROVIDE(PBSELC_L           = 0x0236);
PROVIDE(PBSELC_H           = 0x0237);
PROVIDE(PBIES              = 0x0238);
PROVIDE(PBIES_L            = 0x0238);
PROVIDE(PBIES_H            = 0x0239);
PROVIDE(PBIE               = 0x023A);
PROVIDE(PBIE_L             = 0x023A);
PROVIDE(PBIE_H             = 0x023B);
PROVIDE(PBIFG              = 0x023C);
PROVIDE(PBIFG_L            = 0x023C);
PROVIDE(PBIFG_H            = 0x023D);
PROVIDE(P4IV               = 0x023E);
PROVIDE(P4IV_L             = 0x023E);
PROVIDE(P4IV_H             = 0x023F);
PROVIDE(PCIN               = 0x0240);
PROVIDE(PCIN_L             = 0x0240);
PROVIDE(PCIN_H             = 0x0241);
PROVIDE(PCOUT              = 0x0242);
PROVIDE(PCOUT_L            = 0x0242);
PROVIDE(PCOUT_H            = 0x0243);
PROVIDE(PCDIR              = 0x0244);
PROVIDE(PCDIR_L            = 0x0244);
PROVIDE(PCDIR_H            = 0x0245);
PROVIDE(PCREN              = 0x0246);
PROVIDE(PCREN_L            = 0x0246);
PROVIDE(PCREN_H            = 0x0247);
PROVIDE(PCSEL0             = 0x024A);
PROVIDE(PCSEL0_L           = 0x024A);
PROVIDE(PCSEL0_H           = 0x024B);
PROVIDE(PCSEL1             = 0x024C);
PROVIDE(PCSEL1_L           = 0x024C);
PROVIDE(PCSEL1_H           = 0x024D);
PROVIDE(P5IV               = 0x024E);
PROVIDE(P5IV_L             = 0x024E);
PROVIDE(P5IV_H             = 0x024F);
PROVIDE(PCSELC             = 0x0256);
PROVIDE(PCSELC_L           = 0x0256);
PROVIDE(PCSELC_H           = 0x0257);
PROVIDE(PCIES              = 0x0258);
PROVIDE(PCIES_L            = 0x0258);
PROVIDE(PCIES_H            = 0x0259);
PROVIDE(PCIE               = 0x025A);
PROVIDE(PCIE_L             = 0x025A);
PROVIDE(PCIE_H             = 0x025B);
PROVIDE(PCIFG              = 0x025C);
PROVIDE(PCIFG_L            = 0x025C);
PROVIDE(PCIFG_H            = 0x025D);
PROVIDE(P6IV               = 0x025E);
PROVIDE(P6IV_L             = 0x025E);
PROVIDE(P6IV_H             = 0x025F);
PROVIDE(PDIN               = 0x0260);
PROVIDE(PDIN_L             = 0x0260);
PROVIDE(PDIN_H             = 0x0261);
PROVIDE(PDOUT              = 0x0262);
PROVIDE(PDOUT_L            = 0x0262);
PROVIDE(PDOUT_H            = 0x0263);
PROVIDE(PDDIR              = 0x0264);
PROVIDE(PDDIR_L            = 0x0264);
PROVIDE(PDDIR_H            = 0x0265);
PROVIDE(PDREN              = 0x0266);
PROVIDE(PDREN_L            = 0x0266);
PROVIDE(PDREN_H            = 0x0267);
PROVIDE(PDSEL0             = 0x026A);
PROVIDE(PDSEL0_L           = 0x026A);
PROVIDE(PDSEL0_H           = 0x026B);
PROVIDE(PDSEL1             = 0x026C);
PROVIDE(PDSEL1_L           = 0x026C);
PROVIDE(PDSEL1_H           = 0x026D);
PROVIDE(P7IV               = 0x026E);
PROVIDE(P7IV_L             = 0x026E);
PROVIDE(P7IV_H             = 0x026F);
PROVIDE(PDSELC             = 0x0276);
PROVIDE(PDSELC_L           = 0x0276);
PROVIDE(PDSELC_H           = 0x0277);
PROVIDE(PDIES              = 0x0278);
PROVIDE(PDIES_L            = 0x0278);
PROVIDE(PDIES_H            = 0x0279);
PROVIDE(PDIE               = 0x027A);
PROVIDE(PDIE_L             = 0x027A);
PROVIDE(PDIE_H             = 0x027B);
PROVIDE(PDIFG              = 0x027C);
PROVIDE(PDIFG_L            = 0x027C);
PROVIDE(PDIFG_H            = 0x027D);
PROVIDE(P8IV               = 0x027E);
PROVIDE(P8IV_L             = 0x027E);
PROVIDE(P8IV_H             = 0x027F);
PROVIDE(PEIN               = 0x0280);
PROVIDE(PEIN_L             = 0x0280);
PROVIDE(PEIN_H             = 0x0281);
PROVIDE(PEOUT              = 0x0282);
PROVIDE(PEOUT_L            = 0x0282);
PROVIDE(PEOUT_H            = 0x0283);
PROVIDE(PEDIR              = 0x0284);
PROVIDE(PEDIR_L            = 0x0284);
PROVIDE(PEDIR_H            = 0x0285);
PROVIDE(PEREN              = 0x0286);
PROVIDE(PEREN_L            = 0x0286);
PROVIDE(PEREN_H            = 0x0287);
PROVIDE(PESEL0             = 0x028A);
PROVIDE(PESEL0_L           = 0x028A);
PROVIDE(PESEL0_H           = 0x028B);
PROVIDE(PESEL1             = 0x028C);
PROVIDE(PESEL1_L           = 0x028C);
PROVIDE(PESEL1_H           = 0x028D);
PROVIDE(P9IV               = 0x028E);
PROVIDE(P9IV_L             = 0x028E);
PROVIDE(P9IV_H             = 0x028F);
PROVIDE(PESELC             = 0x0296);
PROVIDE(PESELC_L           = 0x0296);
PROVIDE(PESELC_H           = 0x0297);
PROVIDE(PEIES              = 0x0298);
PROVIDE(PEIES_L            = 0x0298);
PROVIDE(PEIES_H            = 0x0299);
PROVIDE(PEIE               = 0x029A);
PROVIDE(PEIE_L             = 0x029A);
PROVIDE(PEIE_H             = 0x029B);
PROVIDE(PEIFG              = 0x029C);
PROVIDE(PEIFG_L            = 0x029C);
PROVIDE(PEIFG_H            = 0x029D);
PROVIDE(PJIN               = 0x0320);
PROVIDE(PJIN_L             = 0x0320);
PROVIDE(PJIN_H             = 0x0321);
PROVIDE(PJOUT              = 0x0322);
PROVIDE(PJOUT_L            = 0x0322);
PROVIDE(PJOUT_H            = 0x0323);
PROVIDE(PJDIR              = 0x0324);
PROVIDE(PJDIR_L            = 0x0324);
PROVIDE(PJDIR_H            = 0x0325);
PROVIDE(PJREN              = 0x0326);
PROVIDE(PJREN_L            = 0x0326);
PROVIDE(PJREN_H            = 0x0327);
PROVIDE(PJSEL0             = 0x032A);
PROVIDE(PJSEL0_L           = 0x032A);
PROVIDE(PJSEL0_H           = 0x032B);
PROVIDE(PJSEL1             = 0x032C);
PROVIDE(PJSEL1_L           = 0x032C);
PROVIDE(PJSEL1_H           = 0x032D);
PROVIDE(PJSELC             = 0x0336);
PROVIDE(PJSELC_L           = 0x0336);
PROVIDE(PJSELC_H           = 0x0337);
PROVIDE(P1IN               = 0x0200);

PROVIDE(P2IN               = 0x0201);

PROVIDE(P2OUT              = 0x0203);

PROVIDE(P1OUT              = 0x0202);

PROVIDE(P1DIR              = 0x0204);

PROVIDE(P2DIR              = 0x0205);

PROVIDE(P1REN              = 0x0206);

PROVIDE(P2REN              = 0x0207);

PROVIDE(P1SEL0             = 0x020A);

PROVIDE(P2SEL0             = 0x020B);

PROVIDE(P1SEL1             = 0x020C);

PROVIDE(P2SEL1             = 0x020D);

PROVIDE(P1SELC             = 0x0216);

PROVIDE(P2SELC             = 0x0217);

PROVIDE(P1IES              = 0x0218);

PROVIDE(P2IES              = 0x0219);

PROVIDE(P1IE               = 0x021A);

PROVIDE(P2IE               = 0x021B);

PROVIDE(P1IFG              = 0x021C);

PROVIDE(P2IFG              = 0x021D);

PROVIDE(P3IN               = 0x0220);

PROVIDE(P4IN               = 0x0221);

PROVIDE(P3OUT              = 0x0222);

PROVIDE(P4OUT              = 0x0223);

PROVIDE(P3DIR              = 0x0224);

PROVIDE(P4DIR              = 0x0225);

PROVIDE(P3REN              = 0x0226);

PROVIDE(P4REN              = 0x0227);

PROVIDE(P4SEL0             = 0x022B);

PROVIDE(P3SEL0             = 0x022A);

PROVIDE(P3SEL1             = 0x022C);

PROVIDE(P4SEL1             = 0x022D);

PROVIDE(P3SELC             = 0x0236);

PROVIDE(P4SELC             = 0x0237);

PROVIDE(P3IES              = 0x0238);

PROVIDE(P4IES              = 0x0239);

PROVIDE(P3IE               = 0x023A);

PROVIDE(P4IE               = 0x023B);

PROVIDE(P3IFG              = 0x023C);

PROVIDE(P4IFG              = 0x023D);

PROVIDE(P5IN               = 0x0240);

PROVIDE(P6IN               = 0x0241);

PROVIDE(P5OUT              = 0x0242);

PROVIDE(P6OUT              = 0x0243);

PROVIDE(P5DIR              = 0x0244);

PROVIDE(P6DIR              = 0x0245);

PROVIDE(P5REN              = 0x0246);

PROVIDE(P6REN              = 0x0247);

PROVIDE(P5SEL0             = 0x024A);

PROVIDE(P6SEL0             = 0x024B);

PROVIDE(P5SEL1             = 0x024C);

PROVIDE(P6SEL1             = 0x024D);

PROVIDE(P5SELC             = 0x0256);

PROVIDE(P6SELC             = 0x0257);

PROVIDE(P5IES              = 0x0258);

PROVIDE(P6IES              = 0x0259);

PROVIDE(P5IE               = 0x025A);

PROVIDE(P6IE               = 0x025B);

PROVIDE(P5IFG              = 0x025C);

PROVIDE(P6IFG              = 0x025D);

PROVIDE(P7IN               = 0x0260);

PROVIDE(P8IN               = 0x0261);

PROVIDE(P7OUT              = 0x0262);

PROVIDE(P8OUT              = 0x0263);

PROVIDE(P7DIR              = 0x0264);

PROVIDE(P8DIR              = 0x0265);

PROVIDE(P7REN              = 0x0266);

PROVIDE(P8REN              = 0x0267);

PROVIDE(P7SEL0             = 0x026A);

PROVIDE(P8SEL0             = 0x026B);

PROVIDE(P7SEL1             = 0x026C);

PROVIDE(P8SEL1             = 0x026D);

PROVIDE(P7SELC             = 0x0276);

PROVIDE(P8SELC             = 0x0277);

PROVIDE(P7IES              = 0x0278);

PROVIDE(P8IES              = 0x0279);

PROVIDE(P7IE               = 0x027A);

PROVIDE(P8IE               = 0x027B);

PROVIDE(P7IFG              = 0x027C);

PROVIDE(P8IFG              = 0x027D);

PROVIDE(P9IN               = 0x0280);

PROVIDE(P9OUT              = 0x0282);

PROVIDE(P9DIR              = 0x0284);

PROVIDE(P9REN              = 0x0286);

PROVIDE(P9SEL0             = 0x028A);

PROVIDE(P9SEL1             = 0x028C);

PROVIDE(P9SELC             = 0x0296);

PROVIDE(P9IES              = 0x0298);

PROVIDE(P9IE               = 0x029A);

PROVIDE(P9IFG              = 0x029C);



/*****************************************************************************
 DMA
*****************************************************************************/
PROVIDE(DMACTL0            = 0x0500);
PROVIDE(DMACTL0_L          = 0x0500);
PROVIDE(DMACTL0_H          = 0x0501);
PROVIDE(DMACTL1            = 0x0502);
PROVIDE(DMACTL1_L          = 0x0502);
PROVIDE(DMACTL1_H          = 0x0503);
PROVIDE(DMACTL2            = 0x0504);
PROVIDE(DMACTL2_L          = 0x0504);
PROVIDE(DMACTL2_H          = 0x0505);
PROVIDE(DMACTL4            = 0x0508);
PROVIDE(DMACTL4_L          = 0x0508);
PROVIDE(DMACTL4_H          = 0x0509);
PROVIDE(DMAIV              = 0x050E);
PROVIDE(DMAIV_L            = 0x050E);
PROVIDE(DMAIV_H            = 0x050F);
PROVIDE(DMA0CTL            = 0x0510);
PROVIDE(DMA0CTL_L          = 0x0510);
PROVIDE(DMA0CTL_H          = 0x0511);
PROVIDE(DMA0SA             = 0x0512);
PROVIDE(DMA0SAL            = 0x0512);
PROVIDE(DMA0SAH            = 0x0514);

PROVIDE(DMA0DA             = 0x0516);
PROVIDE(DMA0DAL            = 0x0516);
PROVIDE(DMA0DAH            = 0x0518);

PROVIDE(DMA0SZ             = 0x051A);
PROVIDE(DMA0SZ_L           = 0x051A);
PROVIDE(DMA0SZ_H           = 0x051B);
PROVIDE(DMA1CTL            = 0x0520);
PROVIDE(DMA1CTL_L          = 0x0520);
PROVIDE(DMA1CTL_H          = 0x0521);
PROVIDE(DMA1SA             = 0x0522);
PROVIDE(DMA1SAL            = 0x0522);
PROVIDE(DMA1SAH            = 0x0524);

PROVIDE(DMA1DA             = 0x0526);
PROVIDE(DMA1DAL            = 0x0526);
PROVIDE(DMA1DAH            = 0x0528);

PROVIDE(DMA1SZ             = 0x052A);
PROVIDE(DMA1SZ_L           = 0x052A);
PROVIDE(DMA1SZ_H           = 0x052B);
PROVIDE(DMA2CTL            = 0x0530);
PROVIDE(DMA2CTL_L          = 0x0530);
PROVIDE(DMA2CTL_H          = 0x0531);
PROVIDE(DMA2SA             = 0x0532);
PROVIDE(DMA2SAL            = 0x0532);
PROVIDE(DMA2SAH            = 0x0534);

PROVIDE(DMA2DA             = 0x0536);
PROVIDE(DMA2DAL            = 0x0536);
PROVIDE(DMA2DAH            = 0x0538);

PROVIDE(DMA2SZ             = 0x053A);
PROVIDE(DMA2SZ_L           = 0x053A);
PROVIDE(DMA2SZ_H           = 0x053B);
PROVIDE(DMA3CTL            = 0x0540);
PROVIDE(DMA3CTL_L          = 0x0540);
PROVIDE(DMA3CTL_H          = 0x0541);
PROVIDE(DMA3SA             = 0x0542);
PROVIDE(DMA3SAL            = 0x0542);
PROVIDE(DMA3SAH            = 0x0544);

PROVIDE(DMA3DA             = 0x0546);
PROVIDE(DMA3DAL            = 0x0546);
PROVIDE(DMA3DAH            = 0x0548);

PROVIDE(DMA3SZ             = 0x054A);
PROVIDE(DMA3SZ_L           = 0x054A);
PROVIDE(DMA3SZ_H           = 0x054B);
PROVIDE(DMA4CTL            = 0x0550);
PROVIDE(DMA4CTL_L          = 0x0550);
PROVIDE(DMA4CTL_H          = 0x0551);
PROVIDE(DMA4SA             = 0x0552);
PROVIDE(DMA4SAL            = 0x0552);
PROVIDE(DMA4SAH            = 0x0554);

PROVIDE(DMA4DA             = 0x0556);
PROVIDE(DMA4DAL            = 0x0556);
PROVIDE(DMA4DAH            = 0x0558);

PROVIDE(DMA4SZ             = 0x055A);
PROVIDE(DMA4SZ_L           = 0x055A);
PROVIDE(DMA4SZ_H           = 0x055B);
PROVIDE(DMA5CTL            = 0x0560);
PROVIDE(DMA5CTL_L          = 0x0560);
PROVIDE(DMA5CTL_H          = 0x0561);
PROVIDE(DMA5SA             = 0x0562);
PROVIDE(DMA5SAL            = 0x0562);
PROVIDE(DMA5SAH            = 0x0564);

PROVIDE(DMA5DA             = 0x0566);
PROVIDE(DMA5DAL            = 0x0566);
PROVIDE(DMA5DAH            = 0x0568);

PROVIDE(DMA5SZ             = 0x056A);
PROVIDE(DMA5SZ_L           = 0x056A);
PROVIDE(DMA5SZ_H           = 0x056B);


/*****************************************************************************
 FRCTL_A
*****************************************************************************/
PROVIDE(FRCTL0             = 0x0140);
PROVIDE(FRCTL0_L           = 0x0140);
PROVIDE(FRCTL0_H           = 0x0141);
PROVIDE(GCCTL0             = 0x0144);
PROVIDE(GCCTL0_L           = 0x0144);
PROVIDE(GCCTL0_H           = 0x0145);
PROVIDE(GCCTL1             = 0x0146);
PROVIDE(GCCTL1_L           = 0x0146);
PROVIDE(GCCTL1_H           = 0x0147);


/*****************************************************************************
 HSPLL
*****************************************************************************/
PROVIDE(HSPLLIIDX          = 0x0EE0);
PROVIDE(HSPLLIIDX_L        = 0x0EE0);
PROVIDE(HSPLLIIDX_H        = 0x0EE1);
PROVIDE(HSPLLMIS           = 0x0EE2);
PROVIDE(HSPLLMIS_L         = 0x0EE2);
PROVIDE(HSPLLMIS_H         = 0x0EE3);
PROVIDE(HSPLLRIS           = 0x0EE4);
PROVIDE(HSPLLRIS_L         = 0x0EE4);
PROVIDE(HSPLLRIS_H         = 0x0EE5);
PROVIDE(HSPLLIMSC          = 0x0EE6);
PROVIDE(HSPLLIMSC_L        = 0x0EE6);
PROVIDE(HSPLLIMSC_H        = 0x0EE7);
PROVIDE(HSPLLICR           = 0x0EE8);
PROVIDE(HSPLLICR_L         = 0x0EE8);
PROVIDE(HSPLLICR_H         = 0x0EE9);
PROVIDE(HSPLLISR           = 0x0EEA);
PROVIDE(HSPLLISR_L         = 0x0EEA);
PROVIDE(HSPLLISR_H         = 0x0EEB);
PROVIDE(HSPLLDESCLO        = 0x0EEC);
PROVIDE(HSPLLDESCLO_L      = 0x0EEC);
PROVIDE(HSPLLDESCLO_H      = 0x0EED);
PROVIDE(HSPLLDESCHI        = 0x0EEE);
PROVIDE(HSPLLDESCHI_L      = 0x0EEE);
PROVIDE(HSPLLDESCHI_H      = 0x0EEF);
PROVIDE(HSPLLCTL           = 0x0EF0);
PROVIDE(HSPLLCTL_L         = 0x0EF0);
PROVIDE(HSPLLCTL_H         = 0x0EF1);
PROVIDE(HSPLLUSSXTLCTL     = 0x0EF2);
PROVIDE(HSPLLUSSXTLCTL_L   = 0x0EF2);
PROVIDE(HSPLLUSSXTLCTL_H   = 0x0EF3);


/*****************************************************************************
 LEA
*****************************************************************************/
PROVIDE(LEACAP             = 0x0A80);
PROVIDE(LEACAPL            = 0x0A80);
PROVIDE(LEACAPH            = 0x0A82);

PROVIDE(LEACNF0            = 0x0A84);
PROVIDE(LEACNF0L           = 0x0A84);
PROVIDE(LEACNF0H           = 0x0A86);

PROVIDE(LEACNF1            = 0x0A88);
PROVIDE(LEACNF1L           = 0x0A88);
PROVIDE(LEACNF1H           = 0x0A8A);

PROVIDE(LEACNF2            = 0x0A8C);
PROVIDE(LEACNF2L           = 0x0A8C);
PROVIDE(LEACNF2H           = 0x0A8E);

PROVIDE(LEAMB              = 0x0A90);
PROVIDE(LEAMBL             = 0x0A90);
PROVIDE(LEAMBH             = 0x0A92);

PROVIDE(LEAMT              = 0x0A94);
PROVIDE(LEAMTL             = 0x0A94);
PROVIDE(LEAMTH             = 0x0A96);

PROVIDE(LEACMA             = 0x0A98);
PROVIDE(LEACMAL            = 0x0A98);
PROVIDE(LEACMAH            = 0x0A9A);

PROVIDE(LEACMCTL           = 0x0A9C);
PROVIDE(LEACMCTLL          = 0x0A9C);
PROVIDE(LEACMCTLH          = 0x0A9E);

PROVIDE(LEACMDSTAT         = 0x0AA8);
PROVIDE(LEACMDSTATL        = 0x0AA8);
PROVIDE(LEACMDSTATH        = 0x0AAA);

PROVIDE(LEAS1STAT          = 0x0AAC);
PROVIDE(LEAS1STATL         = 0x0AAC);
PROVIDE(LEAS1STATH         = 0x0AAE);

PROVIDE(LEAS0STAT          = 0x0AB0);
PROVIDE(LEAS0STATL         = 0x0AB0);
PROVIDE(LEAS0STATH         = 0x0AB2);

PROVIDE(LEADSTSTAT         = 0x0AB4);
PROVIDE(LEADSTSTATL        = 0x0AB4);
PROVIDE(LEADSTSTATH        = 0x0AB6);

PROVIDE(LEAPMCTL           = 0x0AC0);
PROVIDE(LEAPMCTLL          = 0x0AC0);
PROVIDE(LEAPMCTLH          = 0x0AC2);

PROVIDE(LEAPMDST           = 0x0AC4);
PROVIDE(LEAPMDSTL          = 0x0AC4);
PROVIDE(LEAPMDSTH          = 0x0AC6);

PROVIDE(LEAPMS1            = 0x0AC8);
PROVIDE(LEAPMS1L           = 0x0AC8);
PROVIDE(LEAPMS1H           = 0x0ACA);

PROVIDE(LEAPMS0            = 0x0ACC);
PROVIDE(LEAPMS0L           = 0x0ACC);
PROVIDE(LEAPMS0H           = 0x0ACE);

PROVIDE(LEAPMCB            = 0x0AD0);
PROVIDE(LEAPMCBL           = 0x0AD0);
PROVIDE(LEAPMCBH           = 0x0AD2);

PROVIDE(LEAIFGSET          = 0x0AF0);
PROVIDE(LEAIFGSETL         = 0x0AF0);
PROVIDE(LEAIFGSETH         = 0x0AF2);

PROVIDE(LEAIE              = 0x0AF4);
PROVIDE(LEAIEL             = 0x0AF4);
PROVIDE(LEAIEH             = 0x0AF6);

PROVIDE(LEAIFG             = 0x0AF8);
PROVIDE(LEAIFGL            = 0x0AF8);
PROVIDE(LEAIFGH            = 0x0AFA);

PROVIDE(LEAIV              = 0x0AFC);
PROVIDE(LEAIVL             = 0x0AFC);
PROVIDE(LEAIVH             = 0x0AFE);



/*****************************************************************************
 MPU
*****************************************************************************/
PROVIDE(MPUCTL0            = 0x05A0);
PROVIDE(MPUCTL0_L          = 0x05A0);
PROVIDE(MPUCTL0_H          = 0x05A1);
PROVIDE(MPUCTL1            = 0x05A2);
PROVIDE(MPUCTL1_L          = 0x05A2);
PROVIDE(MPUCTL1_H          = 0x05A3);
PROVIDE(MPUSEGB2           = 0x05A4);
PROVIDE(MPUSEGB2_L         = 0x05A4);
PROVIDE(MPUSEGB2_H         = 0x05A5);
PROVIDE(MPUSEGB1           = 0x05A6);
PROVIDE(MPUSEGB1_L         = 0x05A6);
PROVIDE(MPUSEGB1_H         = 0x05A7);
PROVIDE(MPUSAM             = 0x05A8);
PROVIDE(MPUSAM_L           = 0x05A8);
PROVIDE(MPUSAM_H           = 0x05A9);
PROVIDE(MPUIPC0            = 0x05AA);
PROVIDE(MPUIPC0_L          = 0x05AA);
PROVIDE(MPUIPC0_H          = 0x05AB);
PROVIDE(MPUIPSEGB2         = 0x05AC);
PROVIDE(MPUIPSEGB2_L       = 0x05AC);
PROVIDE(MPUIPSEGB2_H       = 0x05AD);
PROVIDE(MPUIPSEGB1         = 0x05AE);
PROVIDE(MPUIPSEGB1_L       = 0x05AE);
PROVIDE(MPUIPSEGB1_H       = 0x05AF);


/*****************************************************************************
 MPY32
*****************************************************************************/
PROVIDE(MPY                = 0x04C0);
PROVIDE(MPY_L              = 0x04C0);
PROVIDE(MPY_H              = 0x04C1);
PROVIDE(MPYS               = 0x04C2);
PROVIDE(MPYS_L             = 0x04C2);
PROVIDE(MPYS_H             = 0x04C3);
PROVIDE(MAC                = 0x04C4);
PROVIDE(MAC_L              = 0x04C4);
PROVIDE(MAC_H              = 0x04C5);
PROVIDE(MACS               = 0x04C6);
PROVIDE(MACS_L             = 0x04C6);
PROVIDE(MACS_H             = 0x04C7);
PROVIDE(OP2                = 0x04C8);
PROVIDE(OP2_L              = 0x04C8);
PROVIDE(OP2_H              = 0x04C9);
PROVIDE(RESLO              = 0x04CA);
PROVIDE(RESLO_L            = 0x04CA);
PROVIDE(RESLO_H            = 0x04CB);
PROVIDE(RESHI              = 0x04CC);
PROVIDE(RESHI_L            = 0x04CC);
PROVIDE(RESHI_H            = 0x04CD);
PROVIDE(SUMEXT             = 0x04CE);
PROVIDE(SUMEXT_L           = 0x04CE);
PROVIDE(SUMEXT_H           = 0x04CF);
PROVIDE(MPY32L             = 0x04D0);
PROVIDE(MPY32L_L           = 0x04D0);
PROVIDE(MPY32L_H           = 0x04D1);
PROVIDE(MPY32H             = 0x04D2);
PROVIDE(MPY32H_L           = 0x04D2);
PROVIDE(MPY32H_H           = 0x04D3);
PROVIDE(MPYS32L            = 0x04D4);
PROVIDE(MPYS32L_L          = 0x04D4);
PROVIDE(MPYS32L_H          = 0x04D5);
PROVIDE(MPYS32H            = 0x04D6);
PROVIDE(MPYS32H_L          = 0x04D6);
PROVIDE(MPYS32H_H          = 0x04D7);
PROVIDE(MAC32L             = 0x04D8);
PROVIDE(MAC32L_L           = 0x04D8);
PROVIDE(MAC32L_H           = 0x04D9);
PROVIDE(MAC32H             = 0x04DA);
PROVIDE(MAC32H_L           = 0x04DA);
PROVIDE(MAC32H_H           = 0x04DB);
PROVIDE(MACS32L            = 0x04DC);
PROVIDE(MACS32L_L          = 0x04DC);
PROVIDE(MACS32L_H          = 0x04DD);
PROVIDE(MACS32H            = 0x04DE);
PROVIDE(MACS32H_L          = 0x04DE);
PROVIDE(MACS32H_H          = 0x04DF);
PROVIDE(OP2L               = 0x04E0);
PROVIDE(OP2L_L             = 0x04E0);
PROVIDE(OP2L_H             = 0x04E1);
PROVIDE(OP2H               = 0x04E2);
PROVIDE(OP2H_L             = 0x04E2);
PROVIDE(OP2H_H             = 0x04E3);
PROVIDE(RES0               = 0x04E4);
PROVIDE(RES0_L             = 0x04E4);
PROVIDE(RES0_H             = 0x04E5);
PROVIDE(RES1               = 0x04E6);
PROVIDE(RES1_L             = 0x04E6);
PROVIDE(RES1_H             = 0x04E7);
PROVIDE(RES2               = 0x04E8);
PROVIDE(RES2_L             = 0x04E8);
PROVIDE(RES2_H             = 0x04E9);
PROVIDE(RES3               = 0x04EA);
PROVIDE(RES3_L             = 0x04EA);
PROVIDE(RES3_H             = 0x04EB);
PROVIDE(MPY32CTL0          = 0x04EC);
PROVIDE(MPY32CTL0_L        = 0x04EC);
PROVIDE(MPY32CTL0_H        = 0x04ED);


/*****************************************************************************
 MTIF
*****************************************************************************/
PROVIDE(MTIFPGCNF          = 0x0F00);
PROVIDE(MTIFPGCNF_L        = 0x0F00);
PROVIDE(MTIFPGCNF_H        = 0x0F01);
PROVIDE(MTIFPGKVAL         = 0x0F02);
PROVIDE(MTIFPGKVAL_L       = 0x0F02);
PROVIDE(MTIFPGKVAL_H       = 0x0F03);
PROVIDE(MTIFPGCTL          = 0x0F04);
PROVIDE(MTIFPGCTL_L        = 0x0F04);
PROVIDE(MTIFPGCTL_H        = 0x0F05);
PROVIDE(MTIFPGSR           = 0x0F06);
PROVIDE(MTIFPGSR_L         = 0x0F06);
PROVIDE(MTIFPGSR_H         = 0x0F07);
PROVIDE(MTIFPCCNF          = 0x0F08);
PROVIDE(MTIFPCCNF_L        = 0x0F08);
PROVIDE(MTIFPCCNF_H        = 0x0F09);
PROVIDE(MTIFPCR            = 0x0F0A);
PROVIDE(MTIFPCR_L          = 0x0F0A);
PROVIDE(MTIFPCR_H          = 0x0F0B);
PROVIDE(MTIFPCCTL          = 0x0F0C);
PROVIDE(MTIFPCCTL_L        = 0x0F0C);
PROVIDE(MTIFPCCTL_H        = 0x0F0D);
PROVIDE(MTIFPCSR           = 0x0F0E);
PROVIDE(MTIFPCSR_L         = 0x0F0E);
PROVIDE(MTIFPCSR_H         = 0x0F0F);
PROVIDE(MTIFTPCTL          = 0x0F10);
PROVIDE(MTIFTPCTL_L        = 0x0F10);
PROVIDE(MTIFTPCTL_H        = 0x0F11);


/*****************************************************************************
 PMM
*****************************************************************************/
PROVIDE(PMMCTL0            = 0x0120);
PROVIDE(PMMCTL0_L          = 0x0120);
PROVIDE(PMMCTL0_H          = 0x0121);
PROVIDE(PMMIFG             = 0x012A);
PROVIDE(PMMIFG_L           = 0x012A);
PROVIDE(PMMIFG_H           = 0x012B);
PROVIDE(PM5CTL0            = 0x0130);
PROVIDE(PM5CTL0_L          = 0x0130);
PROVIDE(PM5CTL0_H          = 0x0131);


/*****************************************************************************
 RAMCTL
*****************************************************************************/
PROVIDE(RCCTL0             = 0x0158);
PROVIDE(RCCTL0_L           = 0x0158);
PROVIDE(RCCTL0_H           = 0x0159);
PROVIDE(RCCTL1             = 0x015A);
PROVIDE(RCCTL1_L           = 0x015A);
PROVIDE(RCCTL1_H           = 0x015B);


/*****************************************************************************
 REF_A
*****************************************************************************/
PROVIDE(REFCTL0            = 0x01B0);
PROVIDE(REFCTL0_L          = 0x01B0);
PROVIDE(REFCTL0_H          = 0x01B1);


/*****************************************************************************
 RTC_C
*****************************************************************************/
PROVIDE(RTCCTL0            = 0x04A0);
PROVIDE(RTCCTL0_L          = 0x04A0);
PROVIDE(RTCCTL0_H          = 0x04A1);
PROVIDE(RTCCTL13           = 0x04A2);
PROVIDE(RTCCTL13_L         = 0x04A2);
PROVIDE(RTCCTL13_H         = 0x04A3);
PROVIDE(RTCOCAL            = 0x04A4);
PROVIDE(RTCOCAL_L          = 0x04A4);
PROVIDE(RTCOCAL_H          = 0x04A5);
PROVIDE(RTCTCMP            = 0x04A6);
PROVIDE(RTCTCMP_L          = 0x04A6);
PROVIDE(RTCTCMP_H          = 0x04A7);
PROVIDE(RTCPS0CTL          = 0x04A8);
PROVIDE(RTCPS0CTL_L        = 0x04A8);
PROVIDE(RTCPS0CTL_H        = 0x04A9);
PROVIDE(RTCPS1CTL          = 0x04AA);
PROVIDE(RTCPS1CTL_L        = 0x04AA);
PROVIDE(RTCPS1CTL_H        = 0x04AB);
PROVIDE(RTCPS              = 0x04AC);
PROVIDE(RTCPS_L            = 0x04AC);
PROVIDE(RTCPS_H            = 0x04AD);
PROVIDE(RTCIV              = 0x04AE);
PROVIDE(RTCIV_L            = 0x04AE);
PROVIDE(RTCIV_H            = 0x04AF);
PROVIDE(RTCTIM0            = 0x04B0);
PROVIDE(RTCTIM0_L          = 0x04B0);
PROVIDE(RTCTIM0_H          = 0x04B1);
PROVIDE(RTCCNT12           = 0x04B0);
PROVIDE(RTCCNT12_L         = 0x04B0);
PROVIDE(RTCCNT12_H         = 0x04B1);
PROVIDE(RTCTIM1            = 0x04B2);
PROVIDE(RTCTIM1_L          = 0x04B2);
PROVIDE(RTCTIM1_H          = 0x04B3);
PROVIDE(RTCCNT34           = 0x04B2);
PROVIDE(RTCCNT34_L         = 0x04B2);
PROVIDE(RTCCNT34_H         = 0x04B3);
PROVIDE(RTCDATE            = 0x04B4);
PROVIDE(RTCDATE_L          = 0x04B4);
PROVIDE(RTCDATE_H          = 0x04B5);
PROVIDE(RTCYEAR            = 0x04B6);
PROVIDE(RTCYEAR_L          = 0x04B6);
PROVIDE(RTCYEAR_H          = 0x04B7);
PROVIDE(RTCAMINHR          = 0x04B8);
PROVIDE(RTCAMINHR_L        = 0x04B8);
PROVIDE(RTCAMINHR_H        = 0x04B9);
PROVIDE(RTCADOWDAY         = 0x04BA);
PROVIDE(RTCADOWDAY_L       = 0x04BA);
PROVIDE(RTCADOWDAY_H       = 0x04BB);
PROVIDE(BIN2BCD            = 0x04BC);
PROVIDE(BIN2BCD_L          = 0x04BC);
PROVIDE(BIN2BCD_H          = 0x04BD);
PROVIDE(BCD2BIN            = 0x04BE);
PROVIDE(BCD2BIN_L          = 0x04BE);
PROVIDE(BCD2BIN_H          = 0x04BF);
PROVIDE(RT0PS              = 0x04AC);

PROVIDE(RT1PS              = 0x04AD);

PROVIDE(RTCCNT1            = 0x04B0);

PROVIDE(RTCCNT2            = 0x04B1);

PROVIDE(RTCCNT3            = 0x04B2);

PROVIDE(RTCCNT4            = 0x04B3);



/*****************************************************************************
 SAPH_A
*****************************************************************************/
PROVIDE(SAPH_AIIDX         = 0x0E00);
PROVIDE(SAPH_AIIDX_L       = 0x0E00);
PROVIDE(SAPH_AIIDX_H       = 0x0E01);
PROVIDE(SAPH_AMIS          = 0x0E02);
PROVIDE(SAPH_AMIS_L        = 0x0E02);
PROVIDE(SAPH_AMIS_H        = 0x0E03);
PROVIDE(SAPH_ARIS          = 0x0E04);
PROVIDE(SAPH_ARIS_L        = 0x0E04);
PROVIDE(SAPH_ARIS_H        = 0x0E05);
PROVIDE(SAPH_AIMSC         = 0x0E06);
PROVIDE(SAPH_AIMSC_L       = 0x0E06);
PROVIDE(SAPH_AIMSC_H       = 0x0E07);
PROVIDE(SAPH_AICR          = 0x0E08);
PROVIDE(SAPH_AICR_L        = 0x0E08);
PROVIDE(SAPH_AICR_H        = 0x0E09);
PROVIDE(SAPH_AISR          = 0x0E0A);
PROVIDE(SAPH_AISR_L        = 0x0E0A);
PROVIDE(SAPH_AISR_H        = 0x0E0B);
PROVIDE(SAPH_ADESCLO       = 0x0E0C);
PROVIDE(SAPH_ADESCLO_L     = 0x0E0C);
PROVIDE(SAPH_ADESCLO_H     = 0x0E0D);
PROVIDE(SAPH_ADESCHI       = 0x0E0E);
PROVIDE(SAPH_ADESCHI_L     = 0x0E0E);
PROVIDE(SAPH_ADESCHI_H     = 0x0E0F);
PROVIDE(SAPH_AKEY          = 0x0E10);
PROVIDE(SAPH_AKEY_L        = 0x0E10);
PROVIDE(SAPH_AKEY_H        = 0x0E11);
PROVIDE(SAPH_AOCTL0        = 0x0E12);
PROVIDE(SAPH_AOCTL0_L      = 0x0E12);
PROVIDE(SAPH_AOCTL0_H      = 0x0E13);
PROVIDE(SAPH_AOCTL1        = 0x0E14);
PROVIDE(SAPH_AOCTL1_L      = 0x0E14);
PROVIDE(SAPH_AOCTL1_H      = 0x0E15);
PROVIDE(SAPH_AOSEL         = 0x0E16);
PROVIDE(SAPH_AOSEL_L       = 0x0E16);
PROVIDE(SAPH_AOSEL_H       = 0x0E17);
PROVIDE(SAPH_ACH0PUT       = 0x0E20);
PROVIDE(SAPH_ACH0PUT_L     = 0x0E20);
PROVIDE(SAPH_ACH0PUT_H     = 0x0E21);
PROVIDE(SAPH_ACH0PDT       = 0x0E22);
PROVIDE(SAPH_ACH0PDT_L     = 0x0E22);
PROVIDE(SAPH_ACH0PDT_H     = 0x0E23);
PROVIDE(SAPH_ACH0TT        = 0x0E24);
PROVIDE(SAPH_ACH0TT_L      = 0x0E24);
PROVIDE(SAPH_ACH0TT_H      = 0x0E25);
PROVIDE(SAPH_ACH1PUT       = 0x0E26);
PROVIDE(SAPH_ACH1PUT_L     = 0x0E26);
PROVIDE(SAPH_ACH1PUT_H     = 0x0E27);
PROVIDE(SAPH_ACH1PDT       = 0x0E28);
PROVIDE(SAPH_ACH1PDT_L     = 0x0E28);
PROVIDE(SAPH_ACH1PDT_H     = 0x0E29);
PROVIDE(SAPH_ACH1TT        = 0x0E2A);
PROVIDE(SAPH_ACH1TT_L      = 0x0E2A);
PROVIDE(SAPH_ACH1TT_H      = 0x0E2B);
PROVIDE(SAPH_AMCNF         = 0x0E2C);
PROVIDE(SAPH_AMCNF_L       = 0x0E2C);
PROVIDE(SAPH_AMCNF_H       = 0x0E2D);
PROVIDE(SAPH_ATACTL        = 0x0E2E);
PROVIDE(SAPH_ATACTL_L      = 0x0E2E);
PROVIDE(SAPH_ATACTL_H      = 0x0E2F);
PROVIDE(SAPH_AICTL0        = 0x0E30);
PROVIDE(SAPH_AICTL0_L      = 0x0E30);
PROVIDE(SAPH_AICTL0_H      = 0x0E31);
PROVIDE(SAPH_ABCTL         = 0x0E34);
PROVIDE(SAPH_ABCTL_L       = 0x0E34);
PROVIDE(SAPH_ABCTL_H       = 0x0E35);
PROVIDE(SAPH_APGC          = 0x0E40);
PROVIDE(SAPH_APGC_L        = 0x0E40);
PROVIDE(SAPH_APGC_H        = 0x0E41);
PROVIDE(SAPH_APGLPER       = 0x0E42);
PROVIDE(SAPH_APGLPER_L     = 0x0E42);
PROVIDE(SAPH_APGLPER_H     = 0x0E43);
PROVIDE(SAPH_APGHPER       = 0x0E44);
PROVIDE(SAPH_APGHPER_L     = 0x0E44);
PROVIDE(SAPH_APGHPER_H     = 0x0E45);
PROVIDE(SAPH_APGCTL        = 0x0E46);
PROVIDE(SAPH_APGCTL_L      = 0x0E46);
PROVIDE(SAPH_APGCTL_H      = 0x0E47);
PROVIDE(SAPH_APPGTRIG      = 0x0E48);
PROVIDE(SAPH_APPGTRIG_L    = 0x0E48);
PROVIDE(SAPH_APPGTRIG_H    = 0x0E49);
PROVIDE(SAPH_AXPGCTL       = 0x0E4A);
PROVIDE(SAPH_AXPGCTL_L     = 0x0E4A);
PROVIDE(SAPH_AXPGCTL_H     = 0x0E4B);
PROVIDE(SAPH_AXPGLPER      = 0x0E4C);
PROVIDE(SAPH_AXPGLPER_L    = 0x0E4C);
PROVIDE(SAPH_AXPGLPER_H    = 0x0E4D);
PROVIDE(SAPH_AXPGHPER      = 0x0E4E);
PROVIDE(SAPH_AXPGHPER_L    = 0x0E4E);
PROVIDE(SAPH_AXPGHPER_H    = 0x0E4F);
PROVIDE(SAPH_AASCTL0       = 0x0E60);
PROVIDE(SAPH_AASCTL0_L     = 0x0E60);
PROVIDE(SAPH_AASCTL0_H     = 0x0E61);
PROVIDE(SAPH_AASCTL1       = 0x0E62);
PROVIDE(SAPH_AASCTL1_L     = 0x0E62);
PROVIDE(SAPH_AASCTL1_H     = 0x0E63);
PROVIDE(SAPH_AASQTRIG      = 0x0E64);

PROVIDE(SAPH_AAPOL         = 0x0E66);
PROVIDE(SAPH_AAPOL_L       = 0x0E66);
PROVIDE(SAPH_AAPOL_H       = 0x0E67);
PROVIDE(SAPH_AAPLEV        = 0x0E68);
PROVIDE(SAPH_AAPLEV_L      = 0x0E68);
PROVIDE(SAPH_AAPLEV_H      = 0x0E69);
PROVIDE(SAPH_AAPHIZ        = 0x0E6A);
PROVIDE(SAPH_AAPHIZ_L      = 0x0E6A);
PROVIDE(SAPH_AAPHIZ_H      = 0x0E6B);
PROVIDE(SAPH_AATM_A        = 0x0E6E);
PROVIDE(SAPH_AATM_A_L      = 0x0E6E);
PROVIDE(SAPH_AATM_A_H      = 0x0E6F);
PROVIDE(SAPH_AATM_B        = 0x0E70);
PROVIDE(SAPH_AATM_B_L      = 0x0E70);
PROVIDE(SAPH_AATM_B_H      = 0x0E71);
PROVIDE(SAPH_AATM_C        = 0x0E72);
PROVIDE(SAPH_AATM_C_L      = 0x0E72);
PROVIDE(SAPH_AATM_C_H      = 0x0E73);
PROVIDE(SAPH_AATM_D        = 0x0E74);
PROVIDE(SAPH_AATM_D_L      = 0x0E74);
PROVIDE(SAPH_AATM_D_H      = 0x0E75);
PROVIDE(SAPH_AATM_E        = 0x0E76);
PROVIDE(SAPH_AATM_E_L      = 0x0E76);
PROVIDE(SAPH_AATM_E_H      = 0x0E77);
PROVIDE(SAPH_AATM_F        = 0x0E78);
PROVIDE(SAPH_AATM_F_L      = 0x0E78);
PROVIDE(SAPH_AATM_F_H      = 0x0E79);
PROVIDE(SAPH_ATBCTL        = 0x0E7A);
PROVIDE(SAPH_ATBCTL_L      = 0x0E7A);
PROVIDE(SAPH_ATBCTL_H      = 0x0E7B);
PROVIDE(SAPH_AATIMLO       = 0x0E7C);
PROVIDE(SAPH_AATIMLO_L     = 0x0E7C);
PROVIDE(SAPH_AATIMLO_H     = 0x0E7D);
PROVIDE(SAPH_AATIMHI       = 0x0E7E);
PROVIDE(SAPH_AATIMHI_L     = 0x0E7E);
PROVIDE(SAPH_AATIMHI_H     = 0x0E7F);


/*****************************************************************************
 SDHS
*****************************************************************************/
PROVIDE(SDHSIIDX           = 0x0E80);
PROVIDE(SDHSIIDX_L         = 0x0E80);
PROVIDE(SDHSIIDX_H         = 0x0E81);
PROVIDE(SDHSMIS            = 0x0E82);
PROVIDE(SDHSMIS_L          = 0x0E82);
PROVIDE(SDHSMIS_H          = 0x0E83);
PROVIDE(SDHSRIS            = 0x0E84);
PROVIDE(SDHSRIS_L          = 0x0E84);
PROVIDE(SDHSRIS_H          = 0x0E85);
PROVIDE(SDHSIMSC           = 0x0E86);
PROVIDE(SDHSIMSC_L         = 0x0E86);
PROVIDE(SDHSIMSC_H         = 0x0E87);
PROVIDE(SDHSICR            = 0x0E88);
PROVIDE(SDHSICR_L          = 0x0E88);
PROVIDE(SDHSICR_H          = 0x0E89);
PROVIDE(SDHSISR            = 0x0E8A);
PROVIDE(SDHSISR_L          = 0x0E8A);
PROVIDE(SDHSISR_H          = 0x0E8B);
PROVIDE(SDHSDESCLO         = 0x0E8C);
PROVIDE(SDHSDESCLO_L       = 0x0E8C);
PROVIDE(SDHSDESCLO_H       = 0x0E8D);
PROVIDE(SDHSDESCHI         = 0x0E8E);
PROVIDE(SDHSDESCHI_L       = 0x0E8E);
PROVIDE(SDHSDESCHI_H       = 0x0E8F);
PROVIDE(SDHSCTL0           = 0x0E90);
PROVIDE(SDHSCTL0_L         = 0x0E90);
PROVIDE(SDHSCTL0_H         = 0x0E91);
PROVIDE(SDHSCTL1           = 0x0E92);
PROVIDE(SDHSCTL1_L         = 0x0E92);
PROVIDE(SDHSCTL1_H         = 0x0E93);
PROVIDE(SDHSCTL2           = 0x0E94);
PROVIDE(SDHSCTL2_L         = 0x0E94);
PROVIDE(SDHSCTL2_H         = 0x0E95);
PROVIDE(SDHSCTL3           = 0x0E96);
PROVIDE(SDHSCTL3_L         = 0x0E96);
PROVIDE(SDHSCTL3_H         = 0x0E97);
PROVIDE(SDHSCTL4           = 0x0E98);
PROVIDE(SDHSCTL4_L         = 0x0E98);
PROVIDE(SDHSCTL4_H         = 0x0E99);
PROVIDE(SDHSCTL5           = 0x0E9A);
PROVIDE(SDHSCTL5_L         = 0x0E9A);
PROVIDE(SDHSCTL5_H         = 0x0E9B);
PROVIDE(SDHSCTL6           = 0x0E9C);
PROVIDE(SDHSCTL6_L         = 0x0E9C);
PROVIDE(SDHSCTL6_H         = 0x0E9D);
PROVIDE(SDHSCTL7           = 0x0E9E);
PROVIDE(SDHSCTL7_L         = 0x0E9E);
PROVIDE(SDHSCTL7_H         = 0x0E9F);
PROVIDE(SDHSDT             = 0x0EA2);
PROVIDE(SDHSDT_L           = 0x0EA2);
PROVIDE(SDHSDT_H           = 0x0EA3);
PROVIDE(SDHSWINHITH        = 0x0EA4);
PROVIDE(SDHSWINHITH_L      = 0x0EA4);
PROVIDE(SDHSWINHITH_H      = 0x0EA5);
PROVIDE(SDHSWINLOTH        = 0x0EA6);
PROVIDE(SDHSWINLOTH_L      = 0x0EA6);
PROVIDE(SDHSWINLOTH_H      = 0x0EA7);
PROVIDE(SDHSDTCDA          = 0x0EA8);
PROVIDE(SDHSDTCDA_L        = 0x0EA8);
PROVIDE(SDHSDTCDA_H        = 0x0EA9);


/*****************************************************************************
 SFR
*****************************************************************************/
PROVIDE(SFRIE1             = 0x0100);
PROVIDE(SFRIE1_L           = 0x0100);
PROVIDE(SFRIE1_H           = 0x0101);
PROVIDE(SFRIFG1            = 0x0102);
PROVIDE(SFRIFG1_L          = 0x0102);
PROVIDE(SFRIFG1_H          = 0x0103);
PROVIDE(SFRRPCR            = 0x0104);
PROVIDE(SFRRPCR_L          = 0x0104);
PROVIDE(SFRRPCR_H          = 0x0105);


/*****************************************************************************
 SYS
*****************************************************************************/
PROVIDE(SYSCTL             = 0x0180);
PROVIDE(SYSCTL_L           = 0x0180);
PROVIDE(SYSCTL_H           = 0x0181);
PROVIDE(SYSJMBC            = 0x0186);
PROVIDE(SYSJMBC_L          = 0x0186);
PROVIDE(SYSJMBC_H          = 0x0187);
PROVIDE(SYSJMBI0           = 0x0188);
PROVIDE(SYSJMBI0_L         = 0x0188);
PROVIDE(SYSJMBI0_H         = 0x0189);
PROVIDE(SYSJMBI1           = 0x018A);
PROVIDE(SYSJMBI1_L         = 0x018A);
PROVIDE(SYSJMBI1_H         = 0x018B);
PROVIDE(SYSJMBO0           = 0x018C);
PROVIDE(SYSJMBO0_L         = 0x018C);
PROVIDE(SYSJMBO0_H         = 0x018D);
PROVIDE(SYSJMBO1           = 0x018E);
PROVIDE(SYSJMBO1_L         = 0x018E);
PROVIDE(SYSJMBO1_H         = 0x018F);
PROVIDE(SYSUNIV            = 0x019A);
PROVIDE(SYSUNIV_L          = 0x019A);
PROVIDE(SYSUNIV_H          = 0x019B);
PROVIDE(SYSSNIV            = 0x019C);
PROVIDE(SYSSNIV_L          = 0x019C);
PROVIDE(SYSSNIV_H          = 0x019D);
PROVIDE(SYSRSTIV           = 0x019E);
PROVIDE(SYSRSTIV_L         = 0x019E);
PROVIDE(SYSRSTIV_H         = 0x019F);


/*****************************************************************************
 TA0
*****************************************************************************/
PROVIDE(TA0CTL             = 0x0340);
PROVIDE(TA0CTL_L           = 0x0340);
PROVIDE(TA0CTL_H           = 0x0341);
PROVIDE(TA0CCTL0           = 0x0342);
PROVIDE(TA0CCTL0_L         = 0x0342);
PROVIDE(TA0CCTL0_H         = 0x0343);
PROVIDE(TA0CCTL1           = 0x0344);
PROVIDE(TA0CCTL1_L         = 0x0344);
PROVIDE(TA0CCTL1_H         = 0x0345);
PROVIDE(TA0CCTL2           = 0x0346);
PROVIDE(TA0CCTL2_L         = 0x0346);
PROVIDE(TA0CCTL2_H         = 0x0347);
PROVIDE(TA0R               = 0x0350);
PROVIDE(TA0R_L             = 0x0350);
PROVIDE(TA0R_H             = 0x0351);
PROVIDE(TA0CCR0            = 0x0352);
PROVIDE(TA0CCR0_L          = 0x0352);
PROVIDE(TA0CCR0_H          = 0x0353);
PROVIDE(TA0CCR1            = 0x0354);
PROVIDE(TA0CCR1_L          = 0x0354);
PROVIDE(TA0CCR1_H          = 0x0355);
PROVIDE(TA0CCR2            = 0x0356);
PROVIDE(TA0CCR2_L          = 0x0356);
PROVIDE(TA0CCR2_H          = 0x0357);
PROVIDE(TA0EX0             = 0x0360);
PROVIDE(TA0EX0_L           = 0x0360);
PROVIDE(TA0EX0_H           = 0x0361);
PROVIDE(TA0IV              = 0x036E);
PROVIDE(TA0IV_L            = 0x036E);
PROVIDE(TA0IV_H            = 0x036F);


/*****************************************************************************
 TA1
*****************************************************************************/
PROVIDE(TA1CTL             = 0x0380);
PROVIDE(TA1CTL_L           = 0x0380);
PROVIDE(TA1CTL_H           = 0x0381);
PROVIDE(TA1CCTL0           = 0x0382);
PROVIDE(TA1CCTL0_L         = 0x0382);
PROVIDE(TA1CCTL0_H         = 0x0383);
PROVIDE(TA1CCTL1           = 0x0384);
PROVIDE(TA1CCTL1_L         = 0x0384);
PROVIDE(TA1CCTL1_H         = 0x0385);
PROVIDE(TA1CCTL2           = 0x0386);
PROVIDE(TA1CCTL2_L         = 0x0386);
PROVIDE(TA1CCTL2_H         = 0x0387);
PROVIDE(TA1R               = 0x0390);
PROVIDE(TA1R_L             = 0x0390);
PROVIDE(TA1R_H             = 0x0391);
PROVIDE(TA1CCR0            = 0x0392);
PROVIDE(TA1CCR0_L          = 0x0392);
PROVIDE(TA1CCR0_H          = 0x0393);
PROVIDE(TA1CCR1            = 0x0394);
PROVIDE(TA1CCR1_L          = 0x0394);
PROVIDE(TA1CCR1_H          = 0x0395);
PROVIDE(TA1CCR2            = 0x0396);
PROVIDE(TA1CCR2_L          = 0x0396);
PROVIDE(TA1CCR2_H          = 0x0397);
PROVIDE(TA1EX0             = 0x03A0);
PROVIDE(TA1EX0_L           = 0x03A0);
PROVIDE(TA1EX0_H           = 0x03A1);
PROVIDE(TA1IV              = 0x03AE);
PROVIDE(TA1IV_L            = 0x03AE);
PROVIDE(TA1IV_H            = 0x03AF);


/*****************************************************************************
 TA2
*****************************************************************************/
PROVIDE(TA2CTL             = 0x0400);
PROVIDE(TA2CTL_L           = 0x0400);
PROVIDE(TA2CTL_H           = 0x0401);
PROVIDE(TA2CCTL0           = 0x0402);
PROVIDE(TA2CCTL0_L         = 0x0402);
PROVIDE(TA2CCTL0_H         = 0x0403);
PROVIDE(TA2CCTL1           = 0x0404);
PROVIDE(TA2CCTL1_L         = 0x0404);
PROVIDE(TA2CCTL1_H         = 0x0405);
PROVIDE(TA2R               = 0x0410);
PROVIDE(TA2R_L             = 0x0410);
PROVIDE(TA2R_H             = 0x0411);
PROVIDE(TA2CCR0            = 0x0412);
PROVIDE(TA2CCR0_L          = 0x0412);
PROVIDE(TA2CCR0_H          = 0x0413);
PROVIDE(TA2CCR1            = 0x0414);
PROVIDE(TA2CCR1_L          = 0x0414);
PROVIDE(TA2CCR1_H          = 0x0415);
PROVIDE(TA2EX0             = 0x0420);
PROVIDE(TA2EX0_L           = 0x0420);
PROVIDE(TA2EX0_H           = 0x0421);
PROVIDE(TA2IV              = 0x042E);
PROVIDE(TA2IV_L            = 0x042E);
PROVIDE(TA2IV_H            = 0x042F);


/*****************************************************************************
 TA3
*****************************************************************************/
PROVIDE(TA3CTL             = 0x0440);
PROVIDE(TA3CTL_L           = 0x0440);
PROVIDE(TA3CTL_H           = 0x0441);
PROVIDE(TA3CCTL0           = 0x0442);
PROVIDE(TA3CCTL0_L         = 0x0442);
PROVIDE(TA3CCTL0_H         = 0x0443);
PROVIDE(TA3CCTL1           = 0x0444);
PROVIDE(TA3CCTL1_L         = 0x0444);
PROVIDE(TA3CCTL1_H         = 0x0445);
PROVIDE(TA3R               = 0x0450);
PROVIDE(TA3R_L             = 0x0450);
PROVIDE(TA3R_H             = 0x0451);
PROVIDE(TA3CCR0            = 0x0452);
PROVIDE(TA3CCR0_L          = 0x0452);
PROVIDE(TA3CCR0_H          = 0x0453);
PROVIDE(TA3CCR1            = 0x0454);
PROVIDE(TA3CCR1_L          = 0x0454);
PROVIDE(TA3CCR1_H          = 0x0455);
PROVIDE(TA3EX0             = 0x0460);
PROVIDE(TA3EX0_L           = 0x0460);
PROVIDE(TA3EX0_H           = 0x0461);
PROVIDE(TA3IV              = 0x046E);
PROVIDE(TA3IV_L            = 0x046E);
PROVIDE(TA3IV_H            = 0x046F);


/*****************************************************************************
 TA4
*****************************************************************************/
PROVIDE(TA4CTL             = 0x07C0);
PROVIDE(TA4CTL_L           = 0x07C0);
PROVIDE(TA4CTL_H           = 0x07C1);
PROVIDE(TA4CCTL0           = 0x07C2);
PROVIDE(TA4CCTL0_L         = 0x07C2);
PROVIDE(TA4CCTL0_H         = 0x07C3);
PROVIDE(TA4CCTL1           = 0x07C4);
PROVIDE(TA4CCTL1_L         = 0x07C4);
PROVIDE(TA4CCTL1_H         = 0x07C5);
PROVIDE(TA4R               = 0x07D0);
PROVIDE(TA4R_L             = 0x07D0);
PROVIDE(TA4R_H             = 0x07D1);
PROVIDE(TA4CCR0            = 0x07D2);
PROVIDE(TA4CCR0_L          = 0x07D2);
PROVIDE(TA4CCR0_H          = 0x07D3);
PROVIDE(TA4CCR1            = 0x07D4);
PROVIDE(TA4CCR1_L          = 0x07D4);
PROVIDE(TA4CCR1_H          = 0x07D5);
PROVIDE(TA4EX0             = 0x07E0);
PROVIDE(TA4EX0_L           = 0x07E0);
PROVIDE(TA4EX0_H           = 0x07E1);
PROVIDE(TA4IV              = 0x07EE);
PROVIDE(TA4IV_L            = 0x07EE);
PROVIDE(TA4IV_H            = 0x07EF);


/*****************************************************************************
 TB0
*****************************************************************************/
PROVIDE(TB0CTL             = 0x03C0);
PROVIDE(TB0CTL_L           = 0x03C0);
PROVIDE(TB0CTL_H           = 0x03C1);
PROVIDE(TB0CCTL0           = 0x03C2);
PROVIDE(TB0CCTL0_L         = 0x03C2);
PROVIDE(TB0CCTL0_H         = 0x03C3);
PROVIDE(TB0CCTL1           = 0x03C4);
PROVIDE(TB0CCTL1_L         = 0x03C4);
PROVIDE(TB0CCTL1_H         = 0x03C5);
PROVIDE(TB0CCTL2           = 0x03C6);
PROVIDE(TB0CCTL2_L         = 0x03C6);
PROVIDE(TB0CCTL2_H         = 0x03C7);
PROVIDE(TB0CCTL3           = 0x03C8);
PROVIDE(TB0CCTL3_L         = 0x03C8);
PROVIDE(TB0CCTL3_H         = 0x03C9);
PROVIDE(TB0CCTL4           = 0x03CA);
PROVIDE(TB0CCTL4_L         = 0x03CA);
PROVIDE(TB0CCTL4_H         = 0x03CB);
PROVIDE(TB0CCTL5           = 0x03CC);
PROVIDE(TB0CCTL5_L         = 0x03CC);
PROVIDE(TB0CCTL5_H         = 0x03CD);
PROVIDE(TB0CCTL6           = 0x03CE);
PROVIDE(TB0CCTL6_L         = 0x03CE);
PROVIDE(TB0CCTL6_H         = 0x03CF);
PROVIDE(TB0R               = 0x03D0);
PROVIDE(TB0R_L             = 0x03D0);
PROVIDE(TB0R_H             = 0x03D1);
PROVIDE(TB0CCR0            = 0x03D2);
PROVIDE(TB0CCR0_L          = 0x03D2);
PROVIDE(TB0CCR0_H          = 0x03D3);
PROVIDE(TB0CCR1            = 0x03D4);
PROVIDE(TB0CCR1_L          = 0x03D4);
PROVIDE(TB0CCR1_H          = 0x03D5);
PROVIDE(TB0CCR2            = 0x03D6);
PROVIDE(TB0CCR2_L          = 0x03D6);
PROVIDE(TB0CCR2_H          = 0x03D7);
PROVIDE(TB0CCR3            = 0x03D8);
PROVIDE(TB0CCR3_L          = 0x03D8);
PROVIDE(TB0CCR3_H          = 0x03D9);
PROVIDE(TB0CCR4            = 0x03DA);
PROVIDE(TB0CCR4_L          = 0x03DA);
PROVIDE(TB0CCR4_H          = 0x03DB);
PROVIDE(TB0CCR5            = 0x03DC);
PROVIDE(TB0CCR5_L          = 0x03DC);
PROVIDE(TB0CCR5_H          = 0x03DD);
PROVIDE(TB0CCR6            = 0x03DE);
PROVIDE(TB0CCR6_L          = 0x03DE);
PROVIDE(TB0CCR6_H          = 0x03DF);
PROVIDE(TB0EX0             = 0x03E0);
PROVIDE(TB0EX0_L           = 0x03E0);
PROVIDE(TB0EX0_H           = 0x03E1);
PROVIDE(TB0IV              = 0x03EE);
PROVIDE(TB0IV_L            = 0x03EE);
PROVIDE(TB0IV_H            = 0x03EF);


/*****************************************************************************
 UUPS
*****************************************************************************/
PROVIDE(UUPSIIDX           = 0x0EC0);
PROVIDE(UUPSIIDX_L         = 0x0EC0);
PROVIDE(UUPSIIDX_H         = 0x0EC1);
PROVIDE(UUPSMIS            = 0x0EC2);
PROVIDE(UUPSMIS_L          = 0x0EC2);
PROVIDE(UUPSMIS_H          = 0x0EC3);
PROVIDE(UUPSRIS            = 0x0EC4);
PROVIDE(UUPSRIS_L          = 0x0EC4);
PROVIDE(UUPSRIS_H          = 0x0EC5);
PROVIDE(UUPSIMSC           = 0x0EC6);
PROVIDE(UUPSIMSC_L         = 0x0EC6);
PROVIDE(UUPSIMSC_H         = 0x0EC7);
PROVIDE(UUPSICR            = 0x0EC8);
PROVIDE(UUPSICR_L          = 0x0EC8);
PROVIDE(UUPSICR_H          = 0x0EC9);
PROVIDE(UUPSISR            = 0x0ECA);
PROVIDE(UUPSISR_L          = 0x0ECA);
PROVIDE(UUPSISR_H          = 0x0ECB);
PROVIDE(UUPSDESCLO         = 0x0ECC);
PROVIDE(UUPSDESCLO_L       = 0x0ECC);
PROVIDE(UUPSDESCLO_H       = 0x0ECD);
PROVIDE(UUPSDESCHI         = 0x0ECE);
PROVIDE(UUPSDESCHI_L       = 0x0ECE);
PROVIDE(UUPSDESCHI_H       = 0x0ECF);
PROVIDE(UUPSCTL            = 0x0ED0);
PROVIDE(UUPSCTL_L          = 0x0ED0);
PROVIDE(UUPSCTL_H          = 0x0ED1);


/*****************************************************************************
 WDT_A
*****************************************************************************/
PROVIDE(WDTCTL             = 0x015C);
PROVIDE(WDTCTL_L           = 0x015C);
PROVIDE(WDTCTL_H           = 0x015D);


/*****************************************************************************
 eUSCI_A0
*****************************************************************************/
PROVIDE(UCA0CTLW0          = 0x05C0);
PROVIDE(UCA0CTLW0_L        = 0x05C0);
PROVIDE(UCA0CTLW0_H        = 0x05C1);
PROVIDE(UCA0CTLW1          = 0x05C2);
PROVIDE(UCA0CTLW1_L        = 0x05C2);
PROVIDE(UCA0CTLW1_H        = 0x05C3);
PROVIDE(UCA0BRW            = 0x05C6);
PROVIDE(UCA0BRW_L          = 0x05C6);
PROVIDE(UCA0BRW_H          = 0x05C7);
PROVIDE(UCA0MCTLW          = 0x05C8);
PROVIDE(UCA0MCTLW_L        = 0x05C8);
PROVIDE(UCA0MCTLW_H        = 0x05C9);
PROVIDE(UCA0STATW          = 0x05CA);
PROVIDE(UCA0STATW_L        = 0x05CA);
PROVIDE(UCA0STATW_H        = 0x05CB);
PROVIDE(UCA0RXBUF          = 0x05CC);
PROVIDE(UCA0RXBUF_L        = 0x05CC);
PROVIDE(UCA0RXBUF_H        = 0x05CD);
PROVIDE(UCA0TXBUF          = 0x05CE);
PROVIDE(UCA0TXBUF_L        = 0x05CE);
PROVIDE(UCA0TXBUF_H        = 0x05CF);
PROVIDE(UCA0ABCTL          = 0x05D0);
PROVIDE(UCA0ABCTL_L        = 0x05D0);
PROVIDE(UCA0ABCTL_H        = 0x05D1);
PROVIDE(UCA0IRCTL          = 0x05D2);
PROVIDE(UCA0IRCTL_L        = 0x05D2);
PROVIDE(UCA0IRCTL_H        = 0x05D3);
PROVIDE(UCA0IE             = 0x05DA);
PROVIDE(UCA0IE_L           = 0x05DA);
PROVIDE(UCA0IE_H           = 0x05DB);
PROVIDE(UCA0IFG            = 0x05DC);
PROVIDE(UCA0IFG_L          = 0x05DC);
PROVIDE(UCA0IFG_H          = 0x05DD);
PROVIDE(UCA0IV             = 0x05DE);
PROVIDE(UCA0IV_L           = 0x05DE);
PROVIDE(UCA0IV_H           = 0x05DF);


/*****************************************************************************
 eUSCI_A1
*****************************************************************************/
PROVIDE(UCA1CTLW0          = 0x05E0);
PROVIDE(UCA1CTLW0_L        = 0x05E0);
PROVIDE(UCA1CTLW0_H        = 0x05E1);
PROVIDE(UCA1CTLW1          = 0x05E2);
PROVIDE(UCA1CTLW1_L        = 0x05E2);
PROVIDE(UCA1CTLW1_H        = 0x05E3);
PROVIDE(UCA1BRW            = 0x05E6);
PROVIDE(UCA1BRW_L          = 0x05E6);
PROVIDE(UCA1BRW_H          = 0x05E7);
PROVIDE(UCA1MCTLW          = 0x05E8);
PROVIDE(UCA1MCTLW_L        = 0x05E8);
PROVIDE(UCA1MCTLW_H        = 0x05E9);
PROVIDE(UCA1STATW          = 0x05EA);
PROVIDE(UCA1STATW_L        = 0x05EA);
PROVIDE(UCA1STATW_H        = 0x05EB);
PROVIDE(UCA1RXBUF          = 0x05EC);
PROVIDE(UCA1RXBUF_L        = 0x05EC);
PROVIDE(UCA1RXBUF_H        = 0x05ED);
PROVIDE(UCA1TXBUF          = 0x05EE);
PROVIDE(UCA1TXBUF_L        = 0x05EE);
PROVIDE(UCA1TXBUF_H        = 0x05EF);
PROVIDE(UCA1ABCTL          = 0x05F0);
PROVIDE(UCA1ABCTL_L        = 0x05F0);
PROVIDE(UCA1ABCTL_H        = 0x05F1);
PROVIDE(UCA1IRCTL          = 0x05F2);
PROVIDE(UCA1IRCTL_L        = 0x05F2);
PROVIDE(UCA1IRCTL_H        = 0x05F3);
PROVIDE(UCA1IE             = 0x05FA);
PROVIDE(UCA1IE_L           = 0x05FA);
PROVIDE(UCA1IE_H           = 0x05FB);
PROVIDE(UCA1IFG            = 0x05FC);
PROVIDE(UCA1IFG_L          = 0x05FC);
PROVIDE(UCA1IFG_H          = 0x05FD);
PROVIDE(UCA1IV             = 0x05FE);
PROVIDE(UCA1IV_L           = 0x05FE);
PROVIDE(UCA1IV_H           = 0x05FF);


/*****************************************************************************
 eUSCI_A2
*****************************************************************************/
PROVIDE(UCA2CTLW0          = 0x0600);
PROVIDE(UCA2CTLW0_L        = 0x0600);
PROVIDE(UCA2CTLW0_H        = 0x0601);
PROVIDE(UCA2CTLW1          = 0x0602);
PROVIDE(UCA2CTLW1_L        = 0x0602);
PROVIDE(UCA2CTLW1_H        = 0x0603);
PROVIDE(UCA2BRW            = 0x0606);
PROVIDE(UCA2BRW_L          = 0x0606);
PROVIDE(UCA2BRW_H          = 0x0607);
PROVIDE(UCA2MCTLW          = 0x0608);
PROVIDE(UCA2MCTLW_L        = 0x0608);
PROVIDE(UCA2MCTLW_H        = 0x0609);
PROVIDE(UCA2STATW          = 0x060A);
PROVIDE(UCA2STATW_L        = 0x060A);
PROVIDE(UCA2STATW_H        = 0x060B);
PROVIDE(UCA2RXBUF          = 0x060C);
PROVIDE(UCA2RXBUF_L        = 0x060C);
PROVIDE(UCA2RXBUF_H        = 0x060D);
PROVIDE(UCA2TXBUF          = 0x060E);
PROVIDE(UCA2TXBUF_L        = 0x060E);
PROVIDE(UCA2TXBUF_H        = 0x060F);
PROVIDE(UCA2ABCTL          = 0x0610);
PROVIDE(UCA2ABCTL_L        = 0x0610);
PROVIDE(UCA2ABCTL_H        = 0x0611);
PROVIDE(UCA2IRCTL          = 0x0612);
PROVIDE(UCA2IRCTL_L        = 0x0612);
PROVIDE(UCA2IRCTL_H        = 0x0613);
PROVIDE(UCA2IE             = 0x061A);
PROVIDE(UCA2IE_L           = 0x061A);
PROVIDE(UCA2IE_H           = 0x061B);
PROVIDE(UCA2IFG            = 0x061C);
PROVIDE(UCA2IFG_L          = 0x061C);
PROVIDE(UCA2IFG_H          = 0x061D);
PROVIDE(UCA2IV             = 0x061E);
PROVIDE(UCA2IV_L           = 0x061E);
PROVIDE(UCA2IV_H           = 0x061F);


/*****************************************************************************
 eUSCI_A3
*****************************************************************************/
PROVIDE(UCA3CTLW0          = 0x0620);
PROVIDE(UCA3CTLW0_L        = 0x0620);
PROVIDE(UCA3CTLW0_H        = 0x0621);
PROVIDE(UCA3CTLW1          = 0x0622);
PROVIDE(UCA3CTLW1_L        = 0x0622);
PROVIDE(UCA3CTLW1_H        = 0x0623);
PROVIDE(UCA3BRW            = 0x0626);
PROVIDE(UCA3BRW_L          = 0x0626);
PROVIDE(UCA3BRW_H          = 0x0627);
PROVIDE(UCA3MCTLW          = 0x0628);
PROVIDE(UCA3MCTLW_L        = 0x0628);
PROVIDE(UCA3MCTLW_H        = 0x0629);
PROVIDE(UCA3STATW          = 0x062A);
PROVIDE(UCA3STATW_L        = 0x062A);
PROVIDE(UCA3STATW_H        = 0x062B);
PROVIDE(UCA3RXBUF          = 0x062C);
PROVIDE(UCA3RXBUF_L        = 0x062C);
PROVIDE(UCA3RXBUF_H        = 0x062D);
PROVIDE(UCA3TXBUF          = 0x062E);
PROVIDE(UCA3TXBUF_L        = 0x062E);
PROVIDE(UCA3TXBUF_H        = 0x062F);
PROVIDE(UCA3ABCTL          = 0x0630);
PROVIDE(UCA3ABCTL_L        = 0x0630);
PROVIDE(UCA3ABCTL_H        = 0x0631);
PROVIDE(UCA3IRCTL          = 0x0632);
PROVIDE(UCA3IRCTL_L        = 0x0632);
PROVIDE(UCA3IRCTL_H        = 0x0633);
PROVIDE(UCA3IE             = 0x063A);
PROVIDE(UCA3IE_L           = 0x063A);
PROVIDE(UCA3IE_H           = 0x063B);
PROVIDE(UCA3IFG            = 0x063C);
PROVIDE(UCA3IFG_L          = 0x063C);
PROVIDE(UCA3IFG_H          = 0x063D);
PROVIDE(UCA3IV             = 0x063E);
PROVIDE(UCA3IV_L           = 0x063E);
PROVIDE(UCA3IV_H           = 0x063F);


/*****************************************************************************
 eUSCI_B0
*****************************************************************************/
PROVIDE(UCB0CTLW0          = 0x0640);
PROVIDE(UCB0CTLW0_L        = 0x0640);
PROVIDE(UCB0CTLW0_H        = 0x0641);
PROVIDE(UCB0CTLW1          = 0x0642);
PROVIDE(UCB0CTLW1_L        = 0x0642);
PROVIDE(UCB0CTLW1_H        = 0x0643);
PROVIDE(UCB0BRW            = 0x0646);
PROVIDE(UCB0BRW_L          = 0x0646);
PROVIDE(UCB0BRW_H          = 0x0647);
PROVIDE(UCB0STATW          = 0x0648);
PROVIDE(UCB0STATW_L        = 0x0648);
PROVIDE(UCB0STATW_H        = 0x0649);
PROVIDE(UCB0TBCNT          = 0x064A);
PROVIDE(UCB0TBCNT_L        = 0x064A);
PROVIDE(UCB0TBCNT_H        = 0x064B);
PROVIDE(UCB0RXBUF          = 0x064C);
PROVIDE(UCB0RXBUF_L        = 0x064C);
PROVIDE(UCB0RXBUF_H        = 0x064D);
PROVIDE(UCB0TXBUF          = 0x064E);
PROVIDE(UCB0TXBUF_L        = 0x064E);
PROVIDE(UCB0TXBUF_H        = 0x064F);
PROVIDE(UCB0I2COA0         = 0x0654);
PROVIDE(UCB0I2COA0_L       = 0x0654);
PROVIDE(UCB0I2COA0_H       = 0x0655);
PROVIDE(UCB0I2COA1         = 0x0656);
PROVIDE(UCB0I2COA1_L       = 0x0656);
PROVIDE(UCB0I2COA1_H       = 0x0657);
PROVIDE(UCB0I2COA2         = 0x0658);
PROVIDE(UCB0I2COA2_L       = 0x0658);
PROVIDE(UCB0I2COA2_H       = 0x0659);
PROVIDE(UCB0I2COA3         = 0x065A);
PROVIDE(UCB0I2COA3_L       = 0x065A);
PROVIDE(UCB0I2COA3_H       = 0x065B);
PROVIDE(UCB0ADDRX          = 0x065C);
PROVIDE(UCB0ADDRX_L        = 0x065C);
PROVIDE(UCB0ADDRX_H        = 0x065D);
PROVIDE(UCB0ADDMASK        = 0x065E);
PROVIDE(UCB0ADDMASK_L      = 0x065E);
PROVIDE(UCB0ADDMASK_H      = 0x065F);
PROVIDE(UCB0I2CSA          = 0x0660);
PROVIDE(UCB0I2CSA_L        = 0x0660);
PROVIDE(UCB0I2CSA_H        = 0x0661);
PROVIDE(UCB0IE             = 0x066A);
PROVIDE(UCB0IE_L           = 0x066A);
PROVIDE(UCB0IE_H           = 0x066B);
PROVIDE(UCB0IFG            = 0x066C);
PROVIDE(UCB0IFG_L          = 0x066C);
PROVIDE(UCB0IFG_H          = 0x066D);
PROVIDE(UCB0IV             = 0x066E);
PROVIDE(UCB0IV_L           = 0x066E);
PROVIDE(UCB0IV_H           = 0x066F);


/*****************************************************************************
 eUSCI_B1
*****************************************************************************/
PROVIDE(UCB1CTLW0          = 0x0680);
PROVIDE(UCB1CTLW0_L        = 0x0680);
PROVIDE(UCB1CTLW0_H        = 0x0681);
PROVIDE(UCB1CTLW1          = 0x0682);
PROVIDE(UCB1CTLW1_L        = 0x0682);
PROVIDE(UCB1CTLW1_H        = 0x0683);
PROVIDE(UCB1BRW            = 0x0686);
PROVIDE(UCB1BRW_L          = 0x0686);
PROVIDE(UCB1BRW_H          = 0x0687);
PROVIDE(UCB1STATW          = 0x0688);
PROVIDE(UCB1STATW_L        = 0x0688);
PROVIDE(UCB1STATW_H        = 0x0689);
PROVIDE(UCB1TBCNT          = 0x068A);
PROVIDE(UCB1TBCNT_L        = 0x068A);
PROVIDE(UCB1TBCNT_H        = 0x068B);
PROVIDE(UCB1RXBUF          = 0x068C);
PROVIDE(UCB1RXBUF_L        = 0x068C);
PROVIDE(UCB1RXBUF_H        = 0x068D);
PROVIDE(UCB1TXBUF          = 0x068E);
PROVIDE(UCB1TXBUF_L        = 0x068E);
PROVIDE(UCB1TXBUF_H        = 0x068F);
PROVIDE(UCB1I2COA0         = 0x0694);
PROVIDE(UCB1I2COA0_L       = 0x0694);
PROVIDE(UCB1I2COA0_H       = 0x0695);
PROVIDE(UCB1I2COA1         = 0x0696);
PROVIDE(UCB1I2COA1_L       = 0x0696);
PROVIDE(UCB1I2COA1_H       = 0x0697);
PROVIDE(UCB1I2COA2         = 0x0698);
PROVIDE(UCB1I2COA2_L       = 0x0698);
PROVIDE(UCB1I2COA2_H       = 0x0699);
PROVIDE(UCB1I2COA3         = 0x069A);
PROVIDE(UCB1I2COA3_L       = 0x069A);
PROVIDE(UCB1I2COA3_H       = 0x069B);
PROVIDE(UCB1ADDRX          = 0x069C);
PROVIDE(UCB1ADDRX_L        = 0x069C);
PROVIDE(UCB1ADDRX_H        = 0x069D);
PROVIDE(UCB1ADDMASK        = 0x069E);
PROVIDE(UCB1ADDMASK_L      = 0x069E);
PROVIDE(UCB1ADDMASK_H      = 0x069F);
PROVIDE(UCB1I2CSA          = 0x06A0);
PROVIDE(UCB1I2CSA_L        = 0x06A0);
PROVIDE(UCB1I2CSA_H        = 0x06A1);
PROVIDE(UCB1IE             = 0x06AA);
PROVIDE(UCB1IE_L           = 0x06AA);
PROVIDE(UCB1IE_H           = 0x06AB);
PROVIDE(UCB1IFG            = 0x06AC);
PROVIDE(UCB1IFG_L          = 0x06AC);
PROVIDE(UCB1IFG_H          = 0x06AD);
PROVIDE(UCB1IV             = 0x06AE);
PROVIDE(UCB1IV_L           = 0x06AE);
PROVIDE(UCB1IV_H           = 0x06AF);

/************************************************************
* End of Modules
************************************************************/

