/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.renderers.ColumnDescriptor;

public class CSVWriter<T> {
    private final String separator;
    private final String lineSeparator;
    private final List<ColumnDescriptor<T>> columns;

    public CSVWriter(List<ColumnDescriptor<T>> theColumns, String theSeparator, String theLineSeparator) {
        this.columns = theColumns;
        this.separator = theSeparator;
        this.lineSeparator = theLineSeparator;
    }

    public void writeTitles(Writer writer) throws IOException {
        StringBuilder buf = new StringBuilder(300);
        for (int i = 0; i < this.columns.size() - 1; ++i) {
            this.quoteAndCommify(buf, this.columns.get((int)i).title);
        }
        this.quote(buf, this.columns.get((int)(this.columns.size() - 1)).title);
        buf.append(this.lineSeparator);
        writer.write(buf.toString());
    }

    public void writeData(Writer writer, Iterator<T> items) throws IOException {
        int count = 1;
        StringBuilder buf = new StringBuilder(300);
        int lastColumnIdx = this.columns.size() - 1;
        while (items.hasNext()) {
            buf.setLength(0);
            T rv = items.next();
            for (int i = 0; i < lastColumnIdx; ++i) {
                this.quoteAndCommify(buf, this.columns.get((int)i).accessor.get(count, rv, this.separator));
            }
            this.quote(buf, this.columns.get((int)lastColumnIdx).accessor.get(count, rv, this.separator));
            buf.append(this.lineSeparator);
            writer.write(buf.toString());
            ++count;
        }
    }

    private void quote(StringBuilder buffer, String s) {
        if (s == null) {
            return;
        }
        buffer.append('\"').append(s).append('\"');
    }

    private void quoteAndCommify(StringBuilder buffer, String s) {
        this.quote(buffer, s);
        buffer.append(this.separator);
    }
}

