/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.statement.ListCreatorVisitors;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.services.Version;

public enum ListCreator {
    SET(false),
    SOQL_EXPRESSION(true),
    DATABASE_QUERY(true),
    SYSTEM_DATABASE_QUERY(true),
    GET_SOBJECTS(true),
    AGGREGATE_FIELD(true),
    LIST(false);

    private final boolean isQueryBased;

    private ListCreator(boolean isQueryBased) {
        this.isQueryBased = isQueryBased;
    }

    static ListCreator createListCreatorEnum(Expression expression, ListCreatorVisitors listCreatorVisitors) {
        if (CollectionTypeInfoUtil.isSet(expression.getType())) {
            return SET;
        }
        if (ExpressionUtil.isSoqlExpression(expression)) {
            return SOQL_EXPRESSION;
        }
        if (listCreatorVisitors.isDatabaseQuery(expression)) {
            return DATABASE_QUERY;
        }
        if (listCreatorVisitors.isSystemDatabaseQuery(expression)) {
            return listCreatorVisitors.getExpressionVersion(expression).isGreaterThan(Version.COMPILER_RELEASE) ? DATABASE_QUERY : SYSTEM_DATABASE_QUERY;
        }
        if (listCreatorVisitors.isGetSObjects(expression)) {
            return GET_SOBJECTS;
        }
        if (listCreatorVisitors.isAggregateField(expression)) {
            return AGGREGATE_FIELD;
        }
        return LIST;
    }

    boolean isQueryBased() {
        return this.isQueryBased;
    }
}

