/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Properties;
import net.sourceforge.pmd.cpd.AntlrTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.token.AntlrToken;
import net.sourceforge.pmd.cpd.token.AntlrTokenFilter;
import net.sourceforge.pmd.lang.antlr.AntlrTokenManager;
import net.sourceforge.pmd.lang.cs.antlr4.CSharpLexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;

public class CsTokenizer
extends AntlrTokenizer {
    private boolean ignoreUsings = false;
    private boolean ignoreLiteralSequences = false;

    public void setProperties(Properties properties) {
        this.ignoreUsings = Boolean.parseBoolean(properties.getProperty("ignore_usings", Boolean.FALSE.toString()));
        this.ignoreLiteralSequences = Boolean.parseBoolean(properties.getProperty("net.sourceforge.pmd.cpd.Tokenizer.skipLiteralSequences", Boolean.FALSE.toString()));
    }

    public void setIgnoreUsings(boolean ignoreUsings) {
        this.ignoreUsings = ignoreUsings;
    }

    public void setIgnoreLiteralSequences(boolean ignoreLiteralSequences) {
        this.ignoreLiteralSequences = ignoreLiteralSequences;
    }

    protected AntlrTokenManager getLexerForSource(SourceCode sourceCode) {
        CharStream charStream = AntlrTokenizer.getCharStreamFromSourceCode((SourceCode)sourceCode);
        return new AntlrTokenManager((Lexer)new CSharpLexer(charStream), sourceCode.getFileName());
    }

    protected AntlrTokenFilter getTokenFilter(AntlrTokenManager tokenManager) {
        return new CsTokenFilter(tokenManager, this.ignoreUsings, this.ignoreLiteralSequences);
    }

    private static class CsTokenFilter
    extends AntlrTokenFilter {
        private final boolean ignoreUsings;
        private final boolean ignoreLiteralSequences;
        private boolean discardingUsings = false;
        private boolean discardingNL = false;
        private AntlrToken discardingLiteralsUntil = null;
        private boolean discardCurrent = false;

        CsTokenFilter(AntlrTokenManager tokenManager, boolean ignoreUsings, boolean ignoreLiteralSequences) {
            super(tokenManager);
            this.ignoreUsings = ignoreUsings;
            this.ignoreLiteralSequences = ignoreLiteralSequences;
        }

        protected void analyzeToken(AntlrToken currentToken) {
            this.skipNewLines(currentToken);
        }

        protected void analyzeTokens(AntlrToken currentToken, Iterable<AntlrToken> remainingTokens) {
            this.discardCurrent = false;
            this.skipUsingDirectives(currentToken, remainingTokens);
            this.skipLiteralSequences(currentToken, remainingTokens);
        }

        private void skipUsingDirectives(AntlrToken currentToken, Iterable<AntlrToken> remainingTokens) {
            if (this.ignoreUsings) {
                int type = currentToken.getKind();
                if (type == 105 && this.isUsingDirective(remainingTokens)) {
                    this.discardingUsings = true;
                } else if (type == 134 && this.discardingUsings) {
                    this.discardingUsings = false;
                    this.discardCurrent = true;
                }
            }
        }

        private boolean isUsingDirective(Iterable<AntlrToken> remainingTokens) {
            UsingState usingState = UsingState.KEYWORD;
            block12: for (AntlrToken token : remainingTokens) {
                int type = token.getKind();
                if (usingState == UsingState.KEYWORD) {
                    switch (type) {
                        case 90: {
                            return true;
                        }
                        case 106: {
                            return false;
                        }
                        case 129: {
                            return false;
                        }
                        case 114: {
                            usingState = UsingState.IDENTIFIER;
                            continue block12;
                        }
                    }
                    return false;
                }
                if (usingState != UsingState.IDENTIFIER) continue;
                switch (type) {
                    case 145: {
                        return true;
                    }
                    case 114: {
                        return false;
                    }
                    case 131: {
                        usingState = UsingState.KEYWORD;
                        continue block12;
                    }
                    case 134: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        private void skipNewLines(AntlrToken currentToken) {
            this.discardingNL = currentToken.getKind() == 198;
        }

        private void skipLiteralSequences(AntlrToken currentToken, Iterable<AntlrToken> remainingTokens) {
            if (this.ignoreLiteralSequences) {
                int type = currentToken.getKind();
                if (this.isDiscardingLiterals()) {
                    if (currentToken == this.discardingLiteralsUntil) {
                        this.discardingLiteralsUntil = null;
                        this.discardCurrent = true;
                    }
                } else if (type == 125) {
                    AntlrToken finalToken;
                    this.discardingLiteralsUntil = finalToken = this.findEndOfSequenceOfLiterals(remainingTokens);
                }
            }
        }

        private AntlrToken findEndOfSequenceOfLiterals(Iterable<AntlrToken> remainingTokens) {
            boolean seenLiteral = false;
            int braceCount = 0;
            block6: for (AntlrToken token : remainingTokens) {
                switch (token.getKind()) {
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        seenLiteral = true;
                        continue block6;
                    }
                    case 132: {
                        continue block6;
                    }
                    case 125: {
                        ++braceCount;
                        continue block6;
                    }
                    case 126: {
                        if (--braceCount >= 0) continue block6;
                        return seenLiteral ? token : null;
                    }
                }
                return null;
            }
            return null;
        }

        public boolean isDiscardingLiterals() {
            return this.discardingLiteralsUntil != null;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingUsings || this.discardingNL || this.isDiscardingLiterals() || this.discardCurrent;
        }

        private static enum UsingState {
            KEYWORD,
            IDENTIFIER;

        }
    }
}

