/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import org.apache.commons.lang3.StringUtils;

public class BrokenNullCheckRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTIfStatement node, Object data) {
        ASTConditionalOrExpression conditionalOrExpression;
        ASTExpression expression = (ASTExpression)node.getChild(0);
        ASTConditionalAndExpression conditionalAndExpression = (ASTConditionalAndExpression)expression.getFirstDescendantOfType(ASTConditionalAndExpression.class);
        if (conditionalAndExpression != null) {
            this.checkForViolations(node, data, (Node)conditionalAndExpression);
        }
        if ((conditionalOrExpression = (ASTConditionalOrExpression)expression.getFirstDescendantOfType(ASTConditionalOrExpression.class)) != null) {
            this.checkForViolations(node, data, (Node)conditionalOrExpression);
        }
        return super.visit(node, data);
    }

    private void checkForViolations(ASTIfStatement node, Object data, Node conditionalExpression) {
        ASTEqualityExpression equalityExpression = (ASTEqualityExpression)conditionalExpression.getFirstChildOfType(ASTEqualityExpression.class);
        if (equalityExpression == null) {
            return;
        }
        if (conditionalExpression instanceof ASTConditionalAndExpression && !"==".equals(equalityExpression.getImage())) {
            return;
        }
        if (conditionalExpression instanceof ASTConditionalOrExpression && !"!=".equals(equalityExpression.getImage())) {
            return;
        }
        ASTNullLiteral nullLiteral = (ASTNullLiteral)equalityExpression.getFirstDescendantOfType(ASTNullLiteral.class);
        if (nullLiteral == null) {
            return;
        }
        if (conditionalExpression.hasDescendantOfType(ASTAssignmentOperator.class)) {
            return;
        }
        ASTPrimaryExpression nullCompareExpression = this.findNullCompareExpression(equalityExpression);
        if (nullCompareExpression == null) {
            return;
        }
        for (int i = 0; i < conditionalExpression.getNumChildren(); ++i) {
            ASTPrimaryExpression conditionalPrimaryExpression;
            ASTEqualityExpression nullEqualityExpression;
            Node conditionalSubnode = conditionalExpression.getChild(i);
            if (conditionalSubnode.equals(nullEqualityExpression = (ASTEqualityExpression)nullLiteral.getFirstParentOfType(ASTEqualityExpression.class)) || !this.primaryExpressionsAreEqual(nullCompareExpression, conditionalPrimaryExpression = conditionalSubnode instanceof ASTPrimaryExpression ? (ASTPrimaryExpression)conditionalSubnode : (ASTPrimaryExpression)conditionalSubnode.getFirstDescendantOfType(ASTPrimaryExpression.class))) continue;
            this.addViolation(data, (Node)node);
        }
    }

    private boolean primaryExpressionsAreEqual(ASTPrimaryExpression nullCompareVariable, ASTPrimaryExpression expressionUsage) {
        ArrayList<String> nullCompareNames = new ArrayList<String>();
        this.findExpressionNames((Node)nullCompareVariable, nullCompareNames);
        ArrayList<String> expressionUsageNames = new ArrayList<String>();
        this.findExpressionNames((Node)expressionUsage, expressionUsageNames);
        for (int i = 0; i < nullCompareNames.size(); ++i) {
            String expressionUsageName;
            if (expressionUsageNames.size() == i) {
                return false;
            }
            String nullCompareExpressionName = (String)nullCompareNames.get(i);
            if (nullCompareExpressionName.equals(expressionUsageName = (String)expressionUsageNames.get(i)) || expressionUsageName.startsWith(nullCompareExpressionName + ".")) continue;
            return false;
        }
        return true;
    }

    private void findExpressionNames(Node nullCompareVariable, List<String> results) {
        for (int i = 0; i < nullCompareVariable.getNumChildren(); ++i) {
            String name;
            Node child = nullCompareVariable.getChild(i);
            if (child instanceof ASTName) {
                results.add(((ASTName)child).getImage());
            } else if (child instanceof ASTLiteral) {
                String literalImage = ((ASTLiteral)child).getImage();
                if (literalImage != null) {
                    results.add(literalImage);
                }
            } else if (child instanceof ASTPrimarySuffix) {
                name = ((ASTPrimarySuffix)child).getImage();
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    results.add(name);
                }
            } else if (child instanceof ASTClassOrInterfaceType) {
                name = ((ASTClassOrInterfaceType)child).getImage();
                results.add(name);
            }
            if (child.getNumChildren() <= 0) continue;
            this.findExpressionNames(child, results);
        }
    }

    private ASTPrimaryExpression findNullCompareExpression(ASTEqualityExpression equalityExpression) {
        List primaryExpressions = equalityExpression.findDescendantsOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression primaryExpression : primaryExpressions) {
            List primaryPrefixes = primaryExpression.findDescendantsOfType(ASTPrimaryPrefix.class);
            for (ASTPrimaryPrefix primaryPrefix : primaryPrefixes) {
                if (!primaryPrefix.hasDescendantOfType(ASTName.class)) continue;
                return primaryExpression;
            }
        }
        return null;
    }
}

