/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions.soql;

import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.core.nd.IReader;

class SoqlCompletionUtils {
    SoqlCompletionUtils() {
    }

    static List<String> getSObjectTypeNames(Provider<ApexIndex> apexIndexProvider) {
        ApexIndex apexIndex = (ApexIndex)apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            List<ApexTypeId> typeIds = apexIndex.fuzzyFindTypeIds("");
            List<String> list = typeIds.stream().filter(t -> t.getType() != null && t.getType().isSObject()).map(t -> t.getApexName().getString()).collect(Collectors.toList());
            return list;
        }
    }

    static List<String> getSObjectFieldNames(Provider<ApexIndex> apexIndexProvider, String typeName) {
        ApexIndex apexIndex = (ApexIndex)apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            ApexTypeId typeId = apexIndex.findExactTypeId(typeName);
            ImmutableList<String> immutableList = typeId == null ? ImmutableList.of() : typeId.getType().getFields().stream().map(f -> f.getFieldName().getString()).collect(Collectors.toList());
            return immutableList;
        }
    }
}

