/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends SystemFunction
implements XSLTFunction {
    private NamespaceResolver nsContext;
    private StructuredQName propertyName;
    private transient boolean checked = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        if (this.argument[0] instanceof StringLiteral) {
            try {
                this.propertyName = StructuredQName.fromLexicalQName(((StringLiteral)this.argument[0]).getStringValue(), false, visitor.getConfiguration().getNameChecker(), visitor.getStaticContext().getNamespaceResolver());
                return;
            }
            catch (XPathException e) {
                if (e.getErrorCodeLocalPart() != null && !e.getErrorCodeLocalPart().equals("FOCA0002") && !e.getErrorCodeLocalPart().equals("FONS0004")) return;
                e.setErrorCode("XTDE1390");
                throw e;
            }
        } else {
            this.nsContext = visitor.getStaticContext().getNamespaceResolver();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.propertyName != null && "http://www.w3.org/1999/XSL/Transform".equals(this.propertyName.getNamespaceURI())) {
            return new StringLiteral(SystemProperty.getProperty("http://www.w3.org/1999/XSL/Transform", this.propertyName.getLocalName(), visitor.getConfiguration()));
        }
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        StructuredQName qName = this.propertyName;
        if (qName == null) {
            CharSequence name = this.argument[0].evaluateItem(context).getStringValueCS();
            try {
                qName = StructuredQName.fromLexicalQName(name, false, context.getConfiguration().getNameChecker(), this.nsContext);
            }
            catch (XPathException err) {
                this.dynamicError("Invalid system property name. " + err.getMessage(), "XTDE1390", context);
                return null;
            }
        }
        return new StringValue(SystemProperty.getProperty(qName.getNamespaceURI(), qName.getLocalName(), context.getConfiguration()));
    }

    public static String getProperty(String uri, String local, Configuration config) {
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (local.equals("version")) {
                return Version.getXSLVersionString();
            }
            if (local.equals("vendor")) {
                return Version.getProductTitle();
            }
            if (local.equals("vendor-url")) {
                return Version.getWebSiteAddress();
            }
            if (local.equals("product-name")) {
                return Version.getProductName();
            }
            if (local.equals("product-version")) {
                return config.isSchemaAware(50) ? Version.getSchemaAwareProductVersion() : Version.getProductVersion();
            }
            if (local.equals("is-schema-aware")) {
                return config.isSchemaAware(50) ? "yes" : "no";
            }
            if (local.equals("supports-serialization")) {
                return "yes";
            }
            if (local.equals("supports-backwards-compatibility")) {
                return "yes";
            }
            if (local.equals("supports-namespace-axis")) {
                return "yes";
            }
            return "";
        }
        if (uri.length() == 0 && config.isAllowExternalFunctions()) {
            String val = System.getProperty(local);
            return val == null ? "" : val;
        }
        return "";
    }
}

