/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.bcl.DateTimeEmitMethods;
import apex.jorje.semantic.bcl.DecimalEmitMethods;
import apex.jorje.semantic.bcl.DoubleEmitMethods;
import apex.jorje.semantic.bcl.IdEmitMethods;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.LongEmitMethods;
import apex.jorje.semantic.bcl.StringEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.Version;
import org.objectweb.asm.Label;

public class TypeConversion {
    public static void emitOrCheckCast(Location loc, Emitter emitter, TypeInfo oldType, TypeInfo newType) {
        if (TypeConversion.emit(loc, emitter, oldType, newType).emitCheckCast()) {
            emitter.emitType(loc, 192, TypeEraser.eraseBytecodeName(newType));
        }
    }

    public static Conversion emit(Location loc, Emitter emitter, TypeInfo oldType, TypeInfo newType) {
        Label branch = new Label();
        if (TypeInfoEquivalence.isEquivalent(newType, TypeInfos.OBJECT)) {
            return emitter.getVersion().isGreaterThanOrEqual(Version.V164) ? Conversion.YES : Conversion.YES_CAST;
        }
        if (TypeInfoEquivalence.isEquivalent(emitter.getVersion(), oldType, newType)) {
            if (oldType.getBasicType() != newType.getBasicType()) {
                if (newType.getBasicType() == BasicType.ID) {
                    emitter.emit(loc, IdEmitMethods.VALUE_OF_NULL_OK);
                    return Conversion.YES;
                }
                if (oldType.getBasicType() == BasicType.ID) {
                    return Conversion.CAST;
                }
            }
            return Conversion.NO;
        }
        if (SObjectTypeInfoUtil.isSObjectList(oldType) && newType.getBasicType() == BasicType.SOBJECT) {
            emitter.emit(Locations.NONE, 89);
            emitter.emitJump(Locations.NONE, 198, branch);
            String bytecodeName = TypeEraser.eraseBytecodeName(newType);
            emitter.push(loc, bytecodeName);
            emitter.emit(loc, ListEmitMethods.GET_FIRST_SOBJECT_BYTECODE);
            emitter.emit(branch);
            return Conversion.YES;
        }
        if (TypeConversion.isCollectionStringToId(oldType, newType) || TypeConversion.isMapStringToId(oldType, newType)) {
            emitter.emit(Locations.NONE, 89);
            String bytecodeName = TypeEraser.eraseBytecodeName(newType);
            emitter.push(Locations.NONE, bytecodeName);
            emitter.emit(Locations.NONE, SystemEmitMethods.INSTANCE_OF);
            emitter.emit(Locations.NONE, 87);
            return Conversion.YES;
        }
        switch (oldType.getBasicType()) {
            case DECIMAL: {
                switch (newType.getBasicType()) {
                    case DOUBLE: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DecimalEmitMethods.DOUBLE_VALUE);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case LONG: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DecimalEmitMethods.LONG_VALUE);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case INTEGER: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DecimalEmitMethods.INT_VALUE);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (newType.getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(loc, DecimalEmitMethods.VALUE_OF_NULL_OK_DOUBLE);
                        return Conversion.YES;
                    }
                    case LONG: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 143);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case INTEGER: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DoubleEmitMethods.INT_VALUE);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case LONG: {
                switch (newType.getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(loc, DecimalEmitMethods.VALUE_OF_LONG);
                        return Conversion.YES;
                    }
                    case DOUBLE: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 138);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case INTEGER: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, LongEmitMethods.INT_VALUE);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case INTEGER: {
                switch (newType.getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(loc, DecimalEmitMethods.VALUE_OF_NULL_OK);
                        return Conversion.YES;
                    }
                    case DOUBLE: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 135);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case LONG: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 133);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case OBJECT: 
            case APEX_OBJECT: {
                switch (newType.getBasicType()) {
                    case DOUBLE: 
                    case LONG: 
                    case INTEGER: 
                    case DECIMAL: 
                    case DATE: 
                    case DATE_TIME: 
                    case STRING: {
                        emitter.push(loc, newType.getBytecodeName());
                        emitter.emit(loc, SystemEmitMethods.CONVERT);
                        return Conversion.YES;
                    }
                    case ID: {
                        emitter.emit(loc, IdEmitMethods.VALUE_OF_NULL_OK);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case DATE: {
                switch (newType.getBasicType()) {
                    case DATE_TIME: {
                        emitter.emit(loc, DateTimeEmitMethods.NEW_INSTANCE);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case STRING: {
                switch (newType.getBasicType()) {
                    case ID: {
                        emitter.emit(loc, IdEmitMethods.VALUE_OF_NULL_OK);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case ID: {
                switch (newType.getBasicType()) {
                    case STRING: {
                        emitter.emit(loc, StringEmitMethods.VALUE_OF_ID);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case NULL: {
                switch (newType.getBasicType()) {
                    case ID: {
                        emitter.emit(loc, IdEmitMethods.VALUE_OF_NULL_OK);
                        return Conversion.YES;
                    }
                }
                return Conversion.NO;
            }
        }
        return Conversion.CAST;
    }

    private static boolean isCollectionStringToId(TypeInfo oldType, TypeInfo newType) {
        return (CollectionTypeInfoUtil.isList(oldType) && CollectionTypeInfoUtil.isList(newType) || CollectionTypeInfoUtil.isSet(newType)) && CollectionTypeInfoUtil.isCollection(oldType) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(oldType), TypeInfos.STRING) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(newType), TypeInfos.ID);
    }

    private static boolean isMapStringToId(TypeInfo oldType, TypeInfo newType) {
        return oldType.getBasicType() == BasicType.MAP && newType.getBasicType() == BasicType.MAP && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getValueType(oldType), TypeInfos.STRING) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getValueType(newType), TypeInfos.ID);
    }

    public static enum Conversion {
        YES(true, false),
        NO(false, false),
        CAST(false, true),
        YES_CAST(true, true);

        private final boolean emittedConversion;
        private final boolean emitCheckCast;

        private Conversion(boolean emittedConversion, boolean emitCheckCast) {
            this.emittedConversion = emittedConversion;
            this.emitCheckCast = emitCheckCast;
        }

        public boolean isEmittedConversion() {
            return this.emittedConversion;
        }

        public boolean emitCheckCast() {
            return this.emitCheckCast;
        }
    }
}

