/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

public class ParentVisitor
extends AstVisitor<SymbolScope> {
    private final Multimap<TypeInfo, CompilationException> errors = ArrayListMultimap.create();

    @Override
    public boolean visit(AnonymousClass node, SymbolScope scope) {
        return this.visitCompilation(node, scope);
    }

    @Override
    public boolean visit(UserClass node, SymbolScope scope) {
        return this.visitCompilation(node, scope);
    }

    @Override
    public boolean visit(UserEnum node, SymbolScope scope) {
        return this.visitCompilation(node, scope);
    }

    @Override
    public boolean visit(UserInterface node, SymbolScope scope) {
        return this.visitCompilation(node, scope);
    }

    @Override
    public boolean visit(UserTrigger node, SymbolScope scope) {
        return this.visitCompilation(node, scope);
    }

    private boolean visitCompilation(Compilation node, SymbolScope scope) {
        ParentTableFactory.resolve(this.errors, scope.getSymbols(), node.getDefiningType());
        scope.getErrors().markInvalid((AstNode)node, this.errors.get(node.getDefiningType()));
        return true;
    }
}

