/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.util;

import apex.jorje.services.exception.UnhandledException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileUtil {
    private static final FileUtil INSTANCE = new FileUtil();
    private final Path base;

    private FileUtil() {
        try {
            this.base = Paths.get(this.getClass().getClassLoader().getResource("").toURI());
        }
        catch (URISyntaxException x) {
            throw new UnhandledException("file util not loaded", x);
        }
    }

    public static FileUtil get() {
        return INSTANCE;
    }

    public Path resolve(String name) {
        return this.base.resolve(name);
    }

    public Path loadFile(String fileName) {
        try {
            URL url = this.getClass().getClassLoader().getResource(fileName);
            Preconditions.checkNotNull(url, "Unable to load: " + fileName);
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException x) {
            throw new UnhandledException("Unable to load: " + fileName, x);
        }
    }

    public String readFile(Path path) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(path, StandardCharsets.UTF_8));
        }
        catch (IOException x) {
            throw new UnhandledException("Unable to read: " + path.toAbsolutePath().toString(), x);
        }
    }

    public String readFile(String fileName) {
        return this.readFile(this.loadFile(fileName));
    }

    public boolean deleteFile(String fileName) {
        return this.deleteFile(this.loadFile(fileName));
    }

    boolean deleteFile(Path path) {
        try {
            return Files.deleteIfExists(path);
        }
        catch (Exception x) {
            throw new UnhandledException("Unable to delete: " + path.toAbsolutePath().toString(), x);
        }
    }

    public Path getBasePath() {
        return this.base;
    }
}

