/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import groovyjarjarantlr.Token;
import groovyjarjarantlr.TokenStream;
import groovyjarjarantlr.TokenStreamException;
import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import org.codehaus.groovy.antlr.SourceInfo;
import org.codehaus.groovy.antlr.parser.GroovyLexer;

public class GroovyTokenizer
implements Tokenizer {
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        GroovyLexer lexer = new GroovyLexer((Reader)new StringReader(buffer.toString()));
        TokenStream tokenStream = lexer.plumb();
        try {
            Token token = tokenStream.nextToken();
            while (token.getType() != 1) {
                int lastCol;
                String tokenText = token.getText();
                if (token instanceof SourceInfo) {
                    lastCol = ((SourceInfo)token).getColumnLast() - 1;
                    if (lastCol == 0) {
                        lastCol = token.getColumn() + 1;
                    }
                } else {
                    lastCol = token.getColumn() + tokenText.length();
                }
                TokenEntry tokenEntry = new TokenEntry(tokenText, sourceCode.getFileName(), token.getLine(), token.getColumn(), lastCol);
                tokenEntries.add(tokenEntry);
                token = tokenStream.nextToken();
            }
        }
        catch (TokenStreamException err) {
            throw new TokenMgrError(lexer.getLine(), lexer.getColumn(), sourceCode.getFileName(), err.getMessage(), (Throwable)err);
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }
}

