/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class InvalidLogMessageFormatRule
extends AbstractJavaRule {
    private static final Pattern PLACEHOLDER_AND_FORMAT_SPECIFIER = Pattern.compile("(\\{\\})|(%(?:\\d\\$)?(?:\\w+)?(?:\\d+)?(?:\\.\\d+)?\\w)");
    private static final Map<String, Set<String>> LOGGERS;
    private static final Set<String> STRUCTURED_ARGUMENTS_METHODS;
    private boolean formatIsStringFormat;

    public InvalidLogMessageFormatRule() {
        this.addRuleChainVisit(ASTImportDeclaration.class);
        this.addRuleChainVisit(ASTName.class);
    }

    public void start(RuleContext ctx) {
        this.formatIsStringFormat = false;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        if (node.isStatic()) {
            if ("java.lang.String.format".equals(node.getImportedName())) {
                this.formatIsStringFormat = true;
            }
            if ("java.lang.String".equals(node.getImportedName()) && node.isImportOnDemand()) {
                this.formatIsStringFormat = true;
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTName node, Object data) {
        ASTArrayInitializer arrayInitializer;
        ASTExpression argument;
        NameDeclaration nameDeclaration = node.getNameDeclaration();
        if (!(nameDeclaration instanceof VariableNameDeclaration)) {
            return data;
        }
        Class<?> type = ((VariableNameDeclaration)nameDeclaration).getType();
        if (type == null || !LOGGERS.containsKey(type.getName())) {
            return data;
        }
        String loggingClass = type.getName();
        ASTPrimaryExpression parentNode = (ASTPrimaryExpression)node.getFirstParentOfType(ASTPrimaryExpression.class);
        String method = ((ASTName)((ASTPrimaryPrefix)parentNode.getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class)).getImage().replace(nameDeclaration.getImage() + ".", "");
        if (!LOGGERS.get(loggingClass).contains(method)) {
            return data;
        }
        List argumentList = ((ASTArgumentList)((ASTPrimarySuffix)parentNode.getFirstChildOfType(ASTPrimarySuffix.class)).getFirstDescendantOfType(ASTArgumentList.class)).findChildrenOfType(ASTExpression.class);
        Iterator iterator = argumentList.iterator();
        while (iterator.hasNext() && !TypeTestUtil.isA(String.class, (TypeNode)(argument = (ASTExpression)iterator.next()))) {
            iterator.remove();
        }
        if (argumentList.isEmpty()) {
            return data;
        }
        ASTExpression messageParam = (ASTExpression)argumentList.remove(0);
        if (this.isStringFormatCall(messageParam)) {
            return data;
        }
        int expectedArguments = this.expectedArguments(messageParam);
        if (expectedArguments == -1) {
            return data;
        }
        if (argumentList.size() > expectedArguments) {
            this.removeThrowableParam(argumentList);
        }
        if (argumentList.size() > expectedArguments) {
            this.removePotentialStructuredArguments(argumentList.size() - expectedArguments, argumentList);
        }
        int providedArguments = argumentList.size();
        if (argumentList.size() == 1 && TypeTestUtil.isA("java.lang.Object[]", (TypeNode)argumentList.get(0)) && (arrayInitializer = (ASTArrayInitializer)((ASTExpression)argumentList.get(0)).getFirstDescendantOfType(ASTArrayInitializer.class)) != null) {
            providedArguments = arrayInitializer.getNumChildren();
        }
        if (providedArguments < expectedArguments) {
            this.addViolationWithMessage(data, (Node)node, "Missing arguments," + this.getExpectedMessage(argumentList, expectedArguments));
        } else if (providedArguments > expectedArguments) {
            this.addViolationWithMessage(data, (Node)node, "Too many arguments," + this.getExpectedMessage(argumentList, expectedArguments));
        }
        return data;
    }

    private boolean isNewThrowable(ASTPrimaryExpression last) {
        return TypeTestUtil.isA(Throwable.class, (TypeNode)last.getFirstDescendantOfType(ASTClassOrInterfaceType.class));
    }

    private boolean hasTypeThrowable(TypeNode last) {
        return last.getType() != null && TypeTestUtil.isA(Throwable.class, last);
    }

    private boolean isReferencingThrowable(ASTPrimaryExpression last) {
        ASTName variable = (ASTName)last.getFirstDescendantOfType(ASTName.class);
        if (variable != null && variable.getNameDeclaration() != null && variable.getNameDeclaration() instanceof VariableNameDeclaration) {
            VariableNameDeclaration declaration = (VariableNameDeclaration)variable.getNameDeclaration();
            if (declaration.getType() != null && Throwable.class.isAssignableFrom(declaration.getType())) {
                return true;
            }
            if (declaration.getTypeImage() != null && declaration.getTypeImage().endsWith("Exception")) {
                return true;
            }
        }
        return false;
    }

    private void removeThrowableParam(List<ASTExpression> params) {
        if (params.isEmpty()) {
            return;
        }
        int lastIndex = params.size() - 1;
        ASTExpression lastExpression = params.get(lastIndex);
        ASTPrimaryExpression last = (ASTPrimaryExpression)lastExpression.getFirstDescendantOfType(ASTPrimaryExpression.class);
        if (this.isNewThrowable(last) || this.hasTypeThrowable(lastExpression) || this.isReferencingThrowable(last) || this.isLambdaParameter(last)) {
            params.remove(lastIndex);
        }
    }

    private boolean isLambdaParameter(ASTPrimaryExpression last) {
        Scope scope;
        ASTName name;
        String varName = null;
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)last.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (prefix != null && (name = (ASTName)prefix.getFirstChildOfType(ASTName.class)) != null) {
            varName = name.getImage();
        }
        if (varName == null) {
            return false;
        }
        Scope scope2 = scope = prefix == null ? null : prefix.getScope();
        while (scope != null) {
            for (NameDeclaration decl : scope.getDeclarations().keySet()) {
                if (!varName.equals(decl.getName())) continue;
                return decl.getNode().getParent() instanceof ASTLambdaExpression;
            }
            scope = scope.getParent();
        }
        return false;
    }

    private String getExpectedMessage(List<ASTExpression> params, int expectedArguments) {
        return " expected " + expectedArguments + (expectedArguments > 1 ? " arguments " : " argument ") + "but have " + params.size();
    }

    private boolean isStringFormatCall(ASTExpression expression) {
        ASTLiteral literal;
        ASTPrimaryExpression primaryExpression = null;
        ASTPrimaryPrefix primaryPrefix = null;
        if (expression.getNumChildren() > 0 && expression.getChild(0) instanceof ASTPrimaryExpression) {
            primaryExpression = (ASTPrimaryExpression)expression.getChild(0);
        }
        if (primaryExpression != null && primaryExpression.getNumChildren() > 0 && primaryExpression.getChild(0) instanceof ASTPrimaryPrefix) {
            primaryPrefix = (ASTPrimaryPrefix)primaryExpression.getChild(0);
        }
        if (primaryPrefix != null && primaryPrefix.getNumChildren() > 0 && primaryPrefix.getChild(0) instanceof ASTName) {
            String name = ((JavaNode)primaryPrefix.getChild(0)).getImage();
            return "String.format".equals(name) || this.formatIsStringFormat && "format".equals(name);
        }
        if (primaryPrefix != null && primaryPrefix.getNumChildren() > 0 && primaryPrefix.getChild(0) instanceof ASTLiteral && (literal = (ASTLiteral)primaryPrefix.getChild(0)).isStringLiteral() && primaryExpression.getNumChildren() > 1 && primaryExpression.getChild(1) instanceof ASTPrimarySuffix) {
            ASTPrimarySuffix primarySuffix = (ASTPrimarySuffix)primaryExpression.getChild(1);
            return "formatted".equals(primarySuffix.getImage());
        }
        return false;
    }

    private int expectedArguments(ASTExpression node) {
        ASTVariableDeclarator varDecl;
        NameDeclaration nameDeclaration;
        int count = -1;
        if (node.getFirstDescendantOfType(ASTLiteral.class) != null) {
            count = this.countPlaceholders(node);
        } else if (node.getFirstDescendantOfType(ASTName.class) != null && (nameDeclaration = ((ASTName)node.getFirstDescendantOfType(ASTName.class)).getNameDeclaration()) instanceof VariableNameDeclaration && (varDecl = (ASTVariableDeclarator)((VariableNameDeclaration)nameDeclaration).getDeclaratorId().getFirstParentOfType(ASTVariableDeclarator.class)) != null) {
            count = this.getAmountOfExpectedArguments(varDecl);
        }
        return count;
    }

    private int getAmountOfExpectedArguments(ASTVariableDeclarator astVariableDeclarator) {
        ASTVariableInitializer variableInitializer = (ASTVariableInitializer)astVariableDeclarator.getFirstDescendantOfType(ASTVariableInitializer.class);
        ASTExpression expression = null;
        if (variableInitializer != null) {
            expression = (ASTExpression)variableInitializer.getFirstChildOfType(ASTExpression.class);
        }
        if (expression != null) {
            return this.countPlaceholders(expression);
        }
        return -1;
    }

    private int countPlaceholders(ASTExpression node) {
        if (this.isStringFormatCall(node)) {
            return -1;
        }
        List<ASTLiteral> literals = this.getStringLiterals((Node)node);
        if (literals.isEmpty()) {
            return -1;
        }
        int result = 0;
        for (ASTLiteral stringLiteral : literals) {
            Matcher matcher = PLACEHOLDER_AND_FORMAT_SPECIFIER.matcher(stringLiteral.getImage());
            while (matcher.find()) {
                String format = matcher.group();
                if ("%%".equals(format) || "%n".equals(format)) continue;
                ++result;
            }
        }
        return result;
    }

    private List<ASTLiteral> getStringLiterals(Node node) {
        ArrayList<ASTLiteral> stringLiterals = new ArrayList<ASTLiteral>();
        for (ASTLiteral literal : node.findDescendantsOfType(ASTLiteral.class)) {
            if (!literal.isStringLiteral()) continue;
            stringLiterals.add(literal);
        }
        return stringLiterals;
    }

    private void removePotentialStructuredArguments(int maxArgumentsToRemove, List<ASTExpression> argumentList) {
        int lastIndex;
        ASTExpression argument;
        for (int removed = 0; !argumentList.isEmpty() && removed < maxArgumentsToRemove && this.isStructuredArgumentMethodCall(argument = argumentList.get(lastIndex = argumentList.size() - 1)); ++removed) {
            argumentList.remove(lastIndex);
        }
    }

    private boolean isStructuredArgumentMethodCall(ASTExpression argument) {
        ASTPrimaryExpression primary;
        if (argument.getNumChildren() == 1 && argument.getChild(0) instanceof ASTPrimaryExpression && (primary = (ASTPrimaryExpression)argument.getChild(0)).getNumChildren() == 2 && primary.getChild(1) instanceof ASTPrimarySuffix) {
            ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)primary.getChild(0);
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)primary.getChild(1);
            if (suffix.isArguments() && prefix.getNumChildren() == 1 && prefix.getChild(0) instanceof ASTName) {
                ASTName name = (ASTName)prefix.getChild(0);
                return name.getImage().startsWith("StructuredArguments.") || STRUCTURED_ARGUMENTS_METHODS.contains(name.getImage());
            }
        }
        return false;
    }

    static {
        STRUCTURED_ARGUMENTS_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("a", "array", "defer", "e", "entries", "f", "fields", "keyValue", "kv", "r", "raw", "v", "value")));
        HashMap<String, Set<String>> loggersMap = new HashMap<String, Set<String>>();
        loggersMap.put("org.slf4j.Logger", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error"))));
        loggersMap.put("org.apache.logging.log4j.Logger", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error", "fatal", "all"))));
        LOGGERS = loggersMap;
    }
}

