/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.ast.BinaryOp;

public enum AssignmentOp {
    EQUALS("="),
    AND_EQUALS("&="),
    OR_EQUALS("|="),
    XOR_EQUALS("^="),
    ADDITION_EQUALS("+="),
    SUBTRACTION_EQUALS("-="),
    MULTIPLICATION_EQUALS("*="),
    DIVISION_EQUALS("/="),
    LEFT_SHIFT_EQUALS("<<="),
    RIGHT_SHIFT_EQUALS(">>="),
    UNSIGNED_RIGHT_SHIFT_EQUALS(">>>=");

    private final String code;

    private AssignmentOp(String code) {
        this.code = code;
    }

    public String toString() {
        return this.code;
    }

    public BinaryOp getBinaryOp() {
        switch (this) {
            case AND_EQUALS: {
                return BinaryOp.AND;
            }
            case OR_EQUALS: {
                return BinaryOp.OR;
            }
            case XOR_EQUALS: {
                return BinaryOp.XOR;
            }
            case ADDITION_EQUALS: {
                return BinaryOp.ADDITION;
            }
            case SUBTRACTION_EQUALS: {
                return BinaryOp.SUBTRACTION;
            }
            case MULTIPLICATION_EQUALS: {
                return BinaryOp.MULTIPLICATION;
            }
            case DIVISION_EQUALS: {
                return BinaryOp.DIVISION;
            }
            case LEFT_SHIFT_EQUALS: {
                return BinaryOp.LEFT_SHIFT;
            }
            case RIGHT_SHIFT_EQUALS: {
                return BinaryOp.RIGHT_SHIFT;
            }
            case UNSIGNED_RIGHT_SHIFT_EQUALS: {
                return BinaryOp.UNSIGNED_RIGHT_SHIFT;
            }
        }
        throw new UnsupportedOperationException("op does not have an associated binary op: " + (Object)((Object)this));
    }
}

