/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.lsp.api.utils.SymbolPrinter;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.inject.Singleton;
import java.util.Objects;
import java.util.stream.Collectors;

@Singleton
public class StandardSymbolPrinter
implements SymbolPrinter {
    @Override
    public String print(UserClass userClass) {
        return TypeInfoPrinter.print(userClass.getDefiningType());
    }

    @Override
    public String print(UserTrigger userTrigger) {
        return TypeInfoPrinter.print(userTrigger.getDefiningType());
    }

    @Override
    public String print(UserInterface userInterface) {
        return TypeInfoPrinter.print(userInterface.getDefiningType());
    }

    @Override
    public String print(UserEnum userEnum) {
        return TypeInfoPrinter.print(userEnum.getDefiningType());
    }

    @Override
    public String print(Method method) {
        return MethodInfoPrinter.print(method.getMethodInfo());
    }

    @Override
    public String print(Property property) {
        return PropertyPrinter.print(property);
    }

    @Override
    public String print(Field field) {
        return FieldPrinter.print(field);
    }

    static final class PropertyPrinter {
        PropertyPrinter() {
        }

        static String print(Property property) {
            StringBuilder sb = new StringBuilder();
            FieldInfo fieldInfo = property.getFieldInfo();
            sb.append(fieldInfo.getName());
            sb.append(" : ");
            sb.append(TypeInfoPrinter.print(fieldInfo.getType()));
            return sb.toString();
        }
    }

    static final class FieldPrinter {
        FieldPrinter() {
        }

        static String print(Field field) {
            StringBuilder sb = new StringBuilder();
            FieldInfo fieldInfo = field.getFieldInfo();
            if (fieldInfo.getDefiningType().getUnitType() == UnitType.ENUM) {
                sb.append(fieldInfo.getName());
            } else {
                sb.append(fieldInfo.getName());
                sb.append(" : ");
                sb.append(TypeInfoPrinter.print(fieldInfo.getType()));
            }
            return sb.toString();
        }
    }

    static final class TypeInfoPrinter {
        TypeInfoPrinter() {
        }

        static String print(TypeInfo typeInfo) {
            return typeInfo.getApexName();
        }
    }

    static final class MethodInfoPrinter {
        MethodInfoPrinter() {
        }

        static String print(MethodInfo methodInfo) {
            StringBuilder sb = new StringBuilder();
            if (MethodInfoPrinter.isImplicitInit(methodInfo)) {
                sb.append(TypeInfoPrinter.print(methodInfo.getDefiningType()));
                sb.append("(");
                sb.append(methodInfo.getParameters().stream().map(p -> TypeInfoPrinter.print(p.getType())).collect(Collectors.joining(", ")));
                sb.append(")");
            } else {
                sb.append(methodInfo.getCanonicalName());
                sb.append("(");
                sb.append(methodInfo.getParameters().stream().map(p -> TypeInfoPrinter.print(p.getType())).collect(Collectors.joining(", ")));
                sb.append(")");
                sb.append(" : ");
                sb.append(TypeInfoPrinter.print(methodInfo.getReturnType()));
            }
            return sb.toString();
        }

        static boolean isImplicitInit(MethodInfo methodInfo) {
            String canonicalName = methodInfo.getCanonicalName();
            return Objects.equals(canonicalName, "<init>");
        }
    }
}

