/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.common.tuple.IntPair;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.OldVersionProvider;
import apex.jorje.semantic.compiler.SourceInfo;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.services.Version;
import com.google.common.collect.MoreMaps;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class SourceFile
implements SourceInfo {
    private final String body;
    private final Version version;
    private final Namespace namespace;
    private final boolean isTrusted;
    private final boolean isFileBased;
    private final boolean isMocked;
    private final boolean supportsLongTopLevelIdentifier;
    private final String allPackageId;
    private final int lengthWithComments;
    private final String knownName;
    private final OldVersionProvider oldVersionProvider;
    private final Map<Namespace, StructuredVersion> referencedPackageVersions;
    private final Map<IntPair, StructuredVersionRange> exportedPackageVersions;
    private final Map<IntPair, Map<String, StructuredVersion>> interfacePackageVersions;

    private SourceFile(Builder builder) {
        this.body = builder.body;
        this.version = builder.version;
        this.namespace = builder.namespace;
        this.isTrusted = builder.isTrusted;
        this.isFileBased = builder.isFileBased;
        this.isMocked = builder.isMocked;
        this.supportsLongTopLevelIdentifier = builder.supportsLongTopLevelIdentifier;
        this.allPackageId = builder.allPackageId;
        this.lengthWithComments = builder.lengthWithComments.orElse(this.body.length());
        this.knownName = builder.knownName;
        this.referencedPackageVersions = builder.referencedPackageVersions;
        this.exportedPackageVersions = builder.exportedPackageVersions;
        this.interfacePackageVersions = builder.interfacePackageVersions;
        this.oldVersionProvider = builder.oldVersionProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getLengthWithComments() {
        return this.lengthWithComments;
    }

    public String getBody() {
        return this.body;
    }

    public Version getVersion() {
        return this.version;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isTrusted() {
        return this.isTrusted;
    }

    @Override
    public boolean isFileBased() {
        return this.isFileBased;
    }

    @Override
    public boolean isMocked() {
        return this.isMocked;
    }

    @Override
    public boolean supportsLongTopLevelIdentifier() {
        return this.supportsLongTopLevelIdentifier || this.isFileBased;
    }

    @Override
    public OldVersionProvider getVersionProvider() {
        return this.oldVersionProvider;
    }

    @Override
    public Map<Namespace, StructuredVersion> getReferencedPackageVersions() {
        return this.referencedPackageVersions;
    }

    @Override
    public Map<IntPair, StructuredVersionRange> getExportedPackageVersions() {
        return this.exportedPackageVersions;
    }

    @Override
    public Map<IntPair, Map<String, StructuredVersion>> getInterfacePackageVersions() {
        return this.interfacePackageVersions;
    }

    public String getAllPackageId() {
        return this.allPackageId;
    }

    public String toString() {
        return this.body;
    }

    public String getKnownName() {
        return this.knownName;
    }

    public Builder copy() {
        return new Builder().setSeed(this);
    }

    public static class Builder {
        private String body = "";
        private Version version = Version.CURRENT;
        private Namespace namespace = Namespaces.EMPTY;
        private boolean isTrusted = false;
        private boolean isFileBased = false;
        private boolean isMocked;
        private boolean supportsLongTopLevelIdentifier;
        private String allPackageId = null;
        private Optional<Integer> lengthWithComments = Optional.empty();
        private String knownName = "";
        private Map<Namespace, StructuredVersion> referencedPackageVersions = Collections.emptyMap();
        private Map<IntPair, StructuredVersionRange> exportedPackageVersions = Collections.emptyMap();
        private Map<IntPair, Map<String, StructuredVersion>> interfacePackageVersions = Collections.emptyMap();
        private OldVersionProvider oldVersionProvider;

        public SourceFile build() {
            assert (this.isFileBased == this.isTrusted || !this.isFileBased) : "source cannot be file based and not trusted";
            return new SourceFile(this);
        }

        Builder setSeed(SourceFile sourceFile) {
            this.allPackageId = sourceFile.allPackageId;
            this.isTrusted = sourceFile.isTrusted;
            this.isFileBased = sourceFile.isFileBased;
            this.namespace = sourceFile.namespace;
            this.body = sourceFile.body;
            this.version = sourceFile.version;
            this.knownName = sourceFile.knownName;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder setReferencedPackageVersions(Map<Namespace, StructuredVersion> referencedPackageVersions) {
            this.referencedPackageVersions = MoreMaps.toEmptyMap(referencedPackageVersions);
            return this;
        }

        public Builder setExportedPackageVersions(Map<IntPair, StructuredVersionRange> exportedPackageVersions) {
            this.exportedPackageVersions = MoreMaps.toEmptyMap(exportedPackageVersions);
            return this;
        }

        public Builder setInterfacePackageVersions(Map<IntPair, Map<String, StructuredVersion>> interfacePackageVersions) {
            this.interfacePackageVersions = MoreMaps.toEmptyMap(interfacePackageVersions);
            return this;
        }

        public Builder setNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setTrusted(boolean isTrusted) {
            this.isTrusted = isTrusted;
            return this;
        }

        public Builder setFileBased(boolean isFileBased) {
            this.isFileBased = isFileBased;
            return this;
        }

        @SfdcCalled
        public Builder setMocked(boolean isMocked) {
            this.isMocked = isMocked;
            return this;
        }

        @SfdcCalled
        public Builder setSupportsLongTopLevelIdentifier(boolean supportsLongTopLevelIdentifier) {
            this.supportsLongTopLevelIdentifier = supportsLongTopLevelIdentifier;
            return this;
        }

        public Builder setAllPackageId(String allPackageId) {
            this.allPackageId = allPackageId;
            return this;
        }

        public Builder setLengthWithComments(int lengthWithComments) {
            this.lengthWithComments = Optional.of(lengthWithComments);
            return this;
        }

        public Builder setKnownName(String knownName) {
            this.knownName = knownName;
            return this;
        }

        @SfdcCalled
        public Builder setOldVersionProvider(OldVersionProvider oldVersionProvider) {
            this.oldVersionProvider = oldVersionProvider;
            return this;
        }
    }
}

