/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.cli.internal.CliMessages;
import net.sourceforge.pmd.cpd.CPDCommandLineInterface;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.renderer.CPDReportRenderer;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.util.FileFinder;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.database.DBMSMetadata;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;
import net.sourceforge.pmd.util.log.ScopedLogHandlersManager;

@Deprecated
public class CPD {
    private static final Logger LOGGER = Logger.getLogger(CPD.class.getName());
    private CPDConfiguration configuration;
    private Map<String, SourceCode> source = new TreeMap<String, SourceCode>();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private MatchAlgorithm matchAlgorithm;
    private Set<String> current = new HashSet<String>();
    private final Map<String, Integer> numberOfTokensPerFile = new HashMap<String, Integer>();
    private int lastTokenSize = 0;

    public CPD(CPDConfiguration theConfiguration) {
        this.configuration = theConfiguration;
        TokenEntry.clearImages();
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void go() {
        LOGGER.fine("Running match algorithm on " + this.source.size() + " files...");
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.configuration.getMinimumTileSize(), this.listener);
        this.matchAlgorithm.findMatches();
        LOGGER.fine("Finished: " + this.matchAlgorithm.getMatches().size() + " duplicates found");
    }

    public Iterator<Match> getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void addAllInDirectory(File dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(File dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List<File> files) throws IOException {
        for (File f : files) {
            this.add(f);
        }
    }

    private void addDirectory(File dir, boolean recurse) throws IOException {
        if (!dir.exists()) {
            throw new FileNotFoundException("Couldn't find directory " + dir);
        }
        LOGGER.fine("Searching directory " + dir + " for files");
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.configuration.filenameFilter(), recurse));
    }

    public void add(File file) throws IOException {
        if (this.configuration.isSkipDuplicates()) {
            String signature = file.getName() + '_' + file.length();
            if (this.current.contains(signature)) {
                System.err.println("Skipping " + file.getAbsolutePath() + " since it appears to be a duplicate file and --skip-duplicate-files is set");
                return;
            }
            this.current.add(signature);
        }
        if (!IOUtil.equalsNormalizedPaths(file.getAbsoluteFile().getCanonicalPath(), file.getAbsolutePath())) {
            System.err.println("Skipping " + file + " since it appears to be a symlink");
            return;
        }
        if (!file.exists()) {
            System.err.println("Skipping " + file + " since it doesn't exist (broken symlink?)");
            return;
        }
        SourceCode sourceCode = this.configuration.sourceCodeFor(file);
        this.add(sourceCode);
    }

    public void add(DBURI dburi) throws IOException {
        try {
            DBMSMetadata dbmsmetadata = new DBMSMetadata(dburi);
            List<SourceObject> sourceObjectList = dbmsmetadata.getSourceObjectList();
            LOGGER.log(Level.FINER, "Located {0} database source objects", sourceObjectList.size());
            for (SourceObject sourceObject : sourceObjectList) {
                String falseFilePath = sourceObject.getPseudoFileName();
                LOGGER.log(Level.FINEST, "Adding database source object {0}", falseFilePath);
                SourceCode sourceCode = this.configuration.sourceCodeFor(dbmsmetadata.getSourceCode(sourceObject), falseFilePath);
                this.add(sourceCode);
            }
        }
        catch (Exception sqlException) {
            LOGGER.log(Level.SEVERE, "Problem with Input URI", sqlException);
            throw new RuntimeException("Problem with DBURI: " + dburi, sqlException);
        }
    }

    @Experimental
    public void add(SourceCode sourceCode) throws IOException {
        if (this.configuration.isSkipLexicalErrors()) {
            this.addAndSkipLexicalErrors(sourceCode);
        } else {
            this.addAndThrowLexicalError(sourceCode);
        }
    }

    private void addAndThrowLexicalError(SourceCode sourceCode) throws IOException {
        LOGGER.fine("Tokenizing " + sourceCode.getFileName());
        this.configuration.tokenizer().tokenize(sourceCode, this.tokens);
        this.listener.addedFile(1, new File(sourceCode.getFileName()));
        this.source.put(sourceCode.getFileName(), sourceCode);
        this.numberOfTokensPerFile.put(sourceCode.getFileName(), this.tokens.size() - this.lastTokenSize - 1);
        this.lastTokenSize = this.tokens.size();
    }

    private void addAndSkipLexicalErrors(SourceCode sourceCode) throws IOException {
        TokenEntry.State savedState = new TokenEntry.State();
        try {
            this.addAndThrowLexicalError(sourceCode);
        }
        catch (TokenMgrError e) {
            System.err.println("Skipping " + sourceCode.getFileName() + ". Reason: " + e.getMessage());
            savedState.restore(this.tokens);
        }
    }

    public List<String> getSourcePaths() {
        return new ArrayList<String>(this.source.keySet());
    }

    public List<SourceCode> getSources() {
        return new ArrayList<SourceCode>(this.source.values());
    }

    public static void main(String[] args) {
        StatusCode statusCode = CPD.runCpd(args);
        CPDCommandLineInterface.setStatusCodeOrExit(statusCode.toInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusCode runCpd(String ... args) {
        CPDConfiguration arguments = new CPDConfiguration();
        StatusCode statusCode = CPDCommandLineInterface.parseArgs(arguments, args);
        if (statusCode != null) {
            return statusCode;
        }
        Level logLevel = arguments.isDebug() ? Level.FINER : Level.INFO;
        ScopedLogHandlersManager logHandlerManager = new ScopedLogHandlersManager(logLevel, new ConsoleHandler());
        Level oldLogLevel = LOGGER.getLevel();
        LOGGER.setLevel(logLevel);
        CPD cpd = new CPD(arguments);
        try {
            CPDCommandLineInterface.addSourceFilesToCPD(cpd, arguments);
            cpd.go();
            CPDReportRenderer renderer = arguments.getCPDReportRenderer();
            if (renderer == null) {
                System.out.println(arguments.getRenderer().render(cpd.getMatches()));
            } else {
                CPDReport report = cpd.toReport();
                renderer.render(report, IOUtil.createWriter(Charset.defaultCharset(), null));
            }
            statusCode = cpd.getMatches().hasNext() ? (arguments.isFailOnViolation() ? StatusCode.DUPLICATE_CODE_FOUND : StatusCode.OK) : StatusCode.OK;
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
            LOGGER.severe(CliMessages.errorDetectedMessage(1, "cpd"));
            statusCode = StatusCode.ERROR;
        }
        finally {
            logHandlerManager.close();
            LOGGER.setLevel(oldLogLevel);
        }
        return statusCode;
    }

    public CPDReport toReport() {
        return new CPDReport(this.matchAlgorithm.getMatches(), this.numberOfTokensPerFile);
    }

    @Deprecated
    public static enum StatusCode {
        OK(0),
        ERROR(1),
        DUPLICATE_CODE_FOUND(4);

        private final int code;

        private StatusCode(int code) {
            this.code = code;
        }

        public int toInt() {
            return this.code;
        }
    }
}

