/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class ShortFilenameUtil {
    private ShortFilenameUtil() {
    }

    public static String determineFileName(List<String> inputPathPrefixes, String inputFileName) {
        for (String prefix : inputPathPrefixes) {
            Path prefPath = Paths.get(prefix, new String[0]).toAbsolutePath();
            String prefPathString = prefPath.toString();
            if (!inputFileName.startsWith(prefPathString)) continue;
            if (prefPath.toFile().isDirectory()) {
                return ShortFilenameUtil.trimAnyPathSep(inputFileName.substring(prefPathString.length()));
            }
            if (inputFileName.indexOf(File.separatorChar) == -1) {
                return inputFileName;
            }
            return ShortFilenameUtil.trimAnyPathSep(inputFileName.substring(prefPathString.lastIndexOf(File.separatorChar)));
        }
        return inputFileName;
    }

    private static String trimAnyPathSep(String name) {
        return name != null && name.charAt(0) == File.separatorChar ? name.substring(1) : name;
    }
}

