/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.List;
import java.util.Stack;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTCatchStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.ast.ASTFinallyStatement;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.symboltable.ClassScope;
import net.sourceforge.pmd.symboltable.LocalScope;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.MethodScope;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.SourceFileScope;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class ScopeAndDeclarationFinder
extends JavaParserVisitorAdapter {
    private Stack scopes = new Stack();

    private void addScope(Scope newScope, SimpleNode node) {
        newScope.setParent((Scope)this.scopes.peek());
        this.scopes.push(newScope);
        node.setScope(newScope);
    }

    private void createLocalScope(SimpleNode node) {
        this.addScope(new LocalScope(), node);
    }

    private void createMethodScope(SimpleNode node) {
        this.addScope(new MethodScope(node), node);
    }

    private void createClassScope(SimpleNode node) {
        if (node instanceof ASTClassOrInterfaceBodyDeclaration) {
            this.addScope(new ClassScope(), node);
        } else {
            this.addScope(new ClassScope(node.getImage()), node);
        }
    }

    private void createSourceFileScope(SimpleNode node) {
        SourceFileScope scope;
        List packages = node.findChildrenOfType(ASTPackageDeclaration.class);
        if (!packages.isEmpty()) {
            Node n = (Node)packages.get(0);
            scope = new SourceFileScope(((SimpleNode)n.jjtGetChild(0)).getImage());
        } else {
            scope = new SourceFileScope();
        }
        this.scopes.push(scope);
        node.setScope(scope);
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        this.createSourceFileScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.createClassScope(node);
        Scope s = ((SimpleNode)node.jjtGetParent()).getScope();
        s.addDeclaration(new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        this.createClassScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTClassOrInterfaceBodyDeclaration node, Object data) {
        if (node.isAnonymousInnerClass() || node.isEnumChild()) {
            this.createClassScope(node);
            this.cont(node);
        } else {
            super.visit(node, data);
        }
        return data;
    }

    public Object visit(ASTBlock node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTCatchStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTFinallyStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.createMethodScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.createMethodScope(node);
        ASTMethodDeclarator md = (ASTMethodDeclarator)node.getFirstChildOfType(ASTMethodDeclarator.class);
        node.getScope().getEnclosingClassScope().addDeclaration(new MethodNameDeclaration(md));
        this.cont(node);
        return data;
    }

    public Object visit(ASTTryStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        VariableNameDeclaration decl = new VariableNameDeclaration(node);
        node.getScope().addDeclaration(decl);
        node.setNameDeclaration(decl);
        return super.visit(node, data);
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    private void cont(SimpleJavaNode node) {
        super.visit(node, null);
        this.scopes.pop();
    }
}

