/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;

public class Tokenize
extends SystemFunctionCall
implements Callable {
    private RegularExpression regexp;
    private boolean allow30features = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.allow30features = DecimalValue.THREE.equals(visitor.getStaticContext().getXPathLanguageLevel());
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
            if (this.regexp != null && this.regexp.matches("")) {
                err = new XPathException("The regular expression in tokenize() must not be one that matches a zero-length string");
                err.setErrorCode("FORX0003");
                err.setLocator(this);
                throw err;
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        AtomicValue sv = (AtomicValue)this.argument[0].evaluateItem(c);
        if (sv == null) {
            return EmptyIterator.getInstance();
        }
        CharSequence input = sv.getStringValueCS();
        if (input.length() == 0) {
            return EmptyIterator.getInstance();
        }
        RegularExpression re = this.regexp;
        if (re == null) {
            CharSequence flags;
            sv = (AtomicValue)this.argument[1].evaluateItem(c);
            CharSequence pattern = sv.getStringValueCS();
            if (this.argument.length == 2) {
                flags = "";
            } else {
                sv = (AtomicValue)this.argument[2].evaluateItem(c);
                flags = sv.getStringValueCS();
            }
            re = this.buildRegex(c, pattern, flags);
        }
        return re.tokenize(input);
    }

    private RegularExpression buildRegex(XPathContext c, CharSequence pattern, CharSequence flags) throws XPathException {
        RegularExpression re;
        try {
            re = Configuration.getPlatform().compileRegularExpression(pattern, flags.toString(), this.allow30features ? "XP30" : "XP20", null);
        }
        catch (XPathException err) {
            XPathException de = new XPathException(err);
            de.setErrorCode("FORX0002");
            de.setXPathContext(c);
            de.setLocator(this);
            throw de;
        }
        if (re.matches("")) {
            err = new XPathException("The regular expression in tokenize() must not be one that matches a zero-length string");
            err.setErrorCode("FORX0003");
            err.setLocator(this);
            throw err;
        }
        return re;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue sv = (AtomicValue)arguments[0].head();
        if (sv == null) {
            return EmptySequence.getInstance();
        }
        CharSequence input = sv.getStringValueCS();
        if (input.length() == 0) {
            return EmptySequence.getInstance();
        }
        RegularExpression re = this.regexp;
        if (re == null) {
            CharSequence flags;
            sv = (AtomicValue)arguments[1].head();
            CharSequence pattern = sv.getStringValueCS();
            if (this.argument.length == 2) {
                flags = "";
            } else {
                sv = (AtomicValue)arguments[2].head();
                flags = sv.getStringValueCS();
            }
            re = this.buildRegex(context, pattern, flags);
        }
        return SequenceTool.toLazySequence(re.tokenize(input));
    }
}

