/*
 * Decompiled with CFR 0.152.
 */
package com.imageworks.migration;

import com.imageworks.migration.ColumnDefinition$;
import com.imageworks.migration.ColumnOption;
import com.imageworks.migration.ColumnSupportsDefault;
import com.imageworks.migration.ColumnSupportsLimit;
import com.imageworks.migration.ColumnSupportsPrecision;
import com.imageworks.migration.ColumnSupportsScale;
import com.imageworks.migration.DatabaseAdapter;
import java.rmi.RemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnDefinition
implements ScalaObject {
    public volatile int bitmap$0;
    private boolean isUnique;
    private Option com$imageworks$migration$ColumnDefinition$$scale_;
    private Option com$imageworks$migration$ColumnDefinition$$precision_;
    private boolean isPrimaryKey;
    private Option<Boolean> notNullOpt;
    private Option com$imageworks$migration$ColumnDefinition$$limit_;
    private Option com$imageworks$migration$ColumnDefinition$$default;
    private List<ColumnOption> options;
    private Option<String> columnNameOpt;
    private Option<String> tableNameOpt;
    private Option<DatabaseAdapter> adapterOpt;
    private final Logger com$imageworks$migration$ColumnDefinition$$logger = LoggerFactory.getLogger(this.getClass());

    public ColumnDefinition() {
        this.adapterOpt = None$.MODULE$;
        this.tableNameOpt = None$.MODULE$;
        this.columnNameOpt = None$.MODULE$;
        this.com$imageworks$migration$ColumnDefinition$$default = None$.MODULE$;
        this.com$imageworks$migration$ColumnDefinition$$limit_ = None$.MODULE$;
        this.com$imageworks$migration$ColumnDefinition$$precision_ = None$.MODULE$;
        this.com$imageworks$migration$ColumnDefinition$$scale_ = None$.MODULE$;
    }

    public String sqlForColumnType(String column_type_name) {
        return this.sqlForColumnType(column_type_name, this.limit());
    }

    public String sqlForColumnType(String column_type_name, Option<String> limit_opt) {
        Option<String> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = limit_opt;
                    if (!(option instanceof Some)) break block2;
                    string = new scala.StringBuilder().append((Object)column_type_name).append((Object)"(").append(((Some)option).x()).append((Object)")").toString();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                string = column_type_name;
            }
            return string;
        }
        throw new MatchError(option);
    }

    public final String toSql() {
        Option<Boolean> option;
        StringBuilder sb$1 = new StringBuilder(512).append(this.sql());
        if (this.com$imageworks$migration$ColumnDefinition$$default().isDefined()) {
            sb$1.append(" DEFAULT ");
            sb$1.append((String)this.com$imageworks$migration$ColumnDefinition$$default().get());
        }
        if (this.isPrimaryKey()) {
            sb$1.append(" PRIMARY KEY");
        }
        if (this.isUnique()) {
            sb$1.append(" UNIQUE");
        }
        Object object = (option = this.notNullOpt()) instanceof Some && BoxesRunTime.unboxToBoolean((Object)((Some)option).x()) ? sb$1.append(" NOT NULL") : BoxedUnit.UNIT;
        this.options().foreach((Function1)new $anonfun$toSql$1(this, sb$1));
        if (!this.options().isEmpty()) {
            this.com$imageworks$migration$ColumnDefinition$$logger().warn("The following options for the '{}' column are unused: {}.", (Object)this.getColumnName(), this.options());
        }
        if (this.isPrimaryKey() && this.notNullOpt().isDefined() && !BoxesRunTime.unboxToBoolean((Object)this.notNullOpt().get())) {
            this.com$imageworks$migration$ColumnDefinition$$logger().warn("Specifying PrimaryKey and Nullable in a column is not supported in all databases.");
        }
        if (this.isPrimaryKey() && this.notNullOpt().isDefined() && BoxesRunTime.unboxToBoolean((Object)this.notNullOpt().get())) {
            this.com$imageworks$migration$ColumnDefinition$$logger().warn("Specifying PrimaryKey and NotNull is redundant.");
        }
        if (this.isPrimaryKey() && this.isUnique()) {
            this.com$imageworks$migration$ColumnDefinition$$logger().warn("Specifying PrimaryKey and Unique is redundant.");
        }
        return sb$1.toString();
    }

    public abstract String sql();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUnique() {
        if ((this.bitmap$0 & 0x10) != 0) return this.isUnique;
        ColumnDefinition columnDefinition = this;
        synchronized (columnDefinition) {
            if ((this.bitmap$0 & 0x10) == 0) {
                BooleanRef unique$1 = new BooleanRef(false);
                this.options().filter((Function1)new $anonfun$isUnique$1(this)).foreach((Function1)new $anonfun$isUnique$2(this, unique$1));
                this.isUnique = unique$1.elem;
                this.bitmap$0 |= 0x10;
            }
            return this.isUnique;
        }
    }

    private void checkForScale() {
        this.options().filter((Function1)new $anonfun$checkForScale$1(this)).foreach((Function1)new $anonfun$checkForScale$2(this));
    }

    public Option<Integer> scale() {
        return this.com$imageworks$migration$ColumnDefinition$$scale_();
    }

    public final void com$imageworks$migration$ColumnDefinition$$scale__$eq(Option x$1) {
        this.com$imageworks$migration$ColumnDefinition$$scale_ = x$1;
    }

    public final Option com$imageworks$migration$ColumnDefinition$$scale_() {
        return this.com$imageworks$migration$ColumnDefinition$$scale_;
    }

    private void checkForPrecision() {
        this.options().filter((Function1)new $anonfun$checkForPrecision$1(this)).foreach((Function1)new $anonfun$checkForPrecision$2(this));
    }

    public Option<Integer> precision() {
        return this.com$imageworks$migration$ColumnDefinition$$precision_();
    }

    public final void com$imageworks$migration$ColumnDefinition$$precision__$eq(Option x$1) {
        this.com$imageworks$migration$ColumnDefinition$$precision_ = x$1;
    }

    public final Option com$imageworks$migration$ColumnDefinition$$precision_() {
        return this.com$imageworks$migration$ColumnDefinition$$precision_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPrimaryKey() {
        if ((this.bitmap$0 & 4) != 0) return this.isPrimaryKey;
        ColumnDefinition columnDefinition = this;
        synchronized (columnDefinition) {
            if ((this.bitmap$0 & 4) == 0) {
                BooleanRef is_primary$1 = new BooleanRef(false);
                this.options().filter((Function1)new $anonfun$isPrimaryKey$1(this)).foreach((Function1)new $anonfun$isPrimaryKey$2(this, is_primary$1));
                this.isPrimaryKey = is_primary$1.elem;
                this.bitmap$0 |= 4;
            }
            return this.isPrimaryKey;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Boolean> notNullOpt() {
        if ((this.bitmap$0 & 1) != 0) return this.notNullOpt;
        ColumnDefinition columnDefinition = this;
        synchronized (columnDefinition) {
            if ((this.bitmap$0 & 1) == 0) {
                ObjectRef n1$1 = new ObjectRef((Object)None$.MODULE$);
                this.options().foreach((Function1)new $anonfun$notNullOpt$1(this, n1$1));
                this.notNullOpt = (Option)n1$1.elem;
                this.bitmap$0 |= 1;
            }
            return this.notNullOpt;
        }
    }

    private void checkForLimit() {
        this.options().filter((Function1)new $anonfun$checkForLimit$1(this)).foreach((Function1)new $anonfun$checkForLimit$2(this));
    }

    public Option<String> limit() {
        return this.com$imageworks$migration$ColumnDefinition$$limit_();
    }

    public final void com$imageworks$migration$ColumnDefinition$$limit__$eq(Option x$1) {
        this.com$imageworks$migration$ColumnDefinition$$limit_ = x$1;
    }

    public final Option com$imageworks$migration$ColumnDefinition$$limit_() {
        return this.com$imageworks$migration$ColumnDefinition$$limit_;
    }

    private void checkForDefault() {
        this.options().filter((Function1)new $anonfun$checkForDefault$1(this)).foreach((Function1)new $anonfun$checkForDefault$2(this));
    }

    public void initialize() {
        if (this instanceof ColumnSupportsLimit) {
            this.checkForLimit();
        }
        if (this instanceof ColumnSupportsDefault) {
            this.checkForDefault();
        }
        if (this instanceof ColumnSupportsPrecision) {
            this.checkForPrecision();
        }
        if (this instanceof ColumnSupportsScale) {
            this.checkForScale();
        }
    }

    public final void com$imageworks$migration$ColumnDefinition$$default_$eq(Option x$1) {
        this.com$imageworks$migration$ColumnDefinition$$default = x$1;
    }

    public final Option com$imageworks$migration$ColumnDefinition$$default() {
        return this.com$imageworks$migration$ColumnDefinition$$default;
    }

    public void options_$eq(List<ColumnOption> x$1) {
        this.options = x$1;
    }

    public List<ColumnOption> options() {
        return this.options;
    }

    public String getColumnName() {
        return (String)this.columnNameOpt().get();
    }

    public void columnNameOpt_$eq(Option<String> x$1) {
        this.columnNameOpt = x$1;
    }

    public Option<String> columnNameOpt() {
        return this.columnNameOpt;
    }

    public String getTableName() {
        return (String)this.tableNameOpt().get();
    }

    public void tableNameOpt_$eq(Option<String> x$1) {
        this.tableNameOpt = x$1;
    }

    public Option<String> tableNameOpt() {
        return this.tableNameOpt;
    }

    public DatabaseAdapter getAdapter() {
        return (DatabaseAdapter)this.adapterOpt().get();
    }

    public void adapterOpt_$eq(Option<DatabaseAdapter> x$1) {
        this.adapterOpt = x$1;
    }

    public Option<DatabaseAdapter> adapterOpt() {
        return this.adapterOpt;
    }

    public final Logger com$imageworks$migration$ColumnDefinition$$logger() {
        return this.com$imageworks$migration$ColumnDefinition$$logger;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

