/*
 * Decompiled with CFR 0.152.
 */
package com.imageworks.migration;

import com.imageworks.migration.CheckOption;
import com.imageworks.migration.ColumnOption;
import com.imageworks.migration.DatabaseAdapter;
import com.imageworks.migration.ForeignKeyOption;
import com.imageworks.migration.GrantPrivilegeType;
import com.imageworks.migration.IndexOption;
import com.imageworks.migration.Migration$;
import com.imageworks.migration.MigrationArrowAssoc;
import com.imageworks.migration.Name;
import com.imageworks.migration.On;
import com.imageworks.migration.OnDelete;
import com.imageworks.migration.OnUpdate;
import com.imageworks.migration.References;
import com.imageworks.migration.SqlType;
import com.imageworks.migration.TableColumnDefinition;
import com.imageworks.migration.TableDefinition;
import com.imageworks.migration.TableOption;
import com.imageworks.migration.With$;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.Tuple2;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Migration
implements ScalaObject {
    private Option<DatabaseAdapter> adapterOpt;
    private Option<Connection> connectionOpt;
    private Option<Connection> rawConnectionOpt;
    private final Logger com$imageworks$migration$Migration$$logger = LoggerFactory.getLogger(this.getClass());

    public Migration() {
        this.rawConnectionOpt = None$.MODULE$;
        this.connectionOpt = None$.MODULE$;
        this.adapterOpt = None$.MODULE$;
    }

    public void removeCheck(On on, Seq<Name> options) {
        if (new BoxedObjectArray((Object[])on.columnNames()).isEmpty()) {
            throw new IllegalArgumentException("Removing a check constraint requires at least one column name in the table adding the constraint.");
        }
        Tuple2<String, List<CheckOption>> tuple2 = this.adapter().generateCheckConstraintName(on, options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String name = (String)tuple22._1();
        List opts = (List)tuple22._2();
        this.execute(new scala.StringBuilder().append((Object)"ALTER TABLE ").append((Object)this.adapter().quoteTableName(on.tableName())).append((Object)" DROP CONSTRAINT ").append((Object)name).toString());
    }

    public void addCheck(On on, String expr, Seq<CheckOption> options) {
        if (new BoxedObjectArray((Object[])on.columnNames()).isEmpty()) {
            throw new IllegalArgumentException("Adding a check constraint requires at least one column name in the table adding the constraint.");
        }
        DatabaseAdapter a$3 = this.adapter();
        Tuple2<String, List<CheckOption>> tuple2 = a$3.generateCheckConstraintName(on, options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String name = (String)tuple22._1();
        List opts = (List)tuple22._2();
        String quoted_on_column_names = new BoxedObjectArray((Object[])on.columnNames()).map((Function1)new $anonfun$6(this, a$3)).mkString(", ");
        StringBuilder sql = new StringBuilder(512).append("ALTER TABLE ").append(a$3.quoteTableName(on.tableName())).append(" ADD CONSTRAINT ").append(name).append(" CHECK (").append(expr).append(")");
        this.execute(sql.toString());
    }

    public final void revoke(String table_name, String grantee, Seq<GrantPrivilegeType> privileges) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{grantee})), String.class);
        this.revoke(table_name, (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object), privileges);
    }

    public final void revoke(String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        if (new BoxedObjectArray((Object[])grantees).isEmpty()) {
            throw new IllegalArgumentException("Revoking permissions requires at least one grantee.");
        }
        if (privileges.isEmpty()) {
            throw new IllegalArgumentException("Revoking permissions requires at least one privilege.");
        }
        String sql = this.adapter().revokeSql(table_name, grantees, privileges);
        this.execute(sql);
    }

    public final void grant(String table_name, String grantee, Seq<GrantPrivilegeType> privileges) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{grantee})), String.class);
        this.grant(table_name, (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object), privileges);
    }

    public final void grant(String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        if (new BoxedObjectArray((Object[])grantees).isEmpty()) {
            throw new IllegalArgumentException("Granting permissions requires at least one grantee.");
        }
        if (privileges.isEmpty()) {
            throw new IllegalArgumentException("Granting permissions requires at least one privilege.");
        }
        String sql = this.adapter().grantSql(table_name, grantees, privileges);
        this.execute(sql);
    }

    public void removeForeignKey(References references, On on, Seq<Name> options) {
        this.removeForeignKey(on, references, options);
    }

    public void removeForeignKey(On on, References references, Seq<Name> options) {
        if (on.columnNames().length == 0) {
            throw new IllegalArgumentException("Removing a foreign key constraint requires at least one column name in the table adding the constraint.");
        }
        if (references.columnNames().length == 0) {
            throw new IllegalArgumentException("Removing a foreign key constraint requires at least one column name from the table being referenced.");
        }
        Tuple2<String, List<ForeignKeyOption>> tuple2 = this.foreignKeyNameFor(on, references, options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String name = (String)tuple22._1();
        List opts = (List)tuple22._2();
        this.execute(new scala.StringBuilder().append((Object)"ALTER TABLE ").append((Object)this.adapter().quoteTableName(on.tableName())).append((Object)" DROP CONSTRAINT ").append((Object)name).toString());
    }

    public void addForeignKey(References references, On on, Seq<ForeignKeyOption> options) {
        this.addForeignKey(on, references, options);
    }

    public void addForeignKey(On on, References references, Seq<ForeignKeyOption> options) {
        String on_update_sql;
        if (on.columnNames().length == 0) {
            throw new IllegalArgumentException("Adding a foreign key constraint requires at least one column name in the table adding the constraint.");
        }
        if (references.columnNames().length == 0) {
            throw new IllegalArgumentException("Adding a foreign key constraint requires at least one column name from the table being referenced.");
        }
        Tuple2<String, List<ForeignKeyOption>> tuple2 = this.foreignKeyNameFor(on, references, options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String name = (String)tuple22._1();
        ObjectRef opts$4 = new ObjectRef((Object)((List)tuple22._2()));
        DatabaseAdapter a$2 = this.adapter();
        String quoted_on_column_names = new BoxedObjectArray((Object[])on.columnNames()).map((Function1)new $anonfun$4(this, a$2)).mkString(", ");
        String quoted_references_column_names = new BoxedObjectArray((Object[])references.columnNames()).map((Function1)new $anonfun$5(this, a$2)).mkString(", ");
        ObjectRef on_delete_opt$1 = new ObjectRef((Object)None$.MODULE$);
        ((List)opts$4.elem).filter((Function1)new $anonfun$addForeignKey$1(this)).foreach((Function1)new $anonfun$addForeignKey$2(this, opts$4, on_delete_opt$1));
        ObjectRef on_update_opt$1 = new ObjectRef((Object)None$.MODULE$);
        ((List)opts$4.elem).filter((Function1)new $anonfun$addForeignKey$3(this)).foreach((Function1)new $anonfun$addForeignKey$4(this, opts$4, on_update_opt$1));
        StringBuilder sql = new StringBuilder(512).append("ALTER TABLE ").append(a$2.quoteTableName(on.tableName())).append(" ADD CONSTRAINT ").append(name).append(" FOREIGN KEY (").append(quoted_on_column_names).append(") REFERENCES ").append(a$2.quoteTableName(references.tableName())).append(" (").append(quoted_references_column_names).append(")");
        String on_delete_sql = a$2.onDeleteSql((Option<OnDelete>)((Option)on_delete_opt$1.elem));
        if (!on_delete_sql.isEmpty()) {
            sql.append(' ').append(on_delete_sql);
        }
        if (!(on_update_sql = a$2.onUpdateSql((Option<OnUpdate>)((Option)on_update_opt$1.elem))).isEmpty()) {
            sql.append(' ').append(on_update_sql);
        }
        this.execute(sql.toString());
    }

    private Tuple2<String, List<ForeignKeyOption>> foreignKeyNameFor(On on$1, References references$1, Seq<ForeignKeyOption> options) {
        ObjectRef opts$3 = new ObjectRef((Object)options.toList());
        ObjectRef fk_name_opt$1 = new ObjectRef((Object)None$.MODULE$);
        ((List)opts$3.elem).filter((Function1)new $anonfun$foreignKeyNameFor$1(this)).foreach((Function1)new $anonfun$foreignKeyNameFor$2(this, opts$3, fk_name_opt$1));
        String name = (String)((Option)fk_name_opt$1.elem).getOrElse((Function0)new $anonfun$3(this, on$1, references$1));
        return new Tuple2((Object)name, (Object)((List)opts$3.elem));
    }

    public final void removeIndex(String table_name, String column_name, Seq<Name> options) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{column_name})), String.class);
        this.removeIndex(table_name, (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object), options);
    }

    public final void removeIndex(String table_name, String[] column_names, Seq<Name> options) {
        if (new BoxedObjectArray((Object[])column_names).isEmpty()) {
            throw new IllegalArgumentException("Removing an index requires at least one column name.");
        }
        Tuple2<String, List<IndexOption>> tuple2 = this.indexNameFor(table_name, column_names, options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String name = (String)tuple22._1();
        List opts = (List)tuple22._2();
        String sql = this.adapter().removeIndexSql(table_name, name);
        this.execute(sql);
    }

    public final void addIndex(String table_name, String column_name, Seq<IndexOption> options) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{column_name})), String.class);
        this.addIndex(table_name, (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object), options);
    }

    public final void addIndex(String table_name, String[] column_names, Seq<IndexOption> options) {
        if (new BoxedObjectArray((Object[])column_names).isEmpty()) {
            throw new IllegalArgumentException("Adding an index requires at least one column name.");
        }
        Tuple2<String, List<IndexOption>> tuple2 = this.indexNameFor(table_name, column_names, options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String name = (String)tuple22._1();
        ObjectRef opts$2 = new ObjectRef((Object)((List)tuple22._2()));
        BooleanRef unique$1 = new BooleanRef(false);
        ((List)opts$2.elem).filter((Function1)new $anonfun$addIndex$1(this)).foreach((Function1)new $anonfun$addIndex$2(this, opts$2, unique$1));
        DatabaseAdapter a$1 = this.adapter();
        String quoted_column_names = new BoxedObjectArray((Object[])column_names).map((Function1)new $anonfun$2(this, a$1)).mkString(", ");
        String sql = new StringBuilder(512).append("CREATE ").append(unique$1.elem ? "UNIQUE " : "").append("INDEX ").append(a$1.quoteColumnName(name)).append(" ON ").append(a$1.quoteTableName(table_name)).append(" (").append(quoted_column_names).append(")").toString();
        this.execute(sql);
    }

    private Tuple2<String, List<IndexOption>> indexNameFor(String table_name$1, String[] column_names$1, Seq<IndexOption> options) {
        ObjectRef opts$1 = new ObjectRef((Object)options.toList());
        ObjectRef index_name_opt$1 = new ObjectRef((Object)None$.MODULE$);
        ((List)opts$1.elem).filter((Function1)new $anonfun$indexNameFor$1(this)).foreach((Function1)new $anonfun$indexNameFor$2(this, opts$1, index_name_opt$1));
        String name = (String)((Option)index_name_opt$1.elem).getOrElse((Function0)new $anonfun$1(this, table_name$1, column_names$1));
        return new Tuple2((Object)name, (Object)((List)opts$1.elem));
    }

    public final void dropTable(String table_name) {
        String sql = new StringBuilder(512).append("DROP TABLE ").append(this.adapter().quoteTableName(table_name)).toString();
        this.execute(sql);
    }

    public final void removeColumn(String table_name, String column_name) {
        this.execute(this.adapter().removeColumnSql(table_name, column_name));
    }

    public final void alterColumn(String table_name, String column_name, SqlType column_type, Seq<ColumnOption> options) {
        this.execute(this.adapter().alterColumnSql(table_name, column_name, column_type, options));
    }

    public final void addColumn(String table_name, String column_name, SqlType column_type, Seq<ColumnOption> options) {
        TableDefinition table_definition = new TableDefinition(this.adapter(), table_name);
        table_definition.column(column_name, column_type, options);
        String sql = new StringBuilder(512).append("ALTER TABLE ").append(this.adapter().quoteTableName(table_name)).append(" ADD ").append(table_definition.toSql()).toString();
        this.execute(sql);
    }

    public final void createTable(String table_name, Seq<TableOption> options, Function1<TableDefinition, Object> body) {
        TableDefinition table_definition = new TableDefinition(this.adapter(), table_name);
        body.apply((Object)table_definition);
        String sql = new StringBuilder(512).append("CREATE TABLE ").append(this.adapter().quoteTableName(table_name)).append(" (").append(table_definition.toSql()).append(')').toString();
        this.execute(sql);
    }

    public final <R> R withResultSet(ResultSet rs, Function1<ResultSet, R> f) {
        return With$.MODULE$.resultSet(rs, f);
    }

    public final void withPreparedStatement(String sql, Function1<PreparedStatement, Object> f) {
        Connection c = this.connection();
        boolean auto_commit = c.getAutoCommit();
        try {
            c.setAutoCommit(false);
            PreparedStatement statement = c.prepareStatement(sql);
            try {
                f.apply((Object)statement);
                c.commit();
            }
            catch (Throwable throwable) {
                try {
                    c.rollback();
                }
                catch (Throwable throwable2) {
                    this.com$imageworks$migration$Migration$$logger().warn(new scala.StringBuilder().append((Object)"Trying to rollback a transaction due to ").append((Object)throwable).append((Object)" failed and threw:").toString(), throwable2);
                }
                throw throwable;
            }
            finally {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {
                    this.com$imageworks$migration$Migration$$logger().warn("Error in closing prepared statement:", throwable);
                }
            }
            return;
        }
        finally {
            c.setAutoCommit(auto_commit);
        }
    }

    public final void execute(String sql) {
        Statement statement = this.connection().createStatement();
        try {
            statement.execute(sql);
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                this.com$imageworks$migration$Migration$$logger().warn("Error in closing statement:", throwable);
            }
        }
    }

    public boolean addingForeignKeyConstraintCreatesIndex() {
        return this.adapter().addingForeignKeyConstraintCreatesIndex();
    }

    public References references(TableColumnDefinition definition) {
        return new References(definition);
    }

    public On on(TableColumnDefinition definition) {
        return new On(definition);
    }

    public MigrationArrowAssoc stringToMigrationArrowAssoc(String s) {
        return new MigrationArrowAssoc(s);
    }

    private DatabaseAdapter adapter() {
        return (DatabaseAdapter)this.adapterOpt().get();
    }

    public void adapterOpt_$eq(Option<DatabaseAdapter> x$1) {
        this.adapterOpt = x$1;
    }

    public Option<DatabaseAdapter> adapterOpt() {
        return this.adapterOpt;
    }

    public Connection connection() {
        return (Connection)this.connectionOpt().get();
    }

    public void connectionOpt_$eq(Option<Connection> x$1) {
        this.connectionOpt = x$1;
    }

    public Option<Connection> connectionOpt() {
        return this.connectionOpt;
    }

    public Connection rawConnection() {
        return (Connection)this.rawConnectionOpt().get();
    }

    public void rawConnectionOpt_$eq(Option<Connection> x$1) {
        this.rawConnectionOpt = x$1;
    }

    public Option<Connection> rawConnectionOpt() {
        return this.rawConnectionOpt;
    }

    public abstract void down();

    public abstract void up();

    public final Logger com$imageworks$migration$Migration$$logger() {
        return this.com$imageworks$migration$Migration$$logger;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

