/*
 * Decompiled with CFR 0.152.
 */
package com.imageworks.migration;

import com.imageworks.migration.AutoCommit$;
import com.imageworks.migration.CommitBehavior;
import com.imageworks.migration.CommitUponReturnOrException$;
import com.imageworks.migration.ConnectionBuilder;
import com.imageworks.migration.CreateSchemaMigrationsTableMigration;
import com.imageworks.migration.DatabaseAdapter;
import com.imageworks.migration.Down$;
import com.imageworks.migration.Migration;
import com.imageworks.migration.MigrationDirection;
import com.imageworks.migration.MigrationStatuses;
import com.imageworks.migration.Migrator$;
import com.imageworks.migration.Migrator$$anonfun$com$imageworks$migration$Migrator$;
import com.imageworks.migration.MigratorOperation;
import com.imageworks.migration.RawAndLoggingConnections;
import com.imageworks.migration.RichConnection$;
import com.imageworks.migration.Up$;
import java.rmi.RemoteException;
import java.sql.Connection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.SortedSet;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeSet;
import scala.collection.mutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Migrator
implements ScalaObject {
    private final Logger com$imageworks$migration$Migrator$$logger;
    public final DatabaseAdapter com$imageworks$migration$Migrator$$adapter;
    private final ConnectionBuilder connection_builder;

    public Migrator(ConnectionBuilder connection_builder, DatabaseAdapter adapter) {
        this.connection_builder = connection_builder;
        this.com$imageworks$migration$Migrator$$adapter = adapter;
        Class.forName("net.sf.log4jdbc.DriverSpy");
        this.com$imageworks$migration$Migrator$$logger = LoggerFactory.getLogger(this.getClass());
    }

    public Option<String> whyNotMigrated(String package_name, boolean search_sub_packages) {
        None$ none$;
        MigrationStatuses migration_statuses = this.getMigrationStatuses(package_name, search_sub_packages);
        scala.collection.SortedMap<Long, Class<? extends Migration>> not_installed = migration_statuses.not_installed();
        SortedSet<Long> installed_without_available_implementation = migration_statuses.installed_without_available_implementation();
        if (not_installed.isEmpty() && installed_without_available_implementation.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            StringBuilder sb = new StringBuilder(256);
            sb.append("The database is not fully migrated because ");
            if (!not_installed.isEmpty()) {
                sb.append("the following migrations are not installed: ");
                sb.append(not_installed.values().map((Function1)new $anonfun$whyNotMigrated$1(this)).mkString(", "));
                if (!installed_without_available_implementation.isEmpty()) {
                    sb.append(" and ");
                }
            }
            if (!installed_without_available_implementation.isEmpty()) {
                sb.append("the following migrations are installed without a matching Migration subclass: ");
                sb.append(installed_without_available_implementation.mkString(", "));
            }
            sb.append('.');
            none$ = new Some((Object)sb.toString());
        }
        return none$;
    }

    public MigrationStatuses getMigrationStatuses(String package_name, boolean search_sub_packages) {
        SortedMap available_migrations$2 = Migrator$.MODULE$.com$imageworks$migration$Migrator$$findMigrations(package_name, search_sub_packages, this.com$imageworks$migration$Migrator$$logger());
        TreeSet installed_versions = this.doesSchemaMigrationsTableExist() ? this.getInstalledVersions() : new TreeSet((Function1)new $anonfun$6(this));
        ObjectRef not_installed$1 = new ObjectRef((Object)available_migrations$2);
        ObjectRef installed_with_available_implementation$1 = new ObjectRef((Object)new TreeMap((Function1)new $anonfun$7(this)));
        ObjectRef installed_without_available_implementation$1 = new ObjectRef((Object)new TreeSet((Function1)new $anonfun$8(this)));
        installed_versions.foreach((Function1)new $anonfun$getMigrationStatuses$1(this, available_migrations$2, not_installed$1, installed_with_available_implementation$1, installed_without_available_implementation$1));
        return new MigrationStatuses((scala.collection.SortedMap<Long, Class<? extends Migration>>)((SortedMap)not_installed$1.elem), (scala.collection.SortedMap<Long, Class<? extends Migration>>)((TreeMap)installed_with_available_implementation$1.elem), (SortedSet<Long>)((TreeSet)installed_without_available_implementation$1.elem));
    }

    public void migrate(MigratorOperation operation$1, String package_name$1, boolean search_sub_packages$1) {
        this.initializeSchemaMigrationsTable();
        this.withLoggingConnection(CommitUponReturnOrException$.MODULE$, new $anonfun$migrate$1(this, operation$1, package_name$1, search_sub_packages$1));
    }

    public SortedSet<Long> getInstalledVersions() {
        return (SortedSet)this.withLoggingConnection(AutoCommit$.MODULE$, new $anonfun$getInstalledVersions$1(this));
    }

    public final SortedSet com$imageworks$migration$Migrator$$getInstalledVersions(Connection connection) {
        String sql = new scala.StringBuilder().append((Object)"SELECT version FROM ").append((Object)this.com$imageworks$migration$Migrator$$adapter.quoteTableName(Migrator$.MODULE$.schemaMigrationsTableName())).toString();
        return (SortedSet)RichConnection$.MODULE$.connectionToRichConnection(connection).withPreparedStatement(sql, new $anonfun$com$imageworks$migration$Migrator$$getInstalledVersions$1(this));
    }

    private void initializeSchemaMigrationsTable() {
        if (!this.doesSchemaMigrationsTableExist()) {
            this.com$imageworks$migration$Migrator$$runMigration(CreateSchemaMigrationsTableMigration.class, Up$.MODULE$, (Option)None$.MODULE$);
        }
    }

    private boolean doesSchemaMigrationsTableExist() {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    String smtn$1 = Migrator$.MODULE$.schemaMigrationsTableName().toLowerCase();
                    option = this.getTableNames().find((Function1)new $anonfun$doesSchemaMigrationsTableExist$1(this, smtn$1));
                    if (!(option instanceof Some)) break block2;
                    bl = true;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public final void com$imageworks$migration$Migrator$$runMigration(Class migration_class, MigrationDirection direction$1, Option version_update_opt) {
        Option option;
        block9: {
            block8: {
                block4: {
                    MigrationDirection migrationDirection;
                    block7: {
                        String string;
                        long version$1;
                        Tuple2 tuple2;
                        block6: {
                            String table_name;
                            block5: {
                                long l;
                                this.com$imageworks$migration$Migrator$$logger().info("Migrating {} with '{}'.", (Object)direction$1.str(), (Object)migration_class.getName());
                                Migration migration$1 = (Migration)migration_class.getConstructor(new Class[0]).newInstance(new Object[0]);
                                this.withConnections(AutoCommit$.MODULE$, new $anonfun$com$imageworks$migration$Migrator$$runMigration$1(this, direction$1, migration$1));
                                option = version_update_opt;
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                tuple2 = (Tuple2)some.x();
                                if (tuple2 == null) {
                                    throw new MatchError((Object)option);
                                }
                                version$1 = l = BoxesRunTime.unboxToLong((Object)tuple2._2());
                                table_name = this.com$imageworks$migration$Migrator$$adapter.quoteTableName(Migrator$.MODULE$.schemaMigrationsTableName());
                                migrationDirection = direction$1;
                                Up$ up$ = Up$.MODULE$;
                                MigrationDirection migrationDirection2 = migrationDirection;
                                if (up$ != null ? !up$.equals(migrationDirection2) : migrationDirection2 != null) break block5;
                                string = new scala.StringBuilder().append((Object)"INSERT INTO ").append((Object)table_name).append((Object)" (version) VALUES (?)").toString();
                                break block6;
                            }
                            Down$ down$ = Down$.MODULE$;
                            MigrationDirection migrationDirection3 = migrationDirection;
                            if (down$ != null ? !down$.equals(migrationDirection3) : migrationDirection3 != null) break block7;
                            string = new scala.StringBuilder().append((Object)"DELETE FROM ").append((Object)table_name).append((Object)" WHERE version = ?").toString();
                        }
                        String sql = string;
                        RichConnection$.MODULE$.connectionToRichConnection((Connection)tuple2._1()).withPreparedStatement(sql, new $anonfun$com$imageworks$migration$Migrator$$runMigration$2(this, version$1));
                        break block8;
                    }
                    throw new MatchError((Object)migrationDirection);
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public Set<String> getTableNames() {
        return (Set)this.withLoggingConnection(AutoCommit$.MODULE$, new $anonfun$getTableNames$1(this));
    }

    public <T> T withConnections(CommitBehavior commit_behavior, Function1<RawAndLoggingConnections, T> f$2) {
        return (T)this.connection_builder.withConnection(commit_behavior, new $anonfun$withConnections$1(this, f$2));
    }

    public <T> T withLoggingConnection(CommitBehavior commit_behavior, Function1<Connection, T> f$1) {
        return (T)this.connection_builder.withConnection(commit_behavior, new $anonfun$withLoggingConnection$1(this, f$1));
    }

    public Migrator(DataSource jdbc_datasource, String jdbc_username, String jdbc_password, DatabaseAdapter adapter) {
        this(new ConnectionBuilder(jdbc_datasource, jdbc_username, jdbc_password), adapter);
    }

    public Migrator(DataSource jdbc_datasource, DatabaseAdapter adapter) {
        this(new ConnectionBuilder(jdbc_datasource), adapter);
    }

    public Migrator(String jdbc_url, String jdbc_username, String jdbc_password, DatabaseAdapter adapter) {
        this(new ConnectionBuilder(jdbc_url, jdbc_username, jdbc_password), adapter);
    }

    public Migrator(String jdbc_url, DatabaseAdapter adapter) {
        this(new ConnectionBuilder(jdbc_url), adapter);
    }

    public final Logger com$imageworks$migration$Migrator$$logger() {
        return this.com$imageworks$migration$Migrator$$logger;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

