/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.security.AccessController;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.UserException;

public class Proxies {
    private static final Localizer _loc = Localizer.forPackage(Proxies.class);

    public static boolean isOwner(Proxy proxy2, OpenJPAStateManager sm, int field) {
        return proxy2.getOwner() == sm && proxy2.getOwnerField() == field;
    }

    public static void assertAllowedType(Object value, Class allowed) {
        if (value != null && allowed != null && !allowed.isInstance(value)) {
            throw new UserException(_loc.get("bad-elem-type", new Object[]{(ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(allowed)), allowed, (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(value.getClass())), value.getClass()}));
        }
    }

    public static void dirty(Proxy proxy2, boolean stopTracking) {
        if (proxy2.getOwner() != null) {
            proxy2.getOwner().dirty(proxy2.getOwnerField());
        }
        if (stopTracking && proxy2.getChangeTracker() != null) {
            proxy2.getChangeTracker().stopTracking();
        }
    }

    public static void removed(Proxy proxy2, Object removed, boolean key) {
        if (proxy2.getOwner() != null && removed != null) {
            proxy2.getOwner().removed(proxy2.getOwnerField(), removed, key);
        }
    }

    public static Object writeReplace(Proxy proxy2, boolean detachable) {
        if (detachable && (proxy2 == null || proxy2.getOwner() == null || proxy2.getOwner().isDetached())) {
            return proxy2;
        }
        return proxy2.copy(proxy2);
    }
}

