/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import com.tonicsystems.jarjar.asm.ClassReader;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.GetNameClassWriter;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class JarTransformer
implements JarProcessor {
    public boolean process(EntryStruct struct) throws IOException {
        if (struct.name.endsWith(".class")) {
            ClassReader reader;
            try {
                reader = new ClassReader(struct.in);
            }
            catch (Exception e) {
                return true;
            }
            GetNameClassWriter w = new GetNameClassWriter(1);
            reader.accept(this.transform(w), 8);
            struct.in = new ByteArrayInputStream(w.toByteArray());
            struct.name = JarTransformer.pathFromName(w.getClassName());
        }
        return true;
    }

    protected abstract ClassVisitor transform(ClassVisitor var1);

    private static String pathFromName(String className) {
        return className.replace('.', '/') + ".class";
    }
}

