/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.Binding;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.objectweb.asm.Opcodes;

public class ModuleNode
extends ASTNode
implements Opcodes {
    private BlockStatement statementBlock = new BlockStatement();
    List classes = new LinkedList();
    private List methods = new ArrayList();
    private List imports = new ArrayList();
    private List importPackages = new ArrayList();
    private Map importIndex = new HashMap();
    private Map staticImportAliases = new HashMap();
    private Map staticImportFields = new LinkedHashMap();
    private Map staticImportClasses = new LinkedHashMap();
    private CompileUnit unit;
    private String packageName;
    private String description;
    private boolean createClassForStatements = true;
    private transient SourceUnit context;
    private boolean importsResolved = false;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public ModuleNode(SourceUnit context) {
        this.context = context;
    }

    public ModuleNode(CompileUnit unit) {
        this.unit = unit;
    }

    public BlockStatement getStatementBlock() {
        return this.statementBlock;
    }

    public List getMethods() {
        return this.methods;
    }

    public List getClasses() {
        if (!(!this.createClassForStatements || this.statementBlock.isEmpty() && this.methods.isEmpty())) {
            ClassNode mainClass = this.createStatementsClass();
            this.createClassForStatements = false;
            this.classes.add(0, mainClass);
            mainClass.setModule(this);
            this.addToCompileUnit(mainClass);
        }
        return this.classes;
    }

    public List getImports() {
        return this.imports;
    }

    public List getImportPackages() {
        return this.importPackages;
    }

    public ClassNode getImport(String alias) {
        return (ClassNode)this.importIndex.get(alias);
    }

    public void addImport(String alias, ClassNode type) {
        this.imports.add(new ImportNode(type, alias));
        this.importIndex.put(alias, type);
    }

    public String[] addImportPackage(String packageName) {
        this.importPackages.add(packageName);
        return EMPTY_STRING_ARRAY;
    }

    public void addStatement(Statement node) {
        this.statementBlock.addStatement(node);
    }

    public void addClass(ClassNode node) {
        this.classes.add(node);
        node.setModule(this);
        this.addToCompileUnit(node);
    }

    private void addToCompileUnit(ClassNode node) {
        if (this.unit != null) {
            this.unit.addClass(node);
        }
    }

    public void addMethod(MethodNode node) {
        this.methods.add(node);
    }

    public void visit(GroovyCodeVisitor visitor) {
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean hasPackageName() {
        return this.packageName != null;
    }

    public SourceUnit getContext() {
        return this.context;
    }

    public String getDescription() {
        if (this.context != null) {
            return this.context.getName();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CompileUnit getUnit() {
        return this.unit;
    }

    void setUnit(CompileUnit unit) {
        this.unit = unit;
    }

    protected ClassNode createStatementsClass() {
        String name = this.getPackageName();
        if (name == null) {
            name = "";
        }
        if (this.getDescription() == null) {
            throw new RuntimeException("Cannot generate main(String[]) class for statements when we have no file description");
        }
        name = name + this.extractClassFromFileDescription();
        String baseClassName = null;
        if (this.unit != null) {
            baseClassName = this.unit.getConfig().getScriptBaseClass();
        }
        ClassNode baseClass = null;
        if (baseClassName != null) {
            baseClass = ClassHelper.make(baseClassName);
        }
        if (baseClass == null) {
            baseClass = ClassHelper.SCRIPT_TYPE;
        }
        ClassNode classNode = new ClassNode(name, 1, baseClass);
        classNode.setScript(true);
        classNode.setScriptBody(true);
        classNode.addMethod(new MethodNode("main", 9, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ClassHelper.STRING_TYPE.makeArray(), "args")}, ClassNode.EMPTY_ARRAY, new ExpressionStatement(new MethodCallExpression((Expression)new ClassExpression(ClassHelper.make(InvokerHelper.class)), "runScript", (Expression)new ArgumentListExpression(new ClassExpression(classNode), new VariableExpression("args"))))));
        classNode.addMethod(new MethodNode("run", 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, this.statementBlock));
        classNode.addConstructor(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, new BlockStatement());
        ExpressionStatement stmt = new ExpressionStatement(new MethodCallExpression((Expression)new VariableExpression("super"), "setBinding", (Expression)new ArgumentListExpression(new VariableExpression("context"))));
        classNode.addConstructor(1, new Parameter[]{new Parameter(ClassHelper.make(Binding.class), "context")}, ClassNode.EMPTY_ARRAY, stmt);
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode node = (MethodNode)iter.next();
            int modifiers = node.getModifiers();
            if ((modifiers & 0x400) != 0) {
                throw new RuntimeException("Cannot use abstract methods in a script, they are only available inside classes. Method: " + node.getName());
            }
            node.setModifiers(modifiers);
            classNode.addMethod(node);
        }
        return classNode;
    }

    protected String extractClassFromFileDescription() {
        String answer = this.getDescription();
        int idx = answer.lastIndexOf(46);
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(47)) >= 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf(File.separatorChar)) >= 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public boolean isEmpty() {
        return this.classes.isEmpty() && this.statementBlock.getStatements().isEmpty();
    }

    public void sortClasses() {
        if (this.isEmpty()) {
            return;
        }
        List classes = this.getClasses();
        LinkedList<ClassNode> sorted = new LinkedList<ClassNode>();
        int level = 1;
        while (!classes.isEmpty()) {
            Iterator cni = classes.iterator();
            while (cni.hasNext()) {
                ClassNode cn;
                ClassNode sn = cn = (ClassNode)cni.next();
                for (int i = 0; sn != null && i < level; sn = sn.getSuperClass(), ++i) {
                }
                if (sn != null && sn.isPrimaryClassNode()) continue;
                cni.remove();
                sorted.addLast(cn);
            }
            ++level;
        }
        this.classes = sorted;
    }

    public boolean hasImportsResolved() {
        return this.importsResolved;
    }

    public void setImportsResolved(boolean importsResolved) {
        this.importsResolved = importsResolved;
    }

    public Map getStaticImportAliases() {
        return this.staticImportAliases;
    }

    public Map getStaticImportClasses() {
        return this.staticImportClasses;
    }

    public Map getStaticImportFields() {
        return this.staticImportFields;
    }

    public void addStaticMethodOrField(ClassNode type, String fieldName, String alias) {
        this.staticImportAliases.put(alias, type);
        this.staticImportFields.put(alias, fieldName);
    }

    public void addStaticImportClass(String name, ClassNode type) {
        this.staticImportClasses.put(name, type);
    }
}

