/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.deferred.AnyMappingContentHandler;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLAnyCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private XMLAnyCollectionMapping xmlAnyCollectionMapping;
    private XMLDescriptor workingDescriptor;

    public XMLAnyCollectionMappingNodeValue(XMLAnyCollectionMapping xmlAnyCollectionMapping) {
        this.xmlAnyCollectionMapping = xmlAnyCollectionMapping;
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return null == xPathFragment;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlAnyCollectionMapping.isReadOnly()) {
            return false;
        }
        ContainerPolicy cp = this.xmlAnyCollectionMapping.getContainerPolicy();
        Object collection = this.xmlAnyCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (cp.hasNext(iterator)) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            return false;
        }
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            if (this.xmlAnyCollectionMapping.getConverter() != null) {
                objectValue = this.xmlAnyCollectionMapping.getConverter().convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller());
            }
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        block13: {
            try {
                QName qname;
                Object collection = unmarshalRecord.getContainerInstance(this);
                this.startElementProcessText(unmarshalRecord, collection);
                XMLDescriptor xmlDescriptor = null;
                XMLContext xmlContext = unmarshalRecord.getUnmarshaller().getXMLContext();
                if (this.xmlAnyCollectionMapping.usesXMLRoot()) {
                    String schemaType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                    XPathFragment frag = new XPathFragment();
                    if (null != schemaType && !schemaType.equals("")) {
                        frag.setXPath(schemaType);
                        if (frag.hasNamespace()) {
                            String prefix = frag.getPrefix();
                            String url = unmarshalRecord.resolveNamespacePrefix(prefix);
                            frag.setNamespaceURI(url);
                            QName qname2 = new QName(url, frag.getLocalName());
                            unmarshalRecord.setTypeQName(qname2);
                        }
                        xmlDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                    }
                }
                if (xmlDescriptor == null && (xmlDescriptor = xmlContext.getDescriptor(qname = new QName(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName()))) != null && xmlDescriptor.isWrapper()) {
                    xmlDescriptor = null;
                }
                this.workingDescriptor = xmlDescriptor;
                UnmarshalKeepAsElementPolicy policy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
                if (xmlDescriptor == null && policy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || policy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                    SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
                    builder.setOwningRecord(unmarshalRecord);
                    try {
                        String namespaceURI = "";
                        if (xPathFragment.getNamespaceURI() != null) {
                            namespaceURI = xPathFragment.getNamespaceURI();
                        }
                        String qName = xPathFragment.getLocalName();
                        if (xPathFragment.getPrefix() != null) {
                            qName = xPathFragment.getPrefix() + ":" + qName;
                        }
                        builder.startElement(namespaceURI, xPathFragment.getLocalName(), qName, atts);
                        unmarshalRecord.getXMLReader().setContentHandler(builder);
                    }
                    catch (SAXException ex) {}
                    break block13;
                }
                if (xmlDescriptor != null) {
                    this.processChild(xPathFragment, unmarshalRecord, atts, xmlDescriptor);
                    break block13;
                }
                AnyMappingContentHandler handler = new AnyMappingContentHandler(unmarshalRecord, this.xmlAnyCollectionMapping.usesXMLRoot());
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = xPathFragment.getPrefix() + ":" + qnameString;
                }
                handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                unmarshalRecord.getXMLReader().setContentHandler(handler);
                return true;
            }
            catch (SAXException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        if (null != unmarshalRecord.getChildRecord()) {
            if (!this.xmlAnyCollectionMapping.usesXMLRoot()) {
                Object objectValue = unmarshalRecord.getChildRecord().getCurrentObject();
                if (this.xmlAnyCollectionMapping.getConverter() != null) {
                    objectValue = this.xmlAnyCollectionMapping.getConverter().convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
                }
                unmarshalRecord.addAttributeValue(this, objectValue);
            }
            if (this.xmlAnyCollectionMapping.usesXMLRoot()) {
                Object childObject = unmarshalRecord.getChildRecord().getCurrentObject();
                if (this.workingDescriptor != null) {
                    String prefix = xPathFragment.getPrefix();
                    if (prefix == null && xPathFragment.getNamespaceURI() != null) {
                        prefix = unmarshalRecord.resolveNamespaceUri(xPathFragment.getNamespaceURI());
                    }
                    childObject = this.workingDescriptor.wrapObjectInXMLRoot(childObject, xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), prefix, false);
                    if (this.xmlAnyCollectionMapping.getConverter() != null) {
                        childObject = this.xmlAnyCollectionMapping.getConverter().convertDataValueToObjectValue(childObject, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
                    }
                    unmarshalRecord.addAttributeValue(this, childObject);
                }
            }
            unmarshalRecord.setChildRecord(null);
            this.workingDescriptor = null;
        } else {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
            if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && builder.getNodes().size() != 0) {
                Object node = builder.getNodes().pop();
                if (this.xmlAnyCollectionMapping.getConverter() != null) {
                    node = this.xmlAnyCollectionMapping.getConverter().convertDataValueToObjectValue(node, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
                }
                unmarshalRecord.addAttributeValue(this, node);
            } else {
                this.endElementProcessText(unmarshalRecord, collection, xPathFragment);
            }
        }
    }

    private void startElementProcessText(UnmarshalRecord unmarshalRecord, Object collection) {
        String value = unmarshalRecord.getStringBuffer().toString().trim();
        unmarshalRecord.resetStringBuffer();
        if (!"".equals(value) && this.xmlAnyCollectionMapping.isMixedContent()) {
            unmarshalRecord.addAttributeValue(this, value);
        }
    }

    private void endElementProcessText(UnmarshalRecord unmarshalRecord, Object collection, XPathFragment xPathFragment) {
        Object value = unmarshalRecord.getStringBuffer().toString().trim();
        if (this.xmlAnyCollectionMapping.getConverter() != null) {
            value = this.xmlAnyCollectionMapping.getConverter().convertDataValueToObjectValue(value, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
        }
        unmarshalRecord.resetStringBuffer();
        if (!"".equals(value) && this.xmlAnyCollectionMapping.isMixedContent()) {
            Class theClass;
            QName qname = unmarshalRecord.getTypeQName();
            if (qname != null && (theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qname)) != null) {
                value = ((XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager()).convertObject(value, theClass, qname);
            }
            if (!this.xmlAnyCollectionMapping.usesXMLRoot()) {
                unmarshalRecord.addAttributeValue(this, value);
            } else {
                XMLRoot xmlRoot = new XMLRoot();
                xmlRoot.setNamespaceURI(xPathFragment.getNamespaceURI());
                xmlRoot.setLocalName(xPathFragment.getLocalName());
                xmlRoot.setSchemaType(qname);
                xmlRoot.setObject(value);
                unmarshalRecord.addAttributeValue(this, xmlRoot);
            }
        }
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlAnyCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlAnyCollectionMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    private Namespace setupFragment(XMLRoot originalValue, XPathFragment xmlRootFragment, MarshalRecord marshalRecord) {
        Namespace generatedNamespace = null;
        String xpath = originalValue.getLocalName();
        if (originalValue.getNamespaceURI() != null) {
            xmlRootFragment.setNamespaceURI(originalValue.getNamespaceURI());
            String prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(originalValue.getNamespaceURI());
            if (prefix == null || prefix.equals("")) {
                prefix = marshalRecord.getNamespaceResolver().generatePrefix();
                generatedNamespace = new Namespace(prefix, xmlRootFragment.getNamespaceURI());
            }
            xpath = prefix + ":" + xpath;
        }
        xmlRootFragment.setXPath(xpath);
        return generatedNamespace;
    }

    public void marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (null == value) {
            return;
        }
        boolean wasXMLRoot = false;
        XPathFragment xmlRootFragment = null;
        Object originalValue = value;
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        if (this.xmlAnyCollectionMapping.usesXMLRoot() && value instanceof XMLRoot) {
            xmlRootFragment = new XPathFragment();
            wasXMLRoot = true;
            value = ((XMLRoot)value).getObject();
        }
        UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
        if (value instanceof String) {
            this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, value, session, namespaceResolver);
        } else if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
        } else {
            Namespace generatedNamespace;
            AbstractSession childSession;
            try {
                childSession = marshaller.getXMLContext().getSession(value);
            }
            catch (XMLMarshalException e) {
                this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, value, session, namespaceResolver);
                return;
            }
            XMLDescriptor descriptor = (XMLDescriptor)childSession.getDescriptor(value);
            TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
            ArrayList<Namespace> extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session);
            if (wasXMLRoot && (generatedNamespace = this.setupFragment((XMLRoot)originalValue, xmlRootFragment, marshalRecord)) != null) {
                if (extraNamespaces == null) {
                    extraNamespaces = new ArrayList<Namespace>();
                }
                extraNamespaces.add(generatedNamespace);
            }
            String defaultRootElementString = descriptor.getDefaultRootElement();
            if (!wasXMLRoot && defaultRootElementString == null) {
                AbstractSessionLog.getLog().log(6, "marshal_warning_null_document_root_element", new Object[]{Helper.getShortClassName(this.getClass()), descriptor});
            } else {
                XPathFragment rootFragment;
                if (marshaller != null && marshaller.getMarshalListener() != null) {
                    marshaller.getMarshalListener().beforeMarshal(value);
                }
                if (xmlRootFragment != null) {
                    rootFragment = xmlRootFragment;
                } else {
                    rootFragment = new XPathFragment(defaultRootElementString);
                    if (rootFragment.getNamespaceURI() == null && rootFragment.getPrefix() != null) {
                        String uri = descriptor.getNonNullNamespaceResolver().resolveNamespacePrefix(rootFragment.getPrefix());
                        rootFragment.setNamespaceURI(uri);
                    }
                }
                if (!wasXMLRoot) {
                    marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
                }
                this.getXPathNode().startElement(marshalRecord, rootFragment, object, childSession, marshalRecord.getNamespaceResolver(), objectBuilder, value);
                this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
                if (this.xmlAnyCollectionMapping.shouldAddXsiType(marshaller, descriptor, originalValue, wasXMLRoot)) {
                    String typeValue = descriptor.getSchemaReference().getSchemaContext();
                    this.addTypeAttribute(descriptor, marshalRecord, typeValue);
                }
                objectBuilder.buildRow((AbstractRecord)marshalRecord, value, session, marshaller);
                objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
                marshalRecord.endElement(rootFragment, namespaceResolver);
                if (marshaller != null && marshaller.getMarshalListener() != null) {
                    marshaller.getMarshalListener().afterMarshal(value);
                }
            }
        }
    }

    private void marshalSimpleValue(XPathFragment xmlRootFragment, MarshalRecord marshalRecord, Object originalValue, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (xmlRootFragment != null) {
            QName qname = ((XMLRoot)originalValue).getSchemaType();
            value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, qname);
            Namespace generatedNamespace = this.setupFragment((XMLRoot)originalValue, xmlRootFragment, marshalRecord);
            this.getXPathNode().startElement(marshalRecord, xmlRootFragment, object, session, namespaceResolver, null, null);
            if (generatedNamespace != null) {
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + generatedNamespace.getPrefix(), generatedNamespace.getNamespaceURI());
            }
            if (qname != null) {
                String prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(qname.getNamespaceURI());
                if (prefix == null || prefix.equals("")) {
                    prefix = marshalRecord.getNamespaceResolver().generatePrefix();
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, qname.getNamespaceURI());
                }
                String typeValue = prefix + ":" + qname.getLocalPart();
                this.addTypeAttribute(marshalRecord, typeValue);
            }
        }
        marshalRecord.characters((String)value);
        if (xmlRootFragment != null) {
            marshalRecord.endElement(xmlRootFragment, namespaceResolver);
        }
    }

    public XMLAnyCollectionMapping getMapping() {
        return this.xmlAnyCollectionMapping;
    }
}

