/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.context;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.context.annotation.AnnotationConfigBeanDefinitionParser;
import org.springframework.context.annotation.AnnotationConfigUtils;


/**
 * TODO: JAVADOC
 * TODO: should use same logic as {@link AnnotationConfigBeanDefinitionParser} once it's been decoupled from XML.
 *
 * @author Chris Beams
 */
class AnnotationDrivenConfigHandler implements ConfigurationPlugin<AnnotationDrivenConfig> {

    public void handle(AnnotationDrivenConfig annotation, BeanDefinitionRegistry registry) {

        // this is lifted right from AnnotationConfigBeanDefinitionParser
        AnnotationConfigUtils.registerAnnotationConfigProcessors(registry);
    }

}
