/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.xmlbootstrap;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.sameInstance;

import static org.junit.Assert.assertThat;

import org.junit.Test;

import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.common.domain.company.Company;


/** TODO: JAVADOC */
public class BootstrapJavaConfigViaXmlTests {

    @Test
    public void testBootstrappingJavaConfigViaXml() {
        ClassPathXmlApplicationContext ctx =
            new ClassPathXmlApplicationContext("simpleConfiguration.xml", test.common.domain.company._package.class);

        Company company = (Company) ctx.getBean("company");

        assertThat(company.getName(), equalTo("SpringSource"));
        assertThat(company.getWorkers().size(), equalTo(2));
        assertThat(company.getOwners().size(), equalTo(1));
        assertThat(company.getWorkers().iterator().next(), sameInstance(ctx.getBean("mark")));
    }

}
